/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.interfaces.questing;

import cc.pe3epwithyou.trident.feature.questing.Quest;
import cc.pe3epwithyou.trident.feature.questing.QuestStorage;
import cc.pe3epwithyou.trident.interfaces.questing.QuestDialogTitle;
import cc.pe3epwithyou.trident.interfaces.questing.widgets.QuestWidget;
import cc.pe3epwithyou.trident.interfaces.shared.TridentDialog;
import cc.pe3epwithyou.trident.interfaces.themes.TridentThemed;
import cc.pe3epwithyou.trident.state.FontCollection;
import cc.pe3epwithyou.trident.state.Game;
import cc.pe3epwithyou.trident.state.MCCIState;
import cc.pe3epwithyou.trident.utils.extensions.ComponentExtensions;
import com.noxcrew.sheeplib.LayoutConstants;
import com.noxcrew.sheeplib.layout.GridLayoutBuilder;
import com.noxcrew.sheeplib.theme.Theme;
import com.noxcrew.sheeplib.theme.Themed;
import com.noxcrew.sheeplib.util.IntColorUtilKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import net.minecraft.class_8021;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u00020\n8\u0014@\u0014X\u0094\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00188\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcc/pe3epwithyou/trident/interfaces/questing/QuestingDialog;", "Lcc/pe3epwithyou/trident/interfaces/shared/TridentDialog;", "Lcom/noxcrew/sheeplib/theme/Themed;", "", "x", "y", "", "key", "<init>", "(IILjava/lang/String;)V", "Lcc/pe3epwithyou/trident/interfaces/questing/QuestDialogTitle;", "getTitleWidget", "()Lcc/pe3epwithyou/trident/interfaces/questing/QuestDialogTitle;", "Lnet/minecraft/class_7845;", "layout", "()Lnet/minecraft/class_7845;", "", "refresh", "()V", "title", "Lcc/pe3epwithyou/trident/interfaces/questing/QuestDialogTitle;", "getTitle", "setTitle", "(Lcc/pe3epwithyou/trident/interfaces/questing/QuestDialogTitle;)V", "Lcom/noxcrew/sheeplib/theme/Theme;", "getTheme", "()Lcom/noxcrew/sheeplib/theme/Theme;", "theme", "Companion", "Trident"})
@SourceDebugExtension(value={"SMAP\nQuestingDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestingDialog.kt\ncc/pe3epwithyou/trident/interfaces/questing/QuestingDialog\n+ 2 GridLayoutBuilder.kt\ncom/noxcrew/sheeplib/layout/GridLayoutBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n106#2:99\n97#2,2:100\n99#2:104\n1869#3,2:102\n*S KotlinDebug\n*F\n+ 1 QuestingDialog.kt\ncc/pe3epwithyou/trident/interfaces/questing/QuestingDialog\n*L\n70#1:99\n70#1:100,2\n70#1:104\n89#1:102,2\n*E\n"})
public final class QuestingDialog
extends TridentDialog
implements Themed {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ TridentThemed $$delegate_0;
    @NotNull
    private QuestDialogTitle title;
    @NotNull
    private static Game currentGame = MCCIState.INSTANCE.getGame();
    private static boolean isDesynced;

    public QuestingDialog(int x, int y, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(x, y, key);
        this.$$delegate_0 = TridentThemed.INSTANCE;
        this.title = this.getTitleWidget();
    }

    private final QuestDialogTitle getTitleWidget() {
        class_5250 icon = FontCollection.INSTANCE.get("_fonts/icon/quest_log.png").method_27696(class_2583.field_24360.method_65302(IntColorUtilKt.opacity((int)0, (int)0)));
        String titleText = isDesynced ? " DESYNCED" : " QUESTS";
        class_5250 class_52502 = class_2561.method_43470((String)titleText);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        class_5250 title = ComponentExtensions.withTridentFont$default(ComponentExtensions.INSTANCE, class_52502, "hud_title", 0, 2, null);
        if (isDesynced) {
            class_5250 class_52503 = class_2561.method_43470((String)" \u26a0");
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
            title.method_10852((class_2561)ComponentExtensions.INSTANCE.defaultFont(class_52503));
            title.method_27692(class_124.field_1065);
        }
        int backgroundColor = IntColorUtilKt.opacity((int)232191, (int)127);
        class_5250 gameIcon = FontCollection.INSTANCE.get(currentGame.getIcon()).method_27696(class_2583.field_24360.method_65302(IntColorUtilKt.opacity((int)0, (int)0)).method_10977(class_124.field_1068));
        class_5250 class_52504 = icon.method_10852((class_2561)title);
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"append(...)");
        class_5250 class_52505 = class_52504;
        Intrinsics.checkNotNull((Object)gameIcon);
        class_5250 class_52506 = gameIcon;
        int n = IntColorUtilKt.opacity((int)currentGame.getPrimaryColor(), (int)127);
        class_7919 class_79192 = !isDesynced ? null : class_7919.method_47407((class_2561)((class_2561)class_2561.method_43470((String)"Module is not synced.\nTrident has detected that quest progress is not up to date. Please open your Quest Log to update it.").method_27692(class_124.field_1080)));
        return new QuestDialogTitle(this, (class_2561)class_52505, backgroundColor, true, class_79192, (class_2561)class_52506, n);
    }

    @NotNull
    protected QuestDialogTitle getTitle() {
        return this.title;
    }

    protected void setTitle(@NotNull QuestDialogTitle questDialogTitle) {
        Intrinsics.checkNotNullParameter((Object)((Object)questDialogTitle), (String)"<set-?>");
        this.title = questDialogTitle;
    }

    @NotNull
    protected class_7845 layout() {
        GridLayoutBuilder gridLayoutBuilder;
        Themed $this$grid$iv = this;
        boolean $i$f$grid = false;
        int spacing$iv$iv = $this$grid$iv.getTheme().getDimensions().getPaddingInner();
        boolean $i$f$GridLayout = false;
        GridLayoutBuilder $this$layout_u24lambda_u241 = gridLayoutBuilder = new GridLayoutBuilder(0, 0, spacing$iv$iv);
        boolean bl = false;
        class_327 font = class_310.method_1551().field_1772;
        List<Quest> quests = QuestStorage.INSTANCE.getActiveQuests(currentGame);
        if (currentGame == Game.HUB || currentGame == Game.FISHING) {
            String string = "Join a game to\nview quests".toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            class_5250 class_52502 = class_2561.method_43470((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            class_5250 class_52503 = ComponentExtensions.mccFont$default(ComponentExtensions.INSTANCE, class_52502, null, 0, 3, null);
            Integer n = class_124.field_1080.method_532();
            Intrinsics.checkNotNull((Object)n);
            GridLayoutBuilder.atBottom$default((GridLayoutBuilder)$this$layout_u24lambda_u241, (class_8021)((class_8021)new class_7940((class_2561)class_52503.method_54663(n.intValue()), font)), (int)0, (int)0, (class_7847)LayoutConstants.INSTANCE.getLEFT(), (int)2, null);
        } else if (quests.isEmpty()) {
            String string = "No quests detected".toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            class_5250 class_52504 = class_2561.method_43470((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
            GridLayoutBuilder.atBottom$default((GridLayoutBuilder)$this$layout_u24lambda_u241, (class_8021)((class_8021)new class_7842((class_2561)ComponentExtensions.mccFont$default(ComponentExtensions.INSTANCE, class_52504, null, 0, 3, null).method_27692(class_124.field_1080), font)), (int)0, (int)0, null, (int)6, null);
        } else {
            Iterable $this$forEach$iv = quests;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Quest q = (Quest)element$iv;
                boolean bl2 = false;
                GridLayoutBuilder.atBottom$default((GridLayoutBuilder)$this$layout_u24lambda_u241, (class_8021)((class_8021)new QuestWidget(q, this)), (int)0, (int)0, (class_7847)LayoutConstants.INSTANCE.getLEFT(), (int)2, null);
            }
        }
        return gridLayoutBuilder.build();
    }

    @Override
    public void refresh() {
        this.setTitle(this.getTitleWidget());
        super.refresh();
    }

    @NotNull
    public Theme getTheme() {
        return this.$$delegate_0.getTheme();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcc/pe3epwithyou/trident/interfaces/questing/QuestingDialog$Companion;", "", "<init>", "()V", "Lcc/pe3epwithyou/trident/state/Game;", "currentGame", "Lcc/pe3epwithyou/trident/state/Game;", "getCurrentGame", "()Lcc/pe3epwithyou/trident/state/Game;", "setCurrentGame", "(Lcc/pe3epwithyou/trident/state/Game;)V", "", "isDesynced", "Z", "()Z", "setDesynced", "(Z)V", "Trident"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Game getCurrentGame() {
            return currentGame;
        }

        public final void setCurrentGame(@NotNull Game game) {
            Intrinsics.checkNotNullParameter((Object)((Object)game), (String)"<set-?>");
            currentGame = game;
        }

        public final boolean isDesynced() {
            return isDesynced;
        }

        public final void setDesynced(boolean bl) {
            isDesynced = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

