/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.state;

import cc.pe3epwithyou.trident.client.TridentClient;
import cc.pe3epwithyou.trident.feature.fishing.OverclockClock;
import cc.pe3epwithyou.trident.state.PlayerState;
import cc.pe3epwithyou.trident.utils.ChatUtils;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcc/pe3epwithyou/trident/state/PlayerStateIO;", "", "<init>", "()V", "", "save", "Lcc/pe3epwithyou/trident/state/PlayerState;", "load", "()Lcc/pe3epwithyou/trident/state/PlayerState;", "Ljava/nio/file/Path;", "path", "Ljava/nio/file/Path;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "Trident"})
@SourceDebugExtension(value={"SMAP\nPlayerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerState.kt\ncc/pe3epwithyou/trident/state/PlayerStateIO\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,153:1\n205#2:154\n222#2:155\n*S KotlinDebug\n*F\n+ 1 PlayerState.kt\ncc/pe3epwithyou/trident/state/PlayerStateIO\n*L\n118#1:154\n131#1:155\n*E\n"})
public final class PlayerStateIO {
    @NotNull
    public static final PlayerStateIO INSTANCE = new PlayerStateIO();
    @NotNull
    private static final Path path;
    @NotNull
    private static final Json json;

    private PlayerStateIO() {
    }

    /*
     * WARNING - void declaration
     */
    public final void save() {
        void this_$iv;
        PlayerState serializable = TridentClient.Companion.getPlayerState();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Json json = PlayerStateIO.json;
        PlayerState value$iv = serializable;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String text = this_$iv.encodeToString((SerializationStrategy)PlayerState.Companion.serializer(), (Object)value$iv);
        Path tmp = path.resolveSibling(path.getFileName() + ".tmp");
        Object[] objectArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        Files.writeString(tmp, (CharSequence)text, (OpenOption[])objectArray);
        objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
        Files.move(tmp, path, (CopyOption[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PlayerState load() {
        void this_$iv;
        ChatUtils.INSTANCE.info("Loading player state from " + path);
        if (!Files.exists(path, new LinkOption[0])) {
            return new PlayerState(null, null, null, false, 15, null);
        }
        String text = Files.readString(path);
        Json json = PlayerStateIO.json;
        Intrinsics.checkNotNull((Object)text);
        String string$iv = text;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        PlayerState serializable = (PlayerState)this_$iv.decodeFromString((DeserializationStrategy)PlayerState.Companion.serializer(), string$iv);
        serializable.getSupplies().getOverclocks().getUnstable().getState().setDuration(300L);
        serializable.getSupplies().getOverclocks().getSupreme().getState().setDuration(600L);
        serializable.getSupplies().getOverclocks().getUnstable().getState().setCooldownDuration(2700L);
        serializable.getSupplies().getOverclocks().getSupreme().getState().setCooldownDuration(3600L);
        if (serializable.getSupplies().getOverclocks().getUnstable().getState().isActive() || serializable.getSupplies().getOverclocks().getUnstable().getState().isCooldown()) {
            OverclockClock.INSTANCE.registerHandler(new OverclockClock.ClockHandler("Unstable", serializable.getSupplies().getOverclocks().getUnstable().getState()));
        }
        if (serializable.getSupplies().getOverclocks().getSupreme().getState().isActive() || serializable.getSupplies().getOverclocks().getSupreme().getState().isCooldown()) {
            OverclockClock.INSTANCE.registerHandler(new OverclockClock.ClockHandler("Supreme", serializable.getSupplies().getOverclocks().getSupreme().getState()));
        }
        return serializable;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(true);
        return Unit.INSTANCE;
    }

    static {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("trident").resolve("playerstate.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        PlayerStateIO.path = path;
        json = JsonKt.Json$default(null, PlayerStateIO::json$lambda$0, (int)1, null);
    }
}

