/*
 * Decompiled with CFR 0.152.
 */
package com.aeroshide.specspoof;

import com.aeroshide.specspoof.config.DataHolder;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_9191;

public final class FakeFPSManager {
    private static final AtomicLong lastAppliedNano = new AtomicLong(0L);
    private static final long HALF_SECOND_NANOS = 500000000L;
    private static volatile WeakReference<class_9191> registeredFrameLogRef = new WeakReference<Object>(null);
    public static volatile int cachedFps = 60;
    private static volatile int cachedThreshold = 30;

    private FakeFPSManager() {
    }

    public static void updateCache() {
        cachedFps = DataHolder.getDaFPS();
        cachedThreshold = DataHolder.getDisableFPSThreshold();
    }

    public static int computeFakeIntFps(int actualFps) {
        if (cachedFps <= 60) {
            return actualFps;
        }
        if (actualFps < cachedThreshold) {
            return actualFps;
        }
        int jitter = (ThreadLocalRandom.current().nextInt() & 0x3F) - 32;
        return cachedFps + jitter;
    }

    public static double computeFakeDoubleFps(int actualFps) {
        return FakeFPSManager.computeFakeIntFps(actualFps);
    }

    public static boolean shouldApplyFakeNow(long now) {
        return lastAppliedNano.getAndUpdate(last -> now - last >= 500000000L ? now : last) != now;
    }

    public static double getMillisecondsPerFrame(double realNanosecondsPerFrame) {
        double realMs = realNanosecondsPerFrame <= 0.0 ? 1000.0 / (double)Math.max(1, cachedFps) : realNanosecondsPerFrame / 1000000.0;
        int actualFps = (int)Math.round(1000.0 / Math.max(1.0E-6, realMs));
        if (cachedFps <= 60 || actualFps < cachedThreshold) {
            return realMs;
        }
        int fakeFps = FakeFPSManager.computeFakeIntFps(actualFps);
        if (fakeFps <= 0) {
            return realMs;
        }
        double targetMs = 1000.0 / (double)fakeFps;
        double jitterMs = (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.5;
        return Math.max(0.0, targetMs + jitterMs);
    }

    public static void registerFrameLog(class_9191 instance) {
        registeredFrameLogRef = new WeakReference<class_9191>(instance);
    }

    public static void unregisterFrameLog() {
        registeredFrameLogRef = new WeakReference<Object>(null);
    }

    public static boolean isRegisteredFrameLog(class_9191 instance) {
        class_9191 inst = (class_9191)registeredFrameLogRef.get();
        return inst != null && inst == instance;
    }
}

