/*
 * Decompiled with CFR 0.152.
 */
package com.aeroshide.specspoof.config;

import com.aeroshide.specspoof.FakeFPSManager;
import com.aeroshide.specspoof.SpecSpoofClient;
import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.Locale;
import java.util.function.Supplier;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class DataHolder {
    private static String daCPUName;
    private static String daGPUName;
    private static String daGPUVendor;
    private static String daGPUDriver;
    private static String daGPUBackend;
    private static int daFPS;
    private static int disableFPSThreshold;
    public static final int GPU_RENDERER = 7937;
    public static final int GPU_VENDOR = 7936;
    public static final int GPU_VERSION = 7938;

    public static String getDaCPUName() {
        if (daCPUName == null) {
            DataHolder.fetchOptions();
        }
        return daCPUName;
    }

    public static String getDaGPUName() {
        if (daGPUName == null) {
            DataHolder.fetchOptions();
        }
        return daGPUName;
    }

    public static String getDaGPUVendor() {
        if (daGPUVendor == null) {
            DataHolder.fetchOptions();
        }
        return daGPUVendor;
    }

    public static String getDaGPUDriver() {
        if (daGPUDriver == null) {
            DataHolder.fetchOptions();
        }
        return daGPUDriver;
    }

    public static String getDaGPUBackend() {
        if (daGPUBackend == null) {
            DataHolder.fetchOptions();
        }
        return daGPUBackend;
    }

    public static int getDaFPS() {
        if (daFPS == 0) {
            DataHolder.fetchOptions();
        }
        return daFPS;
    }

    public static int getDisableFPSThreshold() {
        if (disableFPSThreshold == 0) {
            DataHolder.fetchOptions();
        }
        return disableFPSThreshold;
    }

    public static void fetchOptions() {
        try {
            if (SpecSpoofClient.config == null) {
                throw new IllegalStateException("Config is not initialized");
            }
            DataHolder.setOptionIfAbsent("CPU", DataHolder::fetchCPUData);
            DataHolder.setOptionIfAbsent("GPU", () -> GlStateManager._getString((int)7937));
            DataHolder.setOptionIfAbsent("GPUVendor", () -> GlStateManager._getString((int)7936));
            DataHolder.setOptionIfAbsent("GPUDriverVersion", () -> GlStateManager._getString((int)7938));
            DataHolder.setOptionIfAbsent("GPUBackend", () -> "OpenGL");
            DataHolder.setOptionIfAbsent("FakeFPS", () -> 1000);
            DataHolder.setOptionIfAbsent("DisableFakeFPSThreshold", () -> 100);
            daCPUName = (String)SpecSpoofClient.config.getOption("CPU");
            daGPUName = (String)SpecSpoofClient.config.getOption("GPU");
            daFPS = SpecSpoofClient.config.getOption("FakeFPS") instanceof Number ? ((Number)SpecSpoofClient.config.getOption("FakeFPS")).intValue() : 0;
            daGPUVendor = (String)SpecSpoofClient.config.getOption("GPUVendor");
            daGPUDriver = (String)SpecSpoofClient.config.getOption("GPUDriverVersion");
            daGPUBackend = (String)SpecSpoofClient.config.getOption("GPUBackend");
            disableFPSThreshold = SpecSpoofClient.config.getOption("DisableFakeFPSThreshold") instanceof Number ? ((Number)SpecSpoofClient.config.getOption("DisableFakeFPSThreshold")).intValue() : 0;
            FakeFPSManager.updateCache();
        }
        catch (Exception e) {
            SpecSpoofClient.LOG.error("Failed to fetch options: " + e.getMessage());
            e.printStackTrace();
            daCPUName = "Unknown CPU";
            daGPUName = "Unknown GPU";
            daFPS = 0;
            daGPUVendor = "Unknown Vendor";
            daGPUDriver = "Unknown Driver";
            daGPUBackend = "Maybe OpenGL";
            disableFPSThreshold = 0;
        }
    }

    public static String fetchCPUData() {
        try {
            CentralProcessor centralProcessor = new SystemInfo().getHardware().getProcessor();
            return String.format(Locale.ROOT, "%dx %s", centralProcessor.getLogicalProcessorCount(), centralProcessor.getProcessorIdentifier().getName()).replaceAll("\\s+", " ");
        }
        catch (NoClassDefFoundError e) {
            SpecSpoofClient.LOG.error("Unable to fetch hardware information, init will be inaccurate!");
            return "1x unknown";
        }
    }

    private static <T> void setOptionIfAbsent(String optionKey, Supplier<T> valueSupplier) {
        if (SpecSpoofClient.config.getOption(optionKey) == null) {
            SpecSpoofClient.config.setOption(optionKey, valueSupplier.get());
        }
    }
}

