/*
 * Decompiled with CFR 0.152.
 */
package com.aeroshide.specspoof.mixins.compat.sodiumextra;

import com.aeroshide.specspoof.FakeFPSManager;
import com.aeroshide.specspoof.compat.SodiumReflectionHelper;
import java.util.Deque;
import me.flashyreese.mods.sodiumextra.client.FrameCounter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FrameCounter.class}, remap=false)
public class FrameCounterMixin {
    private static final Logger LOGGER = LogManager.getLogger((String)"SpecSpoof/SodiumCompat");
    private static final boolean DEBUG = false;
    private static boolean reflectionReady = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"onFrame"}, at={@At(value="HEAD")})
    private void replaceSamplesBeforeRecompute(CallbackInfo ci) {
        long updateIntervalNanos;
        long lastUpdateTime;
        boolean willRecompute;
        if (!reflectionReady && !(reflectionReady = SodiumReflectionHelper.initialize())) {
            return;
        }
        if (FakeFPSManager.cachedFps <= 60) {
            return;
        }
        long now = System.nanoTime();
        boolean bl = willRecompute = now - (lastUpdateTime = SodiumReflectionHelper.getLastUpdateTime(this)) >= (updateIntervalNanos = SodiumReflectionHelper.getUpdateIntervalNanos(this));
        if (!willRecompute) {
            return;
        }
        if (!FakeFPSManager.shouldApplyFakeNow(now)) {
            return;
        }
        Deque<?> samples = SodiumReflectionHelper.getSamples(this);
        if (samples == null) {
            return;
        }
        try {
            int actualFps = this.calculateAverageFromExistingSamples(samples);
            int fakeFps = FakeFPSManager.computeFakeIntFps(actualFps);
            if (fakeFps == actualFps) {
                return;
            }
            Deque<?> deque = samples;
            synchronized (deque) {
                samples.clear();
                long windowNanos = SodiumReflectionHelper.getWindowNanos(this);
                long deltaNanos = Math.max(1L, 1000000000L / (long)fakeFps);
                int sampleCount = Math.min(100, (int)(windowNanos / deltaNanos) + 2);
                for (int i = 0; i < sampleCount; ++i) {
                    long timestamp = now - (long)(sampleCount - 1 - i) * deltaNanos;
                    samples.addLast(SodiumReflectionHelper.createFrameSample(timestamp, deltaNanos));
                }
            }
            SodiumReflectionHelper.setLastFrameTime(this, now);
        }
        catch (Exception e) {
            LOGGER.error("SpecSpoof: Injection failed", (Throwable)e);
        }
    }

    @Unique
    private int calculateAverageFromExistingSamples(Deque<?> samples) {
        if (samples.isEmpty()) {
            return 0;
        }
        long totalDelta = 0L;
        int count = 0;
        for (Object sample : samples) {
            try {
                totalDelta += SodiumReflectionHelper.getDeltaFromSample(sample);
                ++count;
            }
            catch (Exception exception) {}
        }
        return count > 0 && totalDelta > 0L ? (int)Math.round((double)count * 1.0E9 / (double)totalDelta) : 0;
    }
}

