/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod;

import com.example.firefearmod.ai.FireFearGoal;
import com.example.firefearmod.ai.LightFearGoal;
import com.example.firefearmod.config.ConfigHolder;
import com.example.firefearmod.manager.FearGroup;
import com.example.firefearmod.manager.FearGroupManager;
import com.example.firefearmod.manager.IFearProfile;
import com.example.firefearmod.trauma.TraumaGroup;
import com.example.firefearmod.trauma.TraumaGroupManager;
import com.example.firefearmod.trauma.TraumaProfile;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="firefearmod")
public class FireFearEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!mob.m_9236_().f_46443_) {
                if (((Boolean)ConfigHolder.INTERGENERATIONAL_TRAUMA_ENABLED.get()).booleanValue()) {
                    List<TraumaGroup> traumaGroups = TraumaGroupManager.getGroupsForMob(mob);
                    if (!traumaGroups.isEmpty()) {
                        TraumaProfile profile = new TraumaProfile(mob, traumaGroups);
                        mob.f_21345_.m_25352_(0, (Goal)new FireFearGoal(mob, profile));
                    }
                } else {
                    Optional<FearGroup> groupOpt = FearGroupManager.getGroupForMob(mob);
                    groupOpt.ifPresent(group -> {
                        if (FearGroupManager.isLightFearEnabledForGroup(group)) {
                            mob.f_21345_.m_25352_(4, (Goal)new LightFearGoal(mob, (FearGroup)group));
                        }
                        mob.f_21345_.m_25352_(0, (Goal)new FireFearGoal(mob, (IFearProfile)group));
                    });
                }
            }
        }
    }
}

