/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.breeding;

import com.example.firefearmod.breeding.ForcedBreedingManager;
import com.example.firefearmod.breeding.ForcedBreedingRule;
import com.example.firefearmod.config.ConfigHolder;
import com.example.firefearmod.trauma.ITraumaData;
import com.example.firefearmod.trauma.TraumaCapability;
import com.example.firefearmod.trauma.TraumaGroup;
import com.example.firefearmod.trauma.TraumaGroupManager;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="firefearmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForcedBreedingEvents {
    private static final String BREEDING_TAG = "firefearmod_breeding";
    private static final String FORCED_PREFIX = "forced_cd_";

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent event) {
        Mob mob;
        block16: {
            block15: {
                if (!((Boolean)ConfigHolder.INTERGENERATIONAL_TRAUMA_ENABLED.get()).booleanValue()) {
                    return;
                }
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Mob)) break block15;
                mob = (Mob)livingEntity;
                if (!mob.m_9236_().f_46443_) break block16;
            }
            return;
        }
        List<ForcedBreedingRule> rules = ForcedBreedingManager.getRulesFor(mob, ItemStack.f_41583_);
        if (rules.isEmpty()) {
            return;
        }
        Level level = mob.m_9236_();
        CompoundTag root = mob.getPersistentData();
        CompoundTag breeding = root.m_128469_(BREEDING_TAG);
        boolean hadBreedingTag = root.m_128425_(BREEDING_TAG, 10);
        for (ForcedBreedingRule rule : rules) {
            EntityType type;
            Entity entity;
            AABB childBox;
            int children;
            ResourceLocation childId;
            EntityType childType;
            String partnerKey;
            CompoundTag partnerRoot;
            CompoundTag partnerBreeding;
            String key;
            int cd;
            if (!rule.enabled() || (cd = breeding.m_128451_(key = FORCED_PREFIX + rule.id())) > 0) continue;
            double radius = rule.partnerRadius();
            AABB box = mob.m_20191_().m_82377_(radius, radius * 0.5, radius);
            List candidates = level.m_6443_(Mob.class, box, m -> m != mob && m.m_6095_() == mob.m_6095_());
            if (candidates.isEmpty()) continue;
            Mob partner = (Mob)candidates.get(0);
            ResourceLocation requiredHeld = rule.requiredHeldItem();
            if (requiredHeld != null) {
                boolean ok = false;
                ResourceLocation aMainId = ForgeRegistries.ITEMS.getKey((Object)mob.m_21205_().m_41720_());
                ResourceLocation bMainId = ForgeRegistries.ITEMS.getKey((Object)partner.m_21205_().m_41720_());
                if (aMainId != null && aMainId.equals((Object)requiredHeld)) {
                    ok = true;
                }
                if (!ok && bMainId != null && bMainId.equals((Object)requiredHeld)) {
                    ok = true;
                }
                if (!ok) continue;
            }
            if ((partnerBreeding = (partnerRoot = partner.getPersistentData()).m_128469_(BREEDING_TAG)).m_128451_(partnerKey = FORCED_PREFIX + rule.id()) > 0 || (childType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(childId = rule.child())) == null || (children = level.m_6443_(Mob.class, childBox = mob.m_20191_().m_82377_(radius, radius * 0.5, radius), m -> m.m_6095_() == childType).size()) >= rule.maxNearbyChildren() || !((entity = (type = childType).m_20615_(level)) instanceof Mob)) continue;
            Mob child = (Mob)entity;
            if (child instanceof AgeableMob) {
                AgeableMob ageableChild = (AgeableMob)child;
                ageableChild.m_6863_(true);
            } else if (child instanceof Zombie) {
                Zombie zombieChild = (Zombie)child;
                zombieChild.m_6863_(true);
            }
            double x = (mob.m_20185_() + partner.m_20185_()) * 0.5;
            double y = (mob.m_20186_() + partner.m_20186_()) * 0.5;
            double z = (mob.m_20189_() + partner.m_20189_()) * 0.5;
            child.m_7678_(x, y, z, 0.0f, 0.0f);
            level.m_7967_((Entity)child);
            ITraumaData childData = (ITraumaData)TraumaCapability.get(child).orElse(null);
            ITraumaData dataA = (ITraumaData)TraumaCapability.get(mob).orElse(null);
            ITraumaData dataB = (ITraumaData)TraumaCapability.get(partner).orElse(null);
            if (childData != null && (dataA != null || dataB != null)) {
                int maxStagesGlobal = (Integer)ConfigHolder.MAX_TRAUMA_STAGES_PER_GROUP.get();
                List<TraumaGroup> childGroups = TraumaGroupManager.getGroupsForMob(child);
                for (TraumaGroup g : childGroups) {
                    int stageB;
                    int stageA = dataA != null ? dataA.getStage(g.id()) : 0;
                    int inherited = Math.max(stageA, stageB = dataB != null ? dataB.getStage(g.id()) : 0);
                    if (inherited <= 0) continue;
                    childData.setStage(g.id(), inherited, maxStagesGlobal);
                }
                childData.clampStages(maxStagesGlobal);
            }
            breeding.m_128405_(key, rule.cooldownTicks());
            partnerBreeding.m_128405_(partnerKey, rule.cooldownTicks());
            if (partnerRoot.m_128425_(BREEDING_TAG, 10)) break;
            partnerRoot.m_128365_(BREEDING_TAG, (Tag)partnerBreeding);
            break;
        }
        if (!hadBreedingTag || !root.m_128425_(BREEDING_TAG, 10)) {
            root.m_128365_(BREEDING_TAG, (Tag)breeding);
        }
    }
}

