/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.config;

import com.electronwill.nightconfig.core.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigHolder {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<String> CONFIG_SCHEMA_VERSION;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Config>> FEAR_GROUPS;
    public static final ForgeConfigSpec.BooleanValue SKIP_BLOCK_CHECK_IF_FIRE_TICK_OFF;
    public static final ForgeConfigSpec.IntValue SCAN_COOLDOWN_TICKS;
    public static final ForgeConfigSpec.IntValue PLAYER_CHECK_RADIUS;
    public static final ForgeConfigSpec.IntValue PLAYER_CHECK_VERTICAL;
    public static final ForgeConfigSpec.IntValue BLOCK_CHECK_PLAYER_RADIUS;
    public static final ForgeConfigSpec.IntValue LIGHT_CHECK_COOLDOWN_TICKS;
    public static final ForgeConfigSpec.BooleanValue INTERGENERATIONAL_TRAUMA_ENABLED;
    public static final ForgeConfigSpec.IntValue MAX_TRAUMA_STAGES_PER_GROUP;
    private static String targetSchemaVersion;

    public static void setDefaults() {
        if (((List)FEAR_GROUPS.get()).isEmpty()) {
            ArrayList<Config> defaultGroups = new ArrayList<Config>();
            defaultGroups.add(ConfigHolder.createDefaultUndeadGroup());
            defaultGroups.add(ConfigHolder.createDefaultArthropodGroup());
            defaultGroups.add(ConfigHolder.createDefaultTeachingGroup());
            defaultGroups.add(ConfigHolder.createDefaultVillagerLowLightGroup());
            defaultGroups.add(ConfigHolder.createDefaultPassiveGroup());
            defaultGroups.add(ConfigHolder.createDefaultSporeGroup());
            FEAR_GROUPS.set(defaultGroups);
            FEAR_GROUPS.save();
        }
    }

    private static Config createDefaultUndeadGroup() {
        Config group = Config.inMemory();
        group.set("group_id", (Object)"hostile_fire_fear");
        group.set("flee_speed", (Object)1.15);
        group.set("search_radius", (Object)10);
        group.set("mobs", List.of(ConfigHolder.createMobDef("minecraft:zombie"), ConfigHolder.createMobDef("minecraft:skeleton"), ConfigHolder.createMobDef("minecraft:husk"), ConfigHolder.createMobDef("minecraft:stray"), ConfigHolder.createMobDef("minecraft:zombie_villager"), ConfigHolder.createMobDef("minecraft:phantom"), ConfigHolder.createMobDef("minecraft:drowned"), ConfigHolder.createMobDef("minecraft:piglin"), ConfigHolder.createMobDef("minecraft:piglin_brute"), ConfigHolder.createMobDef("minecraft:vindicator"), ConfigHolder.createMobDef("minecraft:evoker"), ConfigHolder.createMobDef("minecraft:illusioner"), ConfigHolder.createMobDef("minecraft:ravager"), ConfigHolder.createMobDef("minecraft:pillager"), ConfigHolder.createMobDef("minecraft:witch"), ConfigHolder.createMobDef("minecraft:vex"), ConfigHolder.createMobDef("minecraft:warden"), ConfigHolder.createMobDef("minecraft:wither_skeleton"), ConfigHolder.createMobDef("minecraft:slime"), ConfigHolder.createMobDef("minecraft:creeper")));
        group.set("feared_blocks", List.of(ConfigHolder.createFearSourceDef("minecraft:fire"), ConfigHolder.createFearSourceDef("minecraft:soul_fire"), ConfigHolder.createFearSourceDef("minecraft:lava"), ConfigHolder.createFearSourceDef("minecraft:magma_block"), ConfigHolder.createFearSourceDef("minecraft:tnt"), ConfigHolder.createFearSourceDef("minecraft:end_crystal"), ConfigHolder.createFearSourceDef("minecraft:tnt_minecart"), ConfigHolder.createFearSourceDefWithStates("minecraft:campfire", Map.of("lit", "true")), ConfigHolder.createFearSourceDefWithStates("minecraft:soul_campfire", Map.of("lit", "true"))));
        group.set("feared_items", List.of(ConfigHolder.createFearSourceDef("minecraft:flint_and_steel")));
        return group;
    }

    private static Config createDefaultVillagerLowLightGroup() {
        Config group = Config.inMemory();
        group.set("group_id", (Object)"villager_low_light_fear");
        group.set("flee_speed", (Object)1.05);
        group.set("search_radius", (Object)12);
        group.set("mobs", List.of(ConfigHolder.createMobDef("minecraft:villager")));
        group.set("feared_blocks", List.of());
        group.set("feared_items", List.of());
        Config lf = group.createSubConfig();
        lf.set("enabled", (Object)true);
        lf.set("mode", (Object)"BELOW");
        lf.set("threshold", (Object)6);
        lf.set("layer", (Object)"COMBINED");
        lf.set("hysteresis", (Object)2);
        group.set("light_fear", (Object)lf);
        return group;
    }

    private static Config createDefaultArthropodGroup() {
        Config group = Config.inMemory();
        group.set("group_id", (Object)"arthropod_custom_fear");
        group.set("flee_speed", (Object)1.2);
        group.set("search_radius", (Object)8);
        group.set("mobs", List.of(ConfigHolder.createMobDef("minecraft:spider"), ConfigHolder.createMobDef("minecraft:cave_spider"), ConfigHolder.createMobDef("minecraft:silverfish"), ConfigHolder.createMobDefWithNbt("minecraft:endermite", "{PlayerSpawned:1b}")));
        group.set("feared_blocks", List.of(ConfigHolder.createFearSourceDef("minecraft:magma_block")));
        group.set("feared_items", List.of(ConfigHolder.createFearSourceDefWithNbt("minecraft:stone_sword", "{Enchantments:[{id:\"minecraft:bane_of_arthropods\"}]}")));
        return group;
    }

    private static Config createDefaultTeachingGroup() {
        Config group = Config.inMemory();
        group.set("group_id", (Object)"teaching_example_zombies");
        group.set("flee_speed", (Object)2.0);
        group.set("search_radius", (Object)16);
        group.set("mobs", List.of(ConfigHolder.createMobDefWithNbt("minecraft:zombie", "{Silent:1b}"), ConfigHolder.createMobDefWithCustomName("minecraft:drowned", "Patches")));
        group.set("feared_blocks", List.of(ConfigHolder.createFearSourceDef("minecraft:beacon"), ConfigHolder.createFearSourceDefWithStates("minecraft:conduit", Map.of("waterlogged", "false")), ConfigHolder.createFearSourceDefWithNbt("minecraft:spawner", "{SpawnData:{entity:{id:\"minecraft:skeleton\"}}}")));
        group.set("feared_items", List.of(ConfigHolder.createFearSourceDef("minecraft:golden_apple"), ConfigHolder.createFearSourceDefWithNbt("minecraft:netherite_sword", "{Enchantments:[{id:\"minecraft:smite\"}]}"), ConfigHolder.createFearSourceDefWithCustomName("minecraft:paper", "Exorcism Scroll")));
        group.set("feared_entities", List.of(ConfigHolder.createFearedEntityDefWithOverride("minecraft:wolf"), ConfigHolder.createFearedEntityDefWithNbt("minecraft:endermite", "{PlayerSpawned:1b}", false), ConfigHolder.createFearedEntityDef("#minecraft:skeletons"), ConfigHolder.createProfessorFearEntity()));
        return group;
    }

    private static Config createDefaultPassiveGroup() {
        Config group = Config.inMemory();
        group.set("group_id", (Object)"scaredy_cat");
        group.set("flee_speed", (Object)1.25);
        group.set("search_radius", (Object)12);
        group.set("mobs", List.of(ConfigHolder.createMobDef("minecraft:cat"), ConfigHolder.createMobDef("minecraft:chicken"), ConfigHolder.createMobDef("minecraft:cod"), ConfigHolder.createMobDef("minecraft:cow"), ConfigHolder.createMobDef("minecraft:dolphin"), ConfigHolder.createMobDef("minecraft:donkey"), ConfigHolder.createMobDef("minecraft:horse"), ConfigHolder.createMobDef("minecraft:mooshroom"), ConfigHolder.createMobDef("minecraft:mule"), ConfigHolder.createMobDef("minecraft:ocelot"), ConfigHolder.createMobDef("minecraft:parrot"), ConfigHolder.createMobDef("minecraft:pig"), ConfigHolder.createMobDef("minecraft:rabbit"), ConfigHolder.createMobDef("minecraft:salmon"), ConfigHolder.createMobDef("minecraft:sheep"), ConfigHolder.createMobDef("minecraft:squid"), ConfigHolder.createMobDef("minecraft:tropical_fish"), ConfigHolder.createMobDef("minecraft:turtle"), ConfigHolder.createMobDef("minecraft:glow_squid"), ConfigHolder.createMobDef("minecraft:pufferfish"), ConfigHolder.createMobDef("minecraft:axolotl"), ConfigHolder.createMobDef("minecraft:fox"), ConfigHolder.createMobDef("minecraft:goat"), ConfigHolder.createMobDef("minecraft:llama"), ConfigHolder.createMobDef("minecraft:panda"), ConfigHolder.createMobDef("minecraft:polar_bear"), ConfigHolder.createMobDef("minecraft:bat"), ConfigHolder.createMobDef("minecraft:bee"), ConfigHolder.createMobDef("minecraft:villager"), ConfigHolder.createMobDef("minecraft:wandering_trader"), ConfigHolder.createMobDef("minecraft:trader_llama"), ConfigHolder.createMobDef("minecraft:iron_golem"), ConfigHolder.createMobDef("minecraft:snow_golem"), ConfigHolder.createMobDef("minecraft:allay")));
        group.set("feared_blocks", List.of(ConfigHolder.createFearSourceDef("minecraft:fire"), ConfigHolder.createFearSourceDef("minecraft:soul_fire"), ConfigHolder.createFearSourceDef("minecraft:lava"), ConfigHolder.createFearSourceDefWithStates("minecraft:campfire", Map.of("lit", "true")), ConfigHolder.createFearSourceDefWithStates("minecraft:soul_campfire", Map.of("lit", "true"))));
        group.set("feared_items", List.of(ConfigHolder.createFearSourceDef("minecraft:flint_and_steel"), ConfigHolder.createFearSourceDef("minecraft:wooden_sword"), ConfigHolder.createFearSourceDef("minecraft:wooden_axe"), ConfigHolder.createFearSourceDef("minecraft:stone_sword"), ConfigHolder.createFearSourceDef("minecraft:stone_axe"), ConfigHolder.createFearSourceDef("minecraft:iron_sword"), ConfigHolder.createFearSourceDef("minecraft:iron_axe"), ConfigHolder.createFearSourceDef("minecraft:golden_sword"), ConfigHolder.createFearSourceDef("minecraft:golden_axe"), ConfigHolder.createFearSourceDef("minecraft:diamond_sword"), ConfigHolder.createFearSourceDef("minecraft:diamond_axe"), ConfigHolder.createFearSourceDef("minecraft:netherite_sword"), ConfigHolder.createFearSourceDef("minecraft:netherite_axe"), ConfigHolder.createFearSourceDef("minecraft:trident"), ConfigHolder.createFearSourceDef("minecraft:bow"), ConfigHolder.createFearSourceDef("minecraft:crossbow")));
        return group;
    }

    private static Config createDefaultSporeGroup() {
        Config group = Config.inMemory();
        group.set("group_id", (Object)"Spore_fire_fear");
        group.set("flee_speed", (Object)1.2);
        group.set("search_radius", (Object)12);
        group.set("mobs", List.of(ConfigHolder.createMobDef("spore:braiomil"), ConfigHolder.createMobDef("spore:braurei"), ConfigHolder.createMobDef("spore:brot"), ConfigHolder.createMobDef("spore:brute"), ConfigHolder.createMobDef("spore:busser"), ConfigHolder.createMobDef("spore:inf_construct"), ConfigHolder.createMobDef("spore:delusioner"), ConfigHolder.createMobDef("spore:gastgaber"), ConfigHolder.createMobDef("spore:gazenbreacher"), ConfigHolder.createMobDef("spore:griefer"), ConfigHolder.createMobDef("spore:hevoker"), ConfigHolder.createMobDef("spore:hidenburg"), ConfigHolder.createMobDef("spore:howitzer"), ConfigHolder.createMobDef("spore:howler"), ConfigHolder.createMobDef("spore:hvindicator"), ConfigHolder.createMobDef("spore:inf_drownded"), ConfigHolder.createMobDef("spore:inf_evoker"), ConfigHolder.createMobDef("spore:inf_hazmat"), ConfigHolder.createMobDef("spore:husk"), ConfigHolder.createMobDef("spore:inf_pillager"), ConfigHolder.createMobDef("spore:inf_player"), ConfigHolder.createMobDef("spore:inf_villager"), ConfigHolder.createMobDef("spore:inf_vindicator"), ConfigHolder.createMobDef("spore:inf_wanderer"), ConfigHolder.createMobDef("spore:inf_witch"), ConfigHolder.createMobDef("spore:inf_human"), ConfigHolder.createMobDef("spore:jagd"), ConfigHolder.createMobDef("spore:knight"), ConfigHolder.createMobDef("spore:lacerator"), ConfigHolder.createMobDef("spore:inquisitor"), ConfigHolder.createMobDef("spore:leaper"), ConfigHolder.createMobDef("spore:mound"), ConfigHolder.createMobDef("spore:nuclea"), ConfigHolder.createMobDef("spore:ogre"), ConfigHolder.createMobDef("spore:plagued"), ConfigHolder.createMobDef("spore:proto"), ConfigHolder.createMobDef("spore:reconstructor"), ConfigHolder.createMobDef("spore:scamper"), ConfigHolder.createMobDef("spore:scavenger"), ConfigHolder.createMobDef("spore:scent"), ConfigHolder.createMobDef("spore:sieger"), ConfigHolder.createMobDef("spore:specter"), ConfigHolder.createMobDef("spore:spitter"), ConfigHolder.createMobDef("spore:stalker"), ConfigHolder.createMobDef("spore:thorn"), ConfigHolder.createMobDef("spore:umarmed"), ConfigHolder.createMobDef("spore:usurper"), ConfigHolder.createMobDef("spore:verva"), ConfigHolder.createMobDef("spore:vigil"), ConfigHolder.createMobDef("spore:volatile"), ConfigHolder.createMobDef("spore:wendigo")));
        group.set("feared_blocks", List.of(ConfigHolder.createFearSourceDef("minecraft:fire"), ConfigHolder.createFearSourceDef("minecraft:soul_fire"), ConfigHolder.createFearSourceDef("minecraft:lava"), ConfigHolder.createFearSourceDef("minecraft:magma_block"), ConfigHolder.createFearSourceDef("minecraft:tnt"), ConfigHolder.createFearSourceDef("minecraft:end_crystal"), ConfigHolder.createFearSourceDef("minecraft:tnt_minecart"), ConfigHolder.createFearSourceDefWithStates("minecraft:campfire", Map.of("lit", "true")), ConfigHolder.createFearSourceDefWithStates("minecraft:soul_campfire", Map.of("lit", "true"))));
        group.set("feared_items", List.of(ConfigHolder.createFearSourceDef("minecraft:flint_and_steel")));
        return group;
    }

    private static Config createMobDef(String id) {
        Config table = Config.inMemory();
        table.set("id", (Object)id);
        return table;
    }

    private static Config createMobDefWithNbt(String id, String nbt) {
        Config table = ConfigHolder.createMobDef(id);
        table.set("nbt", (Object)nbt);
        return table;
    }

    private static Config createFearSourceDef(String id) {
        Config table = Config.inMemory();
        table.set("id", (Object)id);
        return table;
    }

    private static Config createFearSourceDefWithNbt(String id, String nbt) {
        Config table = ConfigHolder.createFearSourceDef(id);
        table.set("nbt", (Object)nbt);
        return table;
    }

    private static Config createFearSourceDefWithStates(String id, Map<String, String> states) {
        Config table = Config.inMemory();
        table.set("id", (Object)id);
        Config statesTable = table.createSubConfig();
        states.forEach((arg_0, arg_1) -> ((Config)statesTable).set(arg_0, arg_1));
        table.set("states", (Object)statesTable);
        return table;
    }

    private static Config createFearSourceDefWithCustomName(String id, String name) {
        Config table = ConfigHolder.createFearSourceDef(id);
        table.set("custom_name", (Object)name);
        return table;
    }

    private static Config createMobDefWithCustomName(String id, String name) {
        Config table = ConfigHolder.createMobDef(id);
        table.set("custom_name", (Object)name);
        return table;
    }

    private static Config createFearedEntityDef(String id) {
        Config table = Config.inMemory();
        table.set("id", (Object)id);
        return table;
    }

    private static Config createFearedEntityDefWithOverride(String id) {
        Config table = ConfigHolder.createFearedEntityDef(id);
        table.set("fear_override", (Object)true);
        return table;
    }

    private static Config createFearedEntityDefWithCustomName(String id, String name, boolean fearOverride) {
        Config table = ConfigHolder.createFearedEntityDef(id);
        table.set("custom_name", (Object)name);
        if (fearOverride) {
            table.set("fear_override", (Object)true);
        }
        return table;
    }

    private static Config createFearedEntityDefWithNbt(String id, String nbt, boolean fearOverride) {
        Config table = ConfigHolder.createFearedEntityDef(id);
        table.set("nbt", (Object)nbt);
        if (fearOverride) {
            table.set("fear_override", (Object)true);
        }
        return table;
    }

    private static Config createProfessorFearEntity() {
        Config table = ConfigHolder.createFearedEntityDefWithCustomName("minecraft:player", "Professor Fear", true);
        table.set("nbt", (Object)"{Tags:[\"fear_trainer\"]}");
        return table;
    }

    public static void setTargetSchemaVersion(String version) {
        targetSchemaVersion = Objects.requireNonNullElse(version, "");
    }

    public static void onConfigReload(ModConfig config) {
        if (config.getSpec() != SPEC) {
            return;
        }
        ConfigHolder.setDefaults();
        ConfigHolder.migrateIfNeeded();
    }

    private static void migrateIfNeeded() {
        String desiredVersion = targetSchemaVersion == null ? "" : targetSchemaVersion;
        String storedVersion = (String)CONFIG_SCHEMA_VERSION.get();
        if (Objects.equals(storedVersion, desiredVersion)) {
            return;
        }
        boolean updatedTeachingGroup = ConfigHolder.updateTeachingExampleGroup();
        CONFIG_SCHEMA_VERSION.set((Object)desiredVersion);
        CONFIG_SCHEMA_VERSION.save();
        if (updatedTeachingGroup) {
            FEAR_GROUPS.save();
        }
    }

    private static boolean updateTeachingExampleGroup() {
        boolean changed = false;
        List groups = (List)FEAR_GROUPS.get();
        for (Config group : groups) {
            String id = Objects.toString(group.get("group_id"), "");
            if (!"teaching_example_zombies".equals(id)) continue;
            group.set("feared_entities", List.of(ConfigHolder.createFearedEntityDefWithOverride("minecraft:wolf"), ConfigHolder.createFearedEntityDefWithNbt("minecraft:endermite", "{PlayerSpawned:1b}", false), ConfigHolder.createFearedEntityDef("#minecraft:skeletons"), ConfigHolder.createProfessorFearEntity()));
            changed = true;
            break;
        }
        return changed;
    }

    static {
        targetSchemaVersion = "";
        CONFIG_SCHEMA_VERSION = BUILDER.comment("Tracks the mod version that last migrated this config. Do not edit manually unless you know what you are doing.").define("config_schema_version", (Object)"");
        BUILDER.push("Fear Groups");
        FEAR_GROUPS = BUILDER.comment("A list of fear groups. Each group defines a set of mobs and what they fear.\nEach group has:\n - group_id (string, required): A unique name for the group.\n - flee_speed (double, optional, default: 1.2): How fast mobs in this group flee.\n - search_radius (int, optional, default: 8): How far mobs in this group search for threats.\n - mobs (list, required): A list of mobs in this group. Can specify 'id' and 'nbt'.\n - feared_blocks (list, required): Blocks this group fears. Can specify 'id', 'states', 'nbt' (for block entities), and 'fear_override' (boolean).\n - feared_items (list, required): Items this group fears. Can specify 'id', 'nbt', and 'fear_override' (boolean).\n - feared_entities (list, optional): Entities this group fears. Supports 'id', 'nbt', 'custom_name', and 'fear_override' (boolean, default: false) to override hostility when visible.\n - light_fear (object, optional): Per-group light level avoidance config. When omitted or disabled, light fear is off.\n   Fields:\n     - enabled (boolean, default: false)\n     - mode (string, default: \"ABOVE\"): \"ABOVE\" to avoid bright areas where brightness >= threshold, or \"BELOW\" to avoid where brightness <= threshold\n     - threshold (int, default: 11): Light threshold in [0, 15]\n     - layer (string, default: \"COMBINED\"): \"COMBINED\" brightness (works indoors/outdoors), or \"BLOCK\"/\"SKY\"\n     - hysteresis (int, optional, default: 1): Margin to prevent jitter when entering/leaving boundary\n").defineList("fear_groups", new ArrayList(), obj -> obj instanceof Config);
        BUILDER.pop();
        BUILDER.push("Optimizations");
        SKIP_BLOCK_CHECK_IF_FIRE_TICK_OFF = BUILDER.define("skipBlockCheckIfFireTickOff", true);
        SCAN_COOLDOWN_TICKS = BUILDER.defineInRange("scanCooldownTicks", 15, 1, 200);
        PLAYER_CHECK_RADIUS = BUILDER.defineInRange("playerCheckRadius", 8, 1, 64);
        PLAYER_CHECK_VERTICAL = BUILDER.defineInRange("playerCheckVertical", 4, 1, 64);
        BLOCK_CHECK_PLAYER_RADIUS = BUILDER.defineInRange("blockCheckPlayerRadius", 16, 1, 64);
        LIGHT_CHECK_COOLDOWN_TICKS = BUILDER.defineInRange("lightCheckCooldownTicks", 20, 1, 200);
        BUILDER.pop();
        BUILDER.push("IntergenerationalTrauma");
        INTERGENERATIONAL_TRAUMA_ENABLED = BUILDER.define("intergenerationalTraumaEnabled", false);
        MAX_TRAUMA_STAGES_PER_GROUP = BUILDER.defineInRange("maxTraumaStagesPerGroup", 3, 1, 32);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

