/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.trauma;

import com.example.firefearmod.trauma.ITraumaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class TraumaData
implements ITraumaData {
    private static final String STAGES_KEY = "stages";
    private final Map<ResourceLocation, Integer> stages = new HashMap<ResourceLocation, Integer>();

    @Override
    public int getStage(ResourceLocation groupId) {
        return this.stages.getOrDefault(groupId, 0);
    }

    @Override
    public void setStage(ResourceLocation groupId, int stage, int maxStages) {
        int clamped;
        if (maxStages <= 0) {
            maxStages = 1;
        }
        if ((clamped = Math.max(0, Math.min(stage, maxStages - 1))) == 0) {
            this.stages.remove(groupId);
        } else {
            this.stages.put(groupId, clamped);
        }
    }

    @Override
    public Map<ResourceLocation, Integer> getAllStages() {
        return Collections.unmodifiableMap(this.stages);
    }

    @Override
    public void clampStages(int maxStages) {
        if (maxStages <= 0) {
            this.stages.clear();
            return;
        }
        int cap = maxStages - 1;
        this.stages.replaceAll((id, value) -> Math.max(0, Math.min(value, cap)));
        this.stages.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag stagesTag = new CompoundTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.stages.entrySet()) {
            stagesTag.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.m_128365_(STAGES_KEY, (Tag)stagesTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.stages.clear();
        if (tag.m_128441_(STAGES_KEY)) {
            CompoundTag stagesTag = tag.m_128469_(STAGES_KEY);
            for (String key : stagesTag.m_128431_()) {
                int value = stagesTag.m_128451_(key);
                if (value <= 0) continue;
                this.stages.put(new ResourceLocation(key), value);
            }
        }
    }
}

