/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.trauma;

import com.example.firefearmod.manager.FearGroup;
import com.example.firefearmod.manager.IFearProfile;
import com.example.firefearmod.trauma.ITraumaData;
import com.example.firefearmod.trauma.TraumaCapability;
import com.example.firefearmod.trauma.TraumaGroup;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class TraumaProfile
implements IFearProfile {
    private static final double DEFAULT_FLEE_SPEED = 1.2;
    private static final int DEFAULT_SEARCH_RADIUS = 8;
    private final Mob mob;
    private final List<TraumaGroup> groups;

    public TraumaProfile(Mob mob, List<TraumaGroup> groups) {
        this.mob = mob;
        this.groups = List.copyOf(groups);
    }

    @Override
    public double fleeSpeed() {
        ITraumaData data = (ITraumaData)TraumaCapability.get(this.mob).orElse(null);
        double result = 1.2;
        boolean found = false;
        for (TraumaGroup group : this.groups) {
            Double v;
            int stageIndex = TraumaProfile.getActiveStageIndex(group, data);
            if (stageIndex < 0 || (v = TraumaProfile.resolveFleeSpeed(group, stageIndex)) == null || found && !(v > result)) continue;
            result = v;
            found = true;
        }
        return result;
    }

    @Override
    public int searchRadius() {
        ITraumaData data = (ITraumaData)TraumaCapability.get(this.mob).orElse(null);
        int result = 8;
        boolean found = false;
        for (TraumaGroup group : this.groups) {
            Integer v;
            int stageIndex = TraumaProfile.getActiveStageIndex(group, data);
            if (stageIndex < 0 || (v = TraumaProfile.resolveSearchRadius(group, stageIndex)) == null || found && v <= result) continue;
            result = v;
            found = true;
        }
        return result;
    }

    @Override
    @Nullable
    public FearGroup.FearSourceDefinition findFearedBlock(BlockState blockState, @Nullable BlockEntity blockEntity) {
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
        if (blockId == null) {
            return null;
        }
        ITraumaData data = (ITraumaData)TraumaCapability.get(this.mob).orElse(null);
        for (TraumaGroup group : this.groups) {
            int stageIndex = TraumaProfile.getActiveStageIndex(group, data);
            if (stageIndex < 0) continue;
            for (int i = 0; i <= stageIndex; ++i) {
                TraumaGroup.TraumaStage stage = group.stages().get(i);
                for (FearGroup.FearSourceDefinition def : stage.fearedBlocks()) {
                    if (!def.matches(blockId, blockState, blockEntity, null)) continue;
                    return def;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public FearGroup.FearSourceDefinition findFearedItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return null;
        }
        ITraumaData data = (ITraumaData)TraumaCapability.get(this.mob).orElse(null);
        for (TraumaGroup group : this.groups) {
            int stageIndex = TraumaProfile.getActiveStageIndex(group, data);
            if (stageIndex < 0) continue;
            for (int i = 0; i <= stageIndex; ++i) {
                TraumaGroup.TraumaStage stage = group.stages().get(i);
                for (FearGroup.FearSourceDefinition def : stage.fearedItems()) {
                    if (!def.matches(itemId, null, null, stack)) continue;
                    return def;
                }
            }
        }
        return null;
    }

    @Override
    public boolean hasFearedEntities() {
        ITraumaData data = (ITraumaData)TraumaCapability.get(this.mob).orElse(null);
        for (TraumaGroup group : this.groups) {
            int stageIndex = TraumaProfile.getActiveStageIndex(group, data);
            if (stageIndex < 0) continue;
            for (int i = 0; i <= stageIndex; ++i) {
                TraumaGroup.TraumaStage stage = group.stages().get(i);
                if (!stage.fearedEntities().isEmpty()) {
                    return true;
                }
                for (FearGroup.FearSourceDefinition def : stage.fearedBlocks()) {
                    if (!def.canMatchEntity()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IFearProfile.VisibilityMode getEntityVisibilityMode(Entity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return IFearProfile.VisibilityMode.LOOK_BASED;
        }
        ITraumaData data = (ITraumaData)TraumaCapability.get(this.mob).orElse(null);
        for (TraumaGroup group : this.groups) {
            int stageIndex = TraumaProfile.getActiveStageIndex(group, data);
            if (stageIndex < 0) continue;
            for (int i = 0; i <= stageIndex; ++i) {
                TraumaGroup.TraumaStage stage = group.stages().get(i);
                for (FearGroup.FearedEntityDefinition def : stage.fearedEntities()) {
                    if (!def.matches(entityId, entity)) continue;
                    return def.visibilityMode();
                }
            }
        }
        return IFearProfile.VisibilityMode.LOOK_BASED;
    }

    @Override
    public boolean isFearedEntity(Entity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        ITraumaData data = (ITraumaData)TraumaCapability.get(this.mob).orElse(null);
        for (TraumaGroup group : this.groups) {
            int stageIndex = TraumaProfile.getActiveStageIndex(group, data);
            if (stageIndex < 0) continue;
            for (int i = 0; i <= stageIndex; ++i) {
                TraumaGroup.TraumaStage stage = group.stages().get(i);
                for (FearGroup.FearedEntityDefinition fearedEntityDefinition : stage.fearedEntities()) {
                    if (!fearedEntityDefinition.matches(entityId, entity)) continue;
                    return true;
                }
                for (FearGroup.FearSourceDefinition fearSourceDefinition : stage.fearedBlocks()) {
                    if (!fearSourceDefinition.matchesEntity(entityId, entity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean shouldOverrideHostility(BlockState blockState, @Nullable BlockEntity blockEntity) {
        FearGroup.FearSourceDefinition def = this.findFearedBlock(blockState, blockEntity);
        return def != null && def.fearOverride();
    }

    @Override
    public boolean shouldOverrideHostility(ItemStack stack) {
        FearGroup.FearSourceDefinition def = this.findFearedItem(stack);
        return def != null && def.fearOverride();
    }

    @Override
    public boolean shouldOverrideHostility(Entity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        ITraumaData data = (ITraumaData)TraumaCapability.get(this.mob).orElse(null);
        for (TraumaGroup group : this.groups) {
            int stageIndex = TraumaProfile.getActiveStageIndex(group, data);
            if (stageIndex < 0) continue;
            for (int i = 0; i <= stageIndex; ++i) {
                TraumaGroup.TraumaStage stage = group.stages().get(i);
                for (FearGroup.FearedEntityDefinition def : stage.fearedEntities()) {
                    if (!def.matches(entityId, entity)) continue;
                    return def.overrideHostility();
                }
            }
        }
        return false;
    }

    private static int getActiveStageIndex(TraumaGroup group, @Nullable ITraumaData data) {
        int maxIndex;
        List<TraumaGroup.TraumaStage> stages = group.stages();
        if (stages.isEmpty()) {
            return -1;
        }
        int stage = 0;
        if (data != null) {
            stage = data.getStage(group.id());
        }
        if (stage < 0) {
            stage = 0;
        }
        if (stage > (maxIndex = stages.size() - 1)) {
            stage = maxIndex;
        }
        return stage;
    }

    @Nullable
    private static Double resolveFleeSpeed(TraumaGroup group, int stageIndex) {
        List<TraumaGroup.TraumaStage> stages = group.stages();
        for (int i = stageIndex; i >= 0; --i) {
            Double v = stages.get(i).fleeSpeed();
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Nullable
    private static Integer resolveSearchRadius(TraumaGroup group, int stageIndex) {
        List<TraumaGroup.TraumaStage> stages = group.stages();
        for (int i = stageIndex; i >= 0; --i) {
            Integer v = stages.get(i).searchRadius();
            if (v == null) continue;
            return v;
        }
        return null;
    }
}

