/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.util;

import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;

public final class VisionHelper {
    private static final String SOUND_ATTRACT_MOD_ID = "soundattract";
    private static final boolean SOUND_ATTRACT_LOADED = ModList.get().isLoaded("soundattract");
    private static final double FALLBACK_FOV_DEGREES = 120.0;

    private VisionHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeEntity(Mob looker, Entity target, boolean checkObstructions) {
        if (looker == null || target == null) {
            return false;
        }
        if (!SOUND_ATTRACT_LOADED) {
        }
        try {
            Boolean result = SoundAttractBridge.isEntityInFov(looker, target, checkObstructions);
            if (result != null) {
                return result;
            }
        }
        finally {
            return VisionHelper.fallbackEntityCheck(looker, target, checkObstructions);
        }
    }

    public static boolean canSeePosition(Mob looker, Vec3 target, boolean checkObstructions) {
        if (looker == null || target == null) {
            return false;
        }
        if (SOUND_ATTRACT_LOADED) {
            try {
                Boolean result = SoundAttractBridge.isPositionInFov(looker, target, checkObstructions);
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (checkObstructions && !VisionHelper.hasLineOfSight(looker, target)) {
            return false;
        }
        return VisionHelper.isWithinFallbackFov(looker, target);
    }

    public static boolean hasLineOfSight(Mob looker, Vec3 target) {
        ClipContext context;
        Level level;
        BlockHitResult hit;
        double offsetMagnitude;
        if (looker == null || target == null) {
            return false;
        }
        Vec3 eyePos = looker.m_146892_();
        Vec3 direction = target.m_82546_(eyePos);
        double distance = direction.m_82553_();
        if (distance < 1.0E-4) {
            return true;
        }
        Vec3 adjustedTarget = target;
        if (distance > 0.05 && (offsetMagnitude = Math.min(0.51, distance - 0.05)) > 0.0) {
            Vec3 offset = direction.m_82490_(1.0 / distance).m_82490_(offsetMagnitude);
            adjustedTarget = target.m_82546_(offset);
        }
        if ((hit = (level = looker.m_9236_()).m_45547_(context = new ClipContext(eyePos, adjustedTarget, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)looker))).m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        BlockPos targetPos = BlockPos.m_274446_((Position)target);
        return hit.m_6662_() == HitResult.Type.BLOCK && hit.m_82425_().equals((Object)targetPos);
    }

    public static boolean hasLineOfSight(Mob looker, Entity target) {
        return VisionHelper.hasLineOfSight(looker, target.m_146892_());
    }

    private static boolean fallbackEntityCheck(Mob looker, Entity target, boolean checkObstructions) {
        if (checkObstructions && !VisionHelper.hasLineOfSight(looker, target)) {
            return false;
        }
        return VisionHelper.isWithinFallbackFov(looker, target.m_146892_());
    }

    private static boolean isWithinFallbackFov(Mob looker, Vec3 target) {
        Vec3 lookVector = looker.m_20154_().m_82541_();
        Vec3 toTargetVector = target.m_82546_(looker.m_146892_()).m_82541_();
        if (Double.isNaN(toTargetVector.f_82479_) || Double.isNaN(toTargetVector.f_82480_) || Double.isNaN(toTargetVector.f_82481_)) {
            return false;
        }
        Vec3 lookHorizontal = new Vec3(lookVector.f_82479_, 0.0, lookVector.f_82481_);
        Vec3 targetHorizontal = new Vec3(toTargetVector.f_82479_, 0.0, toTargetVector.f_82481_);
        if (lookHorizontal.m_82556_() < 1.0E-6 || targetHorizontal.m_82556_() < 1.0E-6) {
            return true;
        }
        double dotHorizontal = lookHorizontal.m_82541_().m_82526_(targetHorizontal.m_82541_());
        double clampedHorizontal = Math.max(-1.0, Math.min(1.0, dotHorizontal));
        double angleHorizontal = Math.toDegrees(Math.acos(clampedHorizontal));
        if (angleHorizontal > 60.0) {
            return false;
        }
        double lookPitch = Math.toDegrees(Math.asin(Math.max(-1.0, Math.min(1.0, lookVector.f_82480_))));
        double targetPitch = Math.toDegrees(Math.asin(Math.max(-1.0, Math.min(1.0, toTargetVector.f_82480_))));
        double verticalDiff = Math.abs(targetPitch - lookPitch);
        return verticalDiff <= 60.0;
    }

    private static final class SoundAttractBridge {
        private static final Class<?> FOV_EVENTS_CLASS;
        private static final Method IS_TARGET_IN_FOV;

        private SoundAttractBridge() {
        }

        private static Boolean isEntityInFov(Mob looker, Entity target, boolean checkObstructions) throws ReflectiveOperationException {
            Boolean bool;
            if (FOV_EVENTS_CLASS == null || IS_TARGET_IN_FOV == null) {
                return null;
            }
            Object result = IS_TARGET_IN_FOV.invoke(null, looker, target, checkObstructions);
            return result instanceof Boolean ? (bool = (Boolean)result) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Boolean isPositionInFov(Mob looker, Vec3 target, boolean checkObstructions) throws ReflectiveOperationException {
            if (FOV_EVENTS_CLASS == null || IS_TARGET_IN_FOV == null) {
                return null;
            }
            Level level = looker.m_9236_();
            ArmorStand probe = (ArmorStand)EntityType.f_20529_.m_20615_(level);
            if (probe == null) {
                return null;
            }
            probe.m_6034_(target.f_82479_, target.f_82480_, target.f_82481_);
            try {
                Boolean bool;
                Object result = IS_TARGET_IN_FOV.invoke(null, looker, probe, checkObstructions);
                Boolean bl = result instanceof Boolean ? (bool = (Boolean)result) : null;
                return bl;
            }
            finally {
                probe.m_146870_();
            }
        }

        static {
            Method method;
            Class<?> clazz;
            try {
                clazz = Class.forName("com.example.soundattract.FovEvents");
                method = clazz.getMethod("isTargetInFov", Mob.class, Entity.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {
                clazz = null;
                method = null;
            }
            FOV_EVENTS_CLASS = clazz;
            IS_TARGET_IN_FOV = method;
        }
    }
}

