/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.ai;

import com.example.firefearmod.config.ConfigHolder;
import com.example.firefearmod.manager.FearGroup;
import com.example.firefearmod.manager.FearGroupManager;
import com.example.firefearmod.manager.LightFear;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class LightFearGoal
extends Goal {
    private final Mob mob;
    private final FearGroup group;
    private final LightFear lightFear;
    private BlockPos targetPos;
    private int scanCooldown;
    private long lastRepathGameTime;
    private int lastTargetBrightness;

    public LightFearGoal(Mob mob, FearGroup group) {
        this.mob = mob;
        this.group = group;
        this.lightFear = FearGroupManager.getLightFearForGroup(group);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.lightFear.enabled()) {
            return false;
        }
        Level level = this.mob.f_19853_;
        if (!this.lightFear.isViolation(level, this.mob.m_142538_())) {
            return false;
        }
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
            return false;
        }
        this.targetPos = this.findSafeTarget();
        this.scanCooldown = (Integer)ConfigHolder.LIGHT_CHECK_COOLDOWN_TICKS.get();
        this.lastRepathGameTime = level.m_46467_();
        if (this.targetPos != null) {
            this.lastTargetBrightness = this.lightFear.sampleBrightness(level, this.targetPos);
        }
        return this.targetPos != null;
    }

    public boolean m_8045_() {
        if (!this.lightFear.enabled()) {
            return false;
        }
        if (this.targetPos == null) {
            return false;
        }
        Level level = this.mob.f_19853_;
        boolean safeHere = this.lightFear.isSafe(level, this.mob.m_142538_());
        if (!safeHere) {
            return true;
        }
        double dist2 = Vec3.m_82512_((Vec3i)this.targetPos).m_82557_(this.mob.m_20182_());
        return dist2 > 1.44;
    }

    public void m_8056_() {
        this.moveToTarget();
    }

    public void m_8037_() {
        if (this.targetPos == null) {
            return;
        }
        PathNavigation nav = this.mob.m_21573_();
        long now = this.mob.f_19853_.m_46467_();
        if (now - this.lastRepathGameTime >= (long)((Integer)ConfigHolder.LIGHT_CHECK_COOLDOWN_TICKS.get()).intValue() && (nav.m_26571_() || !this.lightFear.isSafe(this.mob.f_19853_, this.targetPos))) {
            BlockPos newTarget = this.findSafeTarget();
            if (newTarget != null && !newTarget.equals((Object)this.targetPos)) {
                this.targetPos = newTarget;
                this.moveToTarget();
                this.lastTargetBrightness = this.lightFear.sampleBrightness(this.mob.f_19853_, this.targetPos);
            }
            this.lastRepathGameTime = now;
        }
    }

    public void m_8041_() {
        this.targetPos = null;
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_6767_() {
        return false;
    }

    private void moveToTarget() {
        if (this.targetPos == null) {
            return;
        }
        PathNavigation nav = this.mob.m_21573_();
        Path path = nav.m_7864_(this.targetPos, 0);
        if (path != null) {
            nav.m_26536_(path, this.group.fleeSpeed());
        } else {
            Vec3 c = Vec3.m_82512_((Vec3i)this.targetPos);
            nav.m_26519_(c.f_82479_, c.f_82480_, c.f_82481_, this.group.fleeSpeed());
        }
    }

    private BlockPos findSafeTarget() {
        Level level = this.mob.f_19853_;
        BlockPos origin = this.mob.m_142538_();
        int radius = Math.max(2, this.group.searchRadius());
        int curB = this.lightFear.sampleBrightness(level, origin);
        int minGain = Math.max(1, this.lightFear.hysteresis() + 1);
        BlockPos bestSafe = null;
        int bestSafeB = this.lightFear.mode() == LightFear.Mode.BELOW ? -1 : 16;
        double bestSafeD2 = Double.MAX_VALUE;
        BlockPos bestFallback = null;
        int bestFallbackB = curB;
        double bestFallbackD2 = Double.MAX_VALUE;
        int attempts = Math.min(80, 24 + radius * 2);
        int vRange = Math.min(2, Math.max(1, radius / 4));
        for (int i = 0; i < attempts; ++i) {
            double d2;
            int dx = this.mob.m_21187_().nextInt(radius * 2 + 1) - radius;
            int dz = this.mob.m_21187_().nextInt(radius * 2 + 1) - radius;
            int dy = this.mob.m_21187_().nextInt(vRange * 2 + 1) - vRange;
            BlockPos sample = origin.m_142082_(dx, dy, dz);
            int b = this.lightFear.sampleBrightness(level, sample);
            Path path = this.mob.m_21573_().m_7864_(sample, 0);
            if (path == null || (d2 = sample.m_123331_((Vec3i)origin)) < 4.0) continue;
            boolean isSafe = this.lightFear.isSafe(level, sample);
            if (isSafe) {
                if (this.lightFear.mode() == LightFear.Mode.BELOW) {
                    if (b <= bestSafeB && (b != bestSafeB || !(d2 < bestSafeD2))) continue;
                    bestSafeB = b;
                    bestSafeD2 = d2;
                    bestSafe = sample;
                    continue;
                }
                if (b >= bestSafeB && (b != bestSafeB || !(d2 < bestSafeD2))) continue;
                bestSafeB = b;
                bestSafeD2 = d2;
                bestSafe = sample;
                continue;
            }
            if (this.lightFear.mode() == LightFear.Mode.BELOW) {
                if (b < curB + minGain || b <= bestFallbackB && (b != bestFallbackB || !(d2 < bestFallbackD2))) continue;
                bestFallbackB = b;
                bestFallbackD2 = d2;
                bestFallback = sample;
                continue;
            }
            if (b > curB - minGain || b >= bestFallbackB && (b != bestFallbackB || !(d2 < bestFallbackD2))) continue;
            bestFallbackB = b;
            bestFallbackD2 = d2;
            bestFallback = sample;
        }
        return bestSafe != null ? bestSafe : bestFallback;
    }
}

