/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.manager;

import com.electronwill.nightconfig.core.Config;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public record FearGroup(String groupId, double fleeSpeed, int searchRadius, List<MobDefinition> mobs, List<FearSourceDefinition> fearedBlocks, List<FearSourceDefinition> fearedItems, List<FearedEntityDefinition> fearedEntities) {
    public static FearGroup fromConfig(Config config) {
        String groupId = (String)config.get("group_id");
        double fleeSpeed = config.getOptional("flee_speed").map(o -> ((Number)o).doubleValue()).orElse(1.2);
        int searchRadius = config.getOptional("search_radius").map(o -> ((Number)o).intValue()).orElse(8);
        List<MobDefinition> mobs = ((List)config.get("mobs")).stream().map(MobDefinition::fromConfig).collect(Collectors.toList());
        List<FearSourceDefinition> fearedBlocks = ((List)config.get("feared_blocks")).stream().map(FearSourceDefinition::fromConfig).collect(Collectors.toList());
        List<FearSourceDefinition> fearedItems = ((List)config.get("feared_items")).stream().map(FearSourceDefinition::fromConfig).collect(Collectors.toList());
        List<FearedEntityDefinition> fearedEntities = config.getOptional("feared_entities").map(o -> (List)o).map(list -> list.stream().map(FearedEntityDefinition::fromConfig).collect(Collectors.toList())).orElse(List.of());
        return new FearGroup(groupId, fleeSpeed, searchRadius, mobs, fearedBlocks, fearedItems, fearedEntities);
    }

    public int getMatchScore(Mob mob) {
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (mobId == null) {
            return -1;
        }
        int bestScore = -1;
        for (MobDefinition def : this.mobs) {
            int score = def.getMatchScore(mob, mobId);
            if (score <= bestScore) continue;
            bestScore = score;
        }
        return bestScore;
    }

    @Nullable
    public FearSourceDefinition findFearedBlock(BlockState blockState, @Nullable BlockEntity blockEntity) {
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
        if (blockId == null) {
            return null;
        }
        for (FearSourceDefinition def : this.fearedBlocks) {
            if (!def.matches(blockId, blockState, blockEntity, null)) continue;
            return def;
        }
        return null;
    }

    @Nullable
    public FearSourceDefinition findFearedItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return null;
        }
        for (FearSourceDefinition def : this.fearedItems) {
            if (!def.matches(itemId, null, null, stack)) continue;
            return def;
        }
        return null;
    }

    public boolean hasFearedEntities() {
        if (!this.fearedEntities.isEmpty()) {
            return true;
        }
        for (FearSourceDefinition def : this.fearedBlocks) {
            if (!def.canMatchEntity()) continue;
            return true;
        }
        return false;
    }

    public boolean shouldOverrideHostility(BlockState blockState, @Nullable BlockEntity blockEntity) {
        FearSourceDefinition def = this.findFearedBlock(blockState, blockEntity);
        return def != null && def.fearOverride();
    }

    public boolean shouldOverrideHostility(ItemStack stack) {
        FearSourceDefinition def = this.findFearedItem(stack);
        return def != null && def.fearOverride();
    }

    public boolean isFearedEntity(Entity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        for (FearedEntityDefinition fearedEntityDefinition : this.fearedEntities) {
            if (!fearedEntityDefinition.matches(entityId, entity)) continue;
            return true;
        }
        for (FearSourceDefinition fearSourceDefinition : this.fearedBlocks) {
            if (!fearSourceDefinition.matchesEntity(entityId, entity)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldOverrideHostility(Entity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        for (FearedEntityDefinition def : this.fearedEntities) {
            if (!def.matches(entityId, entity)) continue;
            return def.overrideHostility();
        }
        return false;
    }

    public record MobDefinition(ResourceLocation id, @Nullable String customName, @Nullable CompoundTag nbt) {
        public static MobDefinition fromConfig(Config config) {
            ResourceLocation id = new ResourceLocation((String)config.get("id"));
            String customName = config.getOptional("custom_name").map(String::valueOf).orElse(null);
            CompoundTag nbt = config.getOptional("nbt").map(nbtStr -> {
                try {
                    return TagParser.m_129359_((String)((String)nbtStr));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid NBT: " + e.getMessage());
                }
            }).orElse(null);
            return new MobDefinition(id, customName, nbt);
        }

        public int getMatchScore(Mob mob, ResourceLocation mobId) {
            boolean nbtMatch;
            if (!this.id.equals((Object)mobId)) {
                return -1;
            }
            boolean nameMatch = this.customName == null || mob.m_8077_() && mob.m_7755_().getString().equals(this.customName);
            boolean bl = nbtMatch = this.nbt == null || NbtUtils.m_129235_((Tag)this.nbt, (Tag)mob.m_20240_(new CompoundTag()), (boolean)true);
            if (!nameMatch || !nbtMatch) {
                return -1;
            }
            int score = 0;
            if (this.customName != null) {
                score += 2;
            }
            if (this.nbt != null) {
                ++score;
            }
            return score;
        }
    }

    public record FearSourceDefinition(ResourceLocation id, boolean isTag, @Nullable String customName, @Nullable Config states, @Nullable CompoundTag nbt, boolean fearOverride) {
        public static FearSourceDefinition fromConfig(Config config) {
            String raw = (String)config.get("id");
            boolean isTag = false;
            if (raw.startsWith("#")) {
                isTag = true;
                raw = raw.substring(1);
            }
            ResourceLocation id = new ResourceLocation(raw);
            String customName = config.getOptional("custom_name").map(String::valueOf).orElse(null);
            Config states = config.getOptional("states").map(o -> (Config)o).orElse(null);
            CompoundTag nbt = config.getOptional("nbt").map(nbtStr -> {
                try {
                    return TagParser.m_129359_((String)((String)nbtStr));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid NBT: " + e.getMessage());
                }
            }).orElse(null);
            boolean fearOverride = config.getOptional("fear_override").map(o -> (Boolean)o).orElse(false);
            return new FearSourceDefinition(id, isTag, customName, states, nbt, fearOverride);
        }

        public boolean matches(ResourceLocation targetId, @Nullable BlockState blockState, @Nullable BlockEntity blockEntity, @Nullable ItemStack itemStack) {
            if (blockState != null) {
                Object tagKey;
                if (this.isTag ? !blockState.m_204336_((TagKey)(tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)this.id))) : !this.id.equals((Object)targetId)) {
                    return false;
                }
                if (this.states != null) {
                    for (Config.Entry entry : this.states.entrySet()) {
                        String key = entry.getKey();
                        if (key == null) continue;
                        Property property = blockState.m_60734_().m_49965_().m_61081_(key);
                        if (property == null) {
                            return false;
                        }
                        Optional value = property.m_6215_(entry.getValue().toString());
                        if (!value.isEmpty() && blockState.m_61143_(property).equals(value.get())) continue;
                        return false;
                    }
                }
                if (this.nbt != null) {
                    if (blockEntity == null) {
                        return false;
                    }
                    CompoundTag blockNbt = blockEntity.m_187482_();
                    if (!NbtUtils.m_129235_((Tag)this.nbt, (Tag)blockNbt, (boolean)true)) {
                        return false;
                    }
                }
                return true;
            }
            if (itemStack != null) {
                CompoundTag itemNbt;
                TagKey tagKey;
                if (this.isTag ? !itemStack.m_204117_(tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.id)) : !this.id.equals((Object)targetId)) {
                    return false;
                }
                if (!(this.customName == null || itemStack.m_41788_() && itemStack.m_41786_().getString().equals(this.customName))) {
                    return false;
                }
                return this.nbt == null || (itemNbt = itemStack.m_41783_()) != null && NbtUtils.m_129235_((Tag)this.nbt, (Tag)itemNbt, (boolean)true);
            }
            return false;
        }

        public boolean matchesEntity(ResourceLocation targetId, Entity entity) {
            if (!this.canMatchEntity()) {
                return false;
            }
            if (this.isTag) {
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)this.id);
                if (!entity.m_6095_().m_204039_(tagKey)) {
                    return false;
                }
            } else if (!this.id.equals((Object)targetId)) {
                return false;
            }
            if (this.customName != null) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    String playerName = player.m_6302_();
                    String displayName = player.m_7755_().getString();
                    if (!this.customName.equals(playerName) && !this.customName.equals(displayName)) {
                        return false;
                    }
                } else if (!entity.m_8077_() || !entity.m_7770_().getString().equals(this.customName)) {
                    return false;
                }
            }
            if (this.nbt != null) {
                CompoundTag entityNbt = new CompoundTag();
                entity.m_20240_(entityNbt);
                if (!NbtUtils.m_129235_((Tag)this.nbt, (Tag)entityNbt, (boolean)true)) {
                    return false;
                }
            }
            return true;
        }

        public boolean canMatchEntity() {
            if (this.isTag) {
                return true;
            }
            return ForgeRegistries.ENTITY_TYPES.containsKey(this.id);
        }
    }

    public record FearedEntityDefinition(FearSourceDefinition source, boolean overrideHostility) {
        public static FearedEntityDefinition fromConfig(Config config) {
            FearSourceDefinition src = FearSourceDefinition.fromConfig(config);
            boolean override = config.getOptional("fear_override").map(o -> (Boolean)o).orElse(false);
            return new FearedEntityDefinition(src, override);
        }

        public boolean matches(ResourceLocation entityId, Entity entity) {
            return this.source.matchesEntity(entityId, entity);
        }
    }
}

