/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.manager;

import com.electronwill.nightconfig.core.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public record LightFear(boolean enabled, Mode mode, int threshold, Layer layer, int hysteresis) {
    public static LightFear fromConfig(Config cfg) {
        if (cfg == null) {
            return LightFear.disabled();
        }
        boolean enabled = cfg.getOptional("enabled").map(o -> (Boolean)o).orElse(false);
        String modeStr = cfg.getOptional("mode").map(String::valueOf).orElse("ABOVE");
        String layerStr = cfg.getOptional("layer").map(String::valueOf).orElse("COMBINED");
        int threshold = LightFear.clamp(cfg.getOptional("threshold").map(o -> ((Number)o).intValue()).orElse(11), 0, 15);
        int hysteresis = LightFear.clamp(cfg.getOptional("hysteresis").map(o -> ((Number)o).intValue()).orElse(1), 0, 15);
        Mode mode = modeStr.equalsIgnoreCase("BELOW") ? Mode.BELOW : Mode.ABOVE;
        Layer layer = switch (layerStr.toUpperCase()) {
            case "BLOCK" -> Layer.BLOCK;
            case "SKY" -> Layer.SKY;
            default -> Layer.COMBINED;
        };
        return new LightFear(enabled, mode, threshold, layer, hysteresis);
    }

    public static LightFear disabled() {
        return new LightFear(false, Mode.ABOVE, 11, Layer.COMBINED, 1);
    }

    private static int clamp(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }

    public int sampleBrightness(Level level, BlockPos pos) {
        return switch (this.layer) {
            default -> throw new IncompatibleClassChangeError();
            case Layer.BLOCK -> level.m_45517_(LightLayer.BLOCK, pos);
            case Layer.SKY -> level.m_45517_(LightLayer.SKY, pos);
            case Layer.COMBINED -> level.m_46803_(pos);
        };
    }

    public boolean isViolation(Level level, BlockPos pos) {
        int b = this.sampleBrightness(level, pos);
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.ABOVE -> {
                if (b >= this.threshold) {
                    yield true;
                }
                yield false;
            }
            case Mode.BELOW -> b <= this.threshold;
        };
    }

    public boolean isSafe(Level level, BlockPos pos) {
        int b = this.sampleBrightness(level, pos);
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.ABOVE -> {
                if (b <= Math.max(0, this.threshold - this.hysteresis)) {
                    yield true;
                }
                yield false;
            }
            case Mode.BELOW -> b >= Math.min(15, this.threshold + this.hysteresis);
        };
    }

    public static enum Mode {
        ABOVE,
        BELOW;

    }

    public static enum Layer {
        COMBINED,
        BLOCK,
        SKY;

    }
}

