/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.ai;

import com.example.firefearmod.config.ConfigHolder;
import com.example.firefearmod.manager.FearGroup;
import com.example.firefearmod.util.VisionHelper;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FireFearGoal
extends Goal {
    private final Mob mob;
    private final FearGroup fearGroup;
    private Vec3 dangerPos;
    private int scanCooldown = 0;
    private Vec3 fleeTarget;
    private int repathCooldown = 0;
    private int lostSightTicks = 0;
    private Vec3 fleeDirection = Vec3.f_82478_;
    private Vec3 dangerClusterCenter = null;
    private static final int REPATH_INTERVAL_TICKS = 12;
    private static final int MAX_LOST_SIGHT_TICKS = 20;

    public FireFearGoal(Mob mob, FearGroup fearGroup) {
        this.mob = mob;
        this.fearGroup = fearGroup;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
            return false;
        }
        this.scanCooldown = (Integer)ConfigHolder.SCAN_COOLDOWN_TICKS.get();
        this.dangerPos = this.findNearestThreat();
        return this.dangerPos != null;
    }

    public boolean m_8045_() {
        if (this.dangerPos == null) {
            return false;
        }
        double stopFleeDistSq = (this.fearGroup.searchRadius() + 2) * (this.fearGroup.searchRadius() + 2);
        if (this.mob.m_20182_().m_82557_(this.dangerPos) >= stopFleeDistSq) {
            return false;
        }
        return this.lostSightTicks <= 20;
    }

    public void m_8056_() {
        this.repathCooldown = 0;
        this.fleeTarget = null;
        this.lostSightTicks = 0;
        this.updateFleePath(true);
    }

    public void m_8041_() {
        this.dangerPos = null;
        this.fleeTarget = null;
        this.repathCooldown = 0;
        this.lostSightTicks = 0;
        this.fleeDirection = Vec3.f_82478_;
        this.dangerClusterCenter = null;
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.dangerPos == null) {
            return;
        }
        if (!VisionHelper.canSeePosition(this.mob, this.dangerPos, true)) {
            Vec3 refreshed = this.findNearestThreat();
            if (refreshed != null) {
                this.dangerPos = refreshed;
                this.lostSightTicks = 0;
            } else {
                ++this.lostSightTicks;
                if (this.lostSightTicks > 20) {
                    this.m_8041_();
                    return;
                }
            }
        } else {
            this.lostSightTicks = 0;
        }
        if (this.repathCooldown > 0) {
            --this.repathCooldown;
        }
        this.updateFleePath(false);
    }

    private Vec3 getFleePos() {
        Vec3 baseDirection = this.fleeDirection;
        if (baseDirection.m_82556_() < 1.0E-4 && this.dangerPos != null) {
            baseDirection = this.mob.m_20182_().m_82546_(this.dangerPos).m_82541_();
        }
        if (baseDirection.m_82556_() < 1.0E-4) {
            baseDirection = new Vec3(this.mob.m_217043_().m_188500_() - 0.5, 0.0, this.mob.m_217043_().m_188500_() - 0.5).m_82541_();
        }
        double fleeDistance = Math.max(6.0, (double)this.fearGroup.searchRadius());
        Vec3 desired = this.mob.m_20182_().m_82549_(baseDirection.m_82490_(fleeDistance));
        return new Vec3(desired.f_82479_, this.mob.m_20186_(), desired.f_82481_);
    }

    private void updateFleePath(boolean force) {
        if (this.dangerPos == null) {
            return;
        }
        Vec3 desiredTarget = this.getFleePos();
        if (force || this.fleeTarget == null || this.fleeTarget.m_82557_(desiredTarget) > 1.0) {
            this.fleeTarget = desiredTarget;
            this.moveToFleeTarget(desiredTarget);
            this.repathCooldown = 12;
            return;
        }
        PathNavigation navigation = this.mob.m_21573_();
        if (navigation.m_26571_() || this.repathCooldown <= 0) {
            this.moveToFleeTarget(this.fleeTarget);
            this.repathCooldown = 12;
        }
    }

    private void moveToFleeTarget(Vec3 target) {
        PathNavigation navigation = this.mob.m_21573_();
        Path path = navigation.m_7864_(BlockPos.m_274446_((Position)target), 0);
        if (path != null) {
            navigation.m_26536_(path, this.fearGroup.fleeSpeed());
        } else {
            navigation.m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, this.fearGroup.fleeSpeed());
        }
    }

    private Vec3 findNearestThreat() {
        Level level = this.mob.m_9236_();
        double closestDistSqr = Double.MAX_VALUE;
        Vec3 closestThreat = null;
        Vec3 clusterSum = Vec3.f_82478_;
        int threatCount = 0;
        if (this.canCheckBlocksNow() && !this.shouldSkipBlockCheckBecauseFireTick()) {
            BlockPos mobPos = this.mob.m_20183_();
            int radius = this.fearGroup.searchRadius();
            for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)mobPos.m_7918_(-radius, -radius / 2, -radius), (BlockPos)mobPos.m_7918_(radius, radius / 2, radius))) {
                Vec3 threatPos;
                BlockEntity blockEntity;
                BlockState blockState = level.m_8055_(checkPos);
                if (blockState.m_60795_() || !this.fearGroup.isFearedBlock(blockState, blockEntity = blockState.m_155947_() ? level.m_7702_(checkPos) : null) || !VisionHelper.canSeePosition(this.mob, threatPos = Vec3.m_82512_((Vec3i)checkPos), true)) continue;
                double distSqr = this.mob.m_20182_().m_82557_(threatPos);
                if (distSqr < closestDistSqr) {
                    closestDistSqr = distSqr;
                    closestThreat = threatPos;
                }
                clusterSum = clusterSum.m_82549_(threatPos);
                ++threatCount;
            }
        }
        if (this.fearGroup.hasFearedEntities()) {
            int radius = this.fearGroup.searchRadius();
            double vertical = Math.max(3.0, (double)radius * 0.75);
            AABB entityBox = this.mob.m_20191_().m_82377_((double)radius, vertical, (double)radius);
            List entities = level.m_6249_((Entity)this.mob, entityBox, entity -> entity != this.mob && !(entity instanceof Player));
            for (Entity entity2 : entities) {
                if (!this.fearGroup.isFearedEntity(entity2)) continue;
                Vec3 center = entity2.m_20182_().m_82520_(0.0, (double)entity2.m_20206_() * 0.5, 0.0);
                if (!VisionHelper.canSeeEntity(this.mob, entity2, true)) continue;
                double distSqr = this.mob.m_20182_().m_82557_(center);
                if (distSqr < closestDistSqr) {
                    closestDistSqr = distSqr;
                    closestThreat = center;
                }
                clusterSum = clusterSum.m_82549_(center);
                ++threatCount;
            }
        }
        AABB playerBox = this.mob.m_20191_().m_82377_((double)((Integer)ConfigHolder.PLAYER_CHECK_RADIUS.get()).intValue(), (double)((Integer)ConfigHolder.PLAYER_CHECK_VERTICAL.get()).intValue(), (double)((Integer)ConfigHolder.PLAYER_CHECK_RADIUS.get()).intValue());
        List players = level.m_45976_(Player.class, playerBox);
        for (Player player : players) {
            if (!this.isPlayerHoldingFearedItem(player) || !VisionHelper.canSeeEntity(this.mob, (Entity)player, true)) continue;
            double distSqr = this.mob.m_20280_((Entity)player);
            if (distSqr < closestDistSqr) {
                closestDistSqr = distSqr;
                closestThreat = player.m_146892_();
            }
            Vec3 center = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.5, 0.0);
            clusterSum = clusterSum.m_82549_(center);
            ++threatCount;
        }
        if (threatCount > 0) {
            this.dangerClusterCenter = clusterSum.m_82490_(1.0 / (double)threatCount);
            Vec3 away = this.mob.m_20182_().m_82546_(this.dangerClusterCenter);
            this.fleeDirection = away.m_82556_() > 1.0E-4 ? away.m_82541_() : (closestThreat != null ? this.mob.m_20182_().m_82546_(closestThreat).m_82541_() : Vec3.f_82478_);
        } else {
            this.dangerClusterCenter = null;
            this.fleeDirection = Vec3.f_82478_;
        }
        return closestThreat;
    }

    private boolean isPlayerHoldingFearedItem(Player player) {
        return this.fearGroup.isFearedItem(player.m_21205_()) || this.fearGroup.isFearedItem(player.m_21206_());
    }

    private boolean canCheckBlocksNow() {
        AABB checkArea = this.mob.m_20191_().m_82400_((double)((Integer)ConfigHolder.BLOCK_CHECK_PLAYER_RADIUS.get()).intValue());
        return !this.mob.m_9236_().m_45976_(Player.class, checkArea).isEmpty();
    }

    private boolean shouldSkipBlockCheckBecauseFireTick() {
        if (!((Boolean)ConfigHolder.SKIP_BLOCK_CHECK_IF_FIRE_TICK_OFF.get()).booleanValue()) {
            return false;
        }
        return !this.mob.m_9236_().m_46469_().m_46207_(GameRules.f_46131_);
    }
}

