/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.ai;

import com.example.firefearmod.config.ConfigHolder;
import com.example.firefearmod.manager.FearGroup;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FireFearGoal
extends Goal {
    private final Mob mob;
    private final FearGroup fearGroup;
    private Vec3 dangerPos;
    private int scanCooldown = 0;

    public FireFearGoal(Mob mob, FearGroup fearGroup) {
        this.mob = mob;
        this.fearGroup = fearGroup;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
            return false;
        }
        this.scanCooldown = (Integer)ConfigHolder.SCAN_COOLDOWN_TICKS.get();
        this.dangerPos = this.findNearestThreat();
        return this.dangerPos != null;
    }

    public boolean m_8045_() {
        if (this.dangerPos == null) {
            return false;
        }
        double stopFleeDistSq = (this.fearGroup.searchRadius() + 2) * (this.fearGroup.searchRadius() + 2);
        return this.mob.m_20182_().m_82557_(this.dangerPos) < stopFleeDistSq && this.hasLineOfSight(this.dangerPos);
    }

    public void m_8056_() {
    }

    public void m_8041_() {
        this.dangerPos = null;
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.dangerPos == null) {
            return;
        }
        PathNavigation navigation = this.mob.m_21573_();
        Vec3 fleePos = this.getFleePos();
        navigation.m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, this.fearGroup.fleeSpeed());
    }

    private Vec3 getFleePos() {
        return new Vec3(this.mob.m_20185_() + (this.mob.m_20185_() - this.dangerPos.m_7096_()), this.mob.m_20186_(), this.mob.m_20189_() + (this.mob.m_20189_() - this.dangerPos.m_7094_()));
    }

    private Vec3 findNearestThreat() {
        Level level = this.mob.m_9236_();
        double closestDistSqr = Double.MAX_VALUE;
        Vec3 closestThreat = null;
        if (this.canCheckBlocksNow() && !this.shouldSkipBlockCheckBecauseFireTick()) {
            BlockPos mobPos = this.mob.m_20183_();
            int radius = this.fearGroup.searchRadius();
            for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)mobPos.m_7918_(-radius, -radius / 2, -radius), (BlockPos)mobPos.m_7918_(radius, radius / 2, radius))) {
                double distSqr;
                Vec3 threatPos;
                BlockEntity blockEntity;
                BlockState blockState = level.m_8055_(checkPos);
                if (blockState.m_60795_() || !this.fearGroup.isFearedBlock(blockState, blockEntity = blockState.m_155947_() ? level.m_7702_(checkPos) : null) || !this.hasLineOfSight(threatPos = Vec3.m_82512_((Vec3i)checkPos)) || !((distSqr = this.mob.m_20182_().m_82557_(threatPos)) < closestDistSqr)) continue;
                closestDistSqr = distSqr;
                closestThreat = threatPos;
            }
        }
        AABB playerBox = this.mob.m_20191_().m_82377_((double)((Integer)ConfigHolder.PLAYER_CHECK_RADIUS.get()).intValue(), (double)((Integer)ConfigHolder.PLAYER_CHECK_VERTICAL.get()).intValue(), (double)((Integer)ConfigHolder.PLAYER_CHECK_RADIUS.get()).intValue());
        List players = level.m_45976_(Player.class, playerBox);
        for (Player player : players) {
            double distSqr;
            if (!this.isPlayerHoldingFearedItem(player) || !this.hasLineOfSight(player.m_20182_()) || !((distSqr = this.mob.m_20280_((Entity)player)) < closestDistSqr)) continue;
            closestDistSqr = distSqr;
            closestThreat = player.m_20182_();
        }
        return closestThreat;
    }

    private boolean isPlayerHoldingFearedItem(Player player) {
        return this.fearGroup.isFearedItem(player.m_21205_()) || this.fearGroup.isFearedItem(player.m_21206_());
    }

    private boolean hasLineOfSight(Vec3 target) {
        Vec3 eyePos = this.mob.m_146892_();
        ClipContext context = new ClipContext(eyePos, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob);
        return this.mob.m_9236_().m_45547_(context).m_6662_() == HitResult.Type.MISS;
    }

    private boolean canCheckBlocksNow() {
        AABB checkArea = this.mob.m_20191_().m_82400_((double)((Integer)ConfigHolder.BLOCK_CHECK_PLAYER_RADIUS.get()).intValue());
        return !this.mob.m_9236_().m_45976_(Player.class, checkArea).isEmpty();
    }

    private boolean shouldSkipBlockCheckBecauseFireTick() {
        if (!((Boolean)ConfigHolder.SKIP_BLOCK_CHECK_IF_FIRE_TICK_OFF.get()).booleanValue()) {
            return false;
        }
        return !this.mob.m_9236_().m_46469_().m_46207_(GameRules.f_46131_);
    }
}

