/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.manager;

import com.electronwill.nightconfig.core.Config;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public record FearGroup(String groupId, double fleeSpeed, int searchRadius, List<MobDefinition> mobs, List<FearSourceDefinition> fearedBlocks, List<FearSourceDefinition> fearedItems) {
    public static FearGroup fromConfig(Config config) {
        String groupId = (String)config.get("group_id");
        double fleeSpeed = config.getOptional("flee_speed").map(o -> ((Number)o).doubleValue()).orElse(1.2);
        int searchRadius = config.getOptional("search_radius").map(o -> ((Number)o).intValue()).orElse(8);
        List<MobDefinition> mobs = ((List)config.get("mobs")).stream().map(MobDefinition::fromConfig).collect(Collectors.toList());
        List<FearSourceDefinition> fearedBlocks = ((List)config.get("feared_blocks")).stream().map(FearSourceDefinition::fromConfig).collect(Collectors.toList());
        List<FearSourceDefinition> fearedItems = ((List)config.get("feared_items")).stream().map(FearSourceDefinition::fromConfig).collect(Collectors.toList());
        return new FearGroup(groupId, fleeSpeed, searchRadius, mobs, fearedBlocks, fearedItems);
    }

    public int getMatchScore(Mob mob) {
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (mobId == null) {
            return -1;
        }
        int bestScore = -1;
        for (MobDefinition def : this.mobs) {
            int score = def.getMatchScore(mob, mobId);
            if (score <= bestScore) continue;
            bestScore = score;
        }
        return bestScore;
    }

    public boolean isFearedBlock(BlockState blockState, @Nullable BlockEntity blockEntity) {
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
        if (blockId == null) {
            return false;
        }
        for (FearSourceDefinition def : this.fearedBlocks) {
            if (!def.matches(blockId, blockState, blockEntity, null)) continue;
            return true;
        }
        return false;
    }

    public boolean isFearedItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return false;
        }
        for (FearSourceDefinition def : this.fearedItems) {
            if (!def.matches(itemId, null, null, stack)) continue;
            return true;
        }
        return false;
    }

    public record MobDefinition(ResourceLocation id, @Nullable String customName, @Nullable CompoundTag nbt) {
        public static MobDefinition fromConfig(Config config) {
            ResourceLocation id = new ResourceLocation((String)config.get("id"));
            String customName = config.getOptional("custom_name").map(String::valueOf).orElse(null);
            CompoundTag nbt = config.getOptional("nbt").map(nbtStr -> {
                try {
                    return TagParser.m_129359_((String)((String)nbtStr));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid NBT: " + e.getMessage());
                }
            }).orElse(null);
            return new MobDefinition(id, customName, nbt);
        }

        public int getMatchScore(Mob mob, ResourceLocation mobId) {
            boolean nbtMatch;
            if (!this.id.equals((Object)mobId)) {
                return -1;
            }
            boolean nameMatch = this.customName == null || mob.m_8077_() && mob.m_7755_().getString().equals(this.customName);
            boolean bl = nbtMatch = this.nbt == null || NbtUtils.m_129235_((Tag)this.nbt, (Tag)mob.m_20240_(new CompoundTag()), (boolean)true);
            if (!nameMatch || !nbtMatch) {
                return -1;
            }
            int score = 0;
            if (this.customName != null) {
                score += 2;
            }
            if (this.nbt != null) {
                ++score;
            }
            return score;
        }
    }

    public record FearSourceDefinition(ResourceLocation id, boolean isTag, @Nullable String customName, @Nullable Config states, @Nullable CompoundTag nbt) {
        public static FearSourceDefinition fromConfig(Config config) {
            String raw = (String)config.get("id");
            boolean isTag = false;
            if (raw.startsWith("#")) {
                isTag = true;
                raw = raw.substring(1);
            }
            ResourceLocation id = new ResourceLocation(raw);
            String customName = config.getOptional("custom_name").map(String::valueOf).orElse(null);
            Config states = config.getOptional("states").map(o -> (Config)o).orElse(null);
            CompoundTag nbt = config.getOptional("nbt").map(nbtStr -> {
                try {
                    return TagParser.m_129359_((String)((String)nbtStr));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid NBT: " + e.getMessage());
                }
            }).orElse(null);
            return new FearSourceDefinition(id, isTag, customName, states, nbt);
        }

        public boolean matches(ResourceLocation targetId, @Nullable BlockState blockState, @Nullable BlockEntity blockEntity, @Nullable ItemStack itemStack) {
            if (blockState != null) {
                Object tagKey;
                if (this.isTag ? !blockState.m_204336_((TagKey)(tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)this.id))) : !this.id.equals((Object)targetId)) {
                    return false;
                }
                if (this.states != null) {
                    for (Config.Entry entry : this.states.entrySet()) {
                        String key = entry.getKey();
                        if (key == null) continue;
                        Property property = blockState.m_60734_().m_49965_().m_61081_(key);
                        if (property == null) {
                            return false;
                        }
                        Optional value = property.m_6215_(entry.getValue().toString());
                        if (!value.isEmpty() && blockState.m_61143_(property).equals(value.get())) continue;
                        return false;
                    }
                }
                if (this.nbt != null) {
                    if (blockEntity == null) {
                        return false;
                    }
                    CompoundTag blockNbt = blockEntity.m_187482_();
                    if (!NbtUtils.m_129235_((Tag)this.nbt, (Tag)blockNbt, (boolean)true)) {
                        return false;
                    }
                }
                return true;
            }
            if (itemStack != null) {
                CompoundTag itemNbt;
                TagKey tagKey;
                if (this.isTag ? !itemStack.m_204117_(tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.id)) : !this.id.equals((Object)targetId)) {
                    return false;
                }
                if (!(this.customName == null || itemStack.m_41788_() && itemStack.m_41786_().getString().equals(this.customName))) {
                    return false;
                }
                return this.nbt == null || (itemNbt = itemStack.m_41783_()) != null && NbtUtils.m_129235_((Tag)this.nbt, (Tag)itemNbt, (boolean)true);
            }
            return false;
        }
    }
}

