/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.ai;

import com.example.firefearmod.config.ConfigHolder;
import com.example.firefearmod.manager.FearGroup;
import com.example.firefearmod.manager.IFearProfile;
import com.example.firefearmod.util.VisionHelper;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FireFearGoal
extends Goal {
    private final Mob mob;
    private final IFearProfile fearGroup;
    private Vec3 dangerPos;
    private int scanCooldown = 0;
    private Vec3 fleeTarget;
    private int repathCooldown = 0;
    private int lostSightTicks = 0;
    private Vec3 fleeDirection = Vec3.f_82478_;
    private Vec3 dangerClusterCenter = null;
    private boolean overrideHostilityActive = false;
    private boolean targetingSuppressed = false;
    private IFearProfile.VisibilityMode dangerVisibilityMode = IFearProfile.VisibilityMode.LOOK_BASED;
    private static final int REPATH_INTERVAL_TICKS = 12;
    private static final int MAX_LOST_SIGHT_TICKS = 40;
    private static final double OVERRIDE_PRIORITY_BONUS = 16.0;
    private static final double DIRECTION_RETENTION = 0.7;

    public FireFearGoal(Mob mob, IFearProfile fearGroup) {
        this.mob = mob;
        this.fearGroup = fearGroup;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
            return false;
        }
        this.scanCooldown = (Integer)ConfigHolder.SCAN_COOLDOWN_TICKS.get();
        this.dangerPos = this.findNearestThreat();
        return this.dangerPos != null;
    }

    public boolean m_8045_() {
        if (this.dangerPos == null) {
            return false;
        }
        double stopFleeDistSq = (this.fearGroup.searchRadius() + 2) * (this.fearGroup.searchRadius() + 2);
        if (this.mob.m_20182_().m_82557_(this.dangerPos) >= stopFleeDistSq) {
            return false;
        }
        return this.lostSightTicks <= 40;
    }

    public void m_8056_() {
        this.repathCooldown = 0;
        this.fleeTarget = null;
        this.lostSightTicks = 0;
        if (this.overrideHostilityActive) {
            this.suppressHostileTarget();
        }
        this.updateFleePath(true);
    }

    public void m_8041_() {
        this.dangerPos = null;
        this.fleeTarget = null;
        this.repathCooldown = 0;
        this.lostSightTicks = 0;
        this.fleeDirection = Vec3.f_82478_;
        this.dangerClusterCenter = null;
        this.overrideHostilityActive = false;
        this.dangerVisibilityMode = IFearProfile.VisibilityMode.LOOK_BASED;
        this.restoreTargetControl();
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.dangerPos == null) {
            return;
        }
        if (this.dangerVisibilityMode == IFearProfile.VisibilityMode.ALWAYS) {
            Vec3 refreshed = this.findNearestThreat();
            if (refreshed != null) {
                this.dangerPos = refreshed;
                this.lostSightTicks = 0;
            } else {
                ++this.lostSightTicks;
                if (this.lostSightTicks > 40) {
                    this.m_8041_();
                    return;
                }
            }
        } else if (!VisionHelper.canSeePosition(this.mob, this.dangerPos, true)) {
            Vec3 refreshed = this.findNearestThreat();
            if (refreshed != null) {
                this.dangerPos = refreshed;
                this.lostSightTicks = 0;
            } else {
                ++this.lostSightTicks;
                if (this.lostSightTicks > 40) {
                    this.m_8041_();
                    return;
                }
            }
        } else {
            this.lostSightTicks = 0;
        }
        if (this.overrideHostilityActive) {
            this.suppressHostileTarget();
        } else {
            this.restoreTargetControl();
        }
        if (this.repathCooldown > 0) {
            --this.repathCooldown;
        }
        this.updateFleePath(false);
    }

    public boolean m_6767_() {
        return false;
    }

    private Vec3 getFleePos() {
        Vec3 baseDirection = this.fleeDirection;
        if (baseDirection.m_82556_() < 1.0E-4 && this.dangerPos != null) {
            baseDirection = this.mob.m_20182_().m_82546_(this.dangerPos).m_82541_();
        }
        if (baseDirection.m_82556_() < 1.0E-4) {
            baseDirection = new Vec3(this.mob.m_217043_().m_188500_() - 0.5, 0.0, this.mob.m_217043_().m_188500_() - 0.5).m_82541_();
        }
        double fleeDistance = Math.max(6.0, (double)this.fearGroup.searchRadius());
        Vec3 desired = this.mob.m_20182_().m_82549_(baseDirection.m_82490_(fleeDistance));
        Mob mob = this.mob;
        if (mob instanceof PathfinderMob) {
            Vec3 away;
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            if (this.dangerClusterCenter != null ? (away = DefaultRandomPos.m_148407_((PathfinderMob)pathfinderMob, (int)((int)Math.ceil(fleeDistance)), (int)4, (Vec3)this.dangerClusterCenter)) != null : this.dangerPos != null && (away = DefaultRandomPos.m_148407_((PathfinderMob)pathfinderMob, (int)((int)Math.ceil(fleeDistance)), (int)4, (Vec3)this.dangerPos)) != null) {
                return away;
            }
        }
        return new Vec3(desired.f_82479_, this.mob.m_20186_(), desired.f_82481_);
    }

    private void updateFleePath(boolean force) {
        if (this.dangerPos == null) {
            return;
        }
        Vec3 desiredTarget = this.getFleePos();
        if (force || this.fleeTarget == null || this.fleeTarget.m_82557_(desiredTarget) > 1.0) {
            this.fleeTarget = desiredTarget;
            this.moveToFleeTarget(desiredTarget);
            this.repathCooldown = 12;
            return;
        }
        PathNavigation navigation = this.mob.m_21573_();
        if (navigation.m_26571_() || this.repathCooldown <= 0) {
            this.moveToFleeTarget(this.fleeTarget);
            this.repathCooldown = 12;
        }
    }

    private void moveToFleeTarget(Vec3 target) {
        PathNavigation navigation = this.mob.m_21573_();
        Path path = navigation.m_7864_(BlockPos.m_274446_((Position)target), 0);
        if (path != null) {
            navigation.m_26536_(path, this.fearGroup.fleeSpeed());
        } else {
            navigation.m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, this.fearGroup.fleeSpeed());
        }
    }

    private Vec3 findNearestThreat() {
        Level level = this.mob.m_9236_();
        boolean hasHostileTarget = this.mob.m_5448_() != null;
        double bestPriority = Double.MAX_VALUE;
        Vec3 closestThreat = null;
        Vec3 clusterSum = Vec3.f_82478_;
        int threatCount = 0;
        boolean anyOverrideThreatVisible = false;
        IFearProfile.VisibilityMode bestMode = IFearProfile.VisibilityMode.LOOK_BASED;
        if (this.canCheckBlocksNow() && !this.shouldSkipBlockCheckBecauseFireTick()) {
            BlockPos mobPos = this.mob.m_20183_();
            int radius = this.fearGroup.searchRadius();
            for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)mobPos.m_7918_(-radius, -radius / 2, -radius), (BlockPos)mobPos.m_7918_(radius, radius / 2, radius))) {
                Vec3 threatPos;
                Iterator blockEntity;
                FearGroup.FearSourceDefinition blockDef;
                BlockState blockState = level.m_8055_(checkPos);
                if (blockState.m_60795_() || (blockDef = this.fearGroup.findFearedBlock(blockState, (BlockEntity)(blockEntity = blockState.m_155947_() ? level.m_7702_(checkPos) : null))) == null || hasHostileTarget && !blockDef.fearOverride() || !VisionHelper.canSeePosition(this.mob, threatPos = Vec3.m_82512_((Vec3i)checkPos), true)) continue;
                double distSqr = this.mob.m_20182_().m_82557_(threatPos);
                double priority = distSqr - (blockDef.fearOverride() ? 16.0 : 0.0);
                if (priority < bestPriority) {
                    bestPriority = priority;
                    closestThreat = threatPos;
                }
                clusterSum = clusterSum.m_82549_(threatPos);
                ++threatCount;
                if (anyOverrideThreatVisible || !blockDef.fearOverride()) continue;
                anyOverrideThreatVisible = true;
            }
        }
        if (this.fearGroup.hasFearedEntities()) {
            int radius = this.fearGroup.searchRadius();
            double vertical = Math.max(3.0, (double)radius * 0.75);
            AABB entityBox = this.mob.m_20191_().m_82377_((double)radius, vertical, (double)radius);
            List entities = level.m_6249_((Entity)this.mob, entityBox, entity -> entity != this.mob);
            for (Entity entity2 : entities) {
                IFearProfile.VisibilityMode mode;
                boolean visible;
                if (!this.fearGroup.isFearedEntity(entity2) || !(visible = (mode = this.fearGroup.getEntityVisibilityMode(entity2)) == IFearProfile.VisibilityMode.ALWAYS ? VisionHelper.canSeeEntity(this.mob, entity2, true) : this.isMutuallyVisible(entity2))) continue;
                Vec3 center = entity2.m_20182_().m_82520_(0.0, (double)entity2.m_20206_() * 0.5, 0.0);
                boolean override = this.fearGroup.shouldOverrideHostility(entity2);
                double distSqr = this.mob.m_20182_().m_82557_(center);
                double priority = distSqr - (override ? 16.0 : 0.0);
                if (priority < bestPriority) {
                    bestPriority = priority;
                    closestThreat = center;
                    bestMode = mode;
                }
                clusterSum = clusterSum.m_82549_(center);
                ++threatCount;
                if (anyOverrideThreatVisible || !override) continue;
                anyOverrideThreatVisible = true;
            }
        }
        AABB playerBox = this.mob.m_20191_().m_82377_((double)((Integer)ConfigHolder.PLAYER_CHECK_RADIUS.get()).intValue(), (double)((Integer)ConfigHolder.PLAYER_CHECK_VERTICAL.get()).intValue(), (double)((Integer)ConfigHolder.PLAYER_CHECK_RADIUS.get()).intValue());
        List players = level.m_45976_(Player.class, playerBox);
        for (Player player : players) {
            boolean playerIsFearedEntity = this.fearGroup.isFearedEntity((Entity)player);
            if (playerIsFearedEntity) {
                boolean override;
                IFearProfile.VisibilityMode mode = this.fearGroup.getEntityVisibilityMode((Entity)player);
                boolean visible = mode == IFearProfile.VisibilityMode.ALWAYS ? VisionHelper.canSeeEntity(this.mob, (Entity)player, true) : this.isMutuallyVisible((Entity)player);
                if (!visible) continue;
                double distSqr = this.mob.m_20280_((Entity)player);
                double priority = distSqr - ((override = this.fearGroup.shouldOverrideHostility((Entity)player)) ? 16.0 : 0.0);
                if (priority < bestPriority) {
                    bestPriority = priority;
                    closestThreat = player.m_146892_();
                    bestMode = mode;
                }
                Vec3 center = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.5, 0.0);
                clusterSum = clusterSum.m_82549_(center);
                ++threatCount;
                if (anyOverrideThreatVisible || !override) continue;
                anyOverrideThreatVisible = true;
                continue;
            }
            FearGroup.FearSourceDefinition heldFear = this.getPlayerHeldFearSource(player);
            if (heldFear == null || hasHostileTarget && !heldFear.fearOverride() || !VisionHelper.canSeeEntity(this.mob, (Entity)player, true)) continue;
            double distSqr = this.mob.m_20280_((Entity)player);
            double priority = distSqr - (heldFear.fearOverride() ? 16.0 : 0.0);
            if (priority < bestPriority) {
                bestPriority = priority;
                closestThreat = player.m_146892_();
            }
            Vec3 center = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.5, 0.0);
            clusterSum = clusterSum.m_82549_(center);
            ++threatCount;
            if (anyOverrideThreatVisible || !heldFear.fearOverride()) continue;
            anyOverrideThreatVisible = true;
        }
        if (threatCount > 0) {
            Vec3 candidate;
            this.dangerClusterCenter = clusterSum.m_82490_(1.0 / (double)threatCount);
            Vec3 away = this.mob.m_20182_().m_82546_(this.dangerClusterCenter);
            Vec3 newDir = Vec3.f_82478_;
            if (away.m_82556_() > 1.0E-4) {
                newDir = away.m_82541_();
            } else if (closestThreat != null && (candidate = this.mob.m_20182_().m_82546_(closestThreat).m_82541_()).m_82556_() > 1.0E-4) {
                newDir = candidate;
            }
            if (newDir.m_82556_() > 1.0E-4) {
                Vec3 blended;
                double len;
                this.fleeDirection = this.fleeDirection.m_82556_() > 1.0E-4 ? ((len = (blended = this.fleeDirection.m_82490_(0.7).m_82549_(newDir.m_82490_(0.30000000000000004))).m_82553_()) > 1.0E-4 ? blended.m_82490_(1.0 / len) : newDir) : newDir;
            }
        } else {
            this.dangerClusterCenter = null;
            this.fleeDirection = Vec3.f_82478_;
        }
        this.overrideHostilityActive = anyOverrideThreatVisible;
        this.dangerVisibilityMode = bestMode;
        if (anyOverrideThreatVisible && this.mob.m_5448_() != null) {
            this.suppressHostileTarget();
        }
        return closestThreat;
    }

    private boolean isMutuallyVisible(Entity entity) {
        if (!VisionHelper.canSeeEntity(this.mob, entity, true)) {
            return false;
        }
        if (entity instanceof Mob) {
            Mob otherMob = (Mob)entity;
            return VisionHelper.canSeeEntity(otherMob, (Entity)this.mob, true);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Vec3 playerEye = player.m_146892_();
            Vec3 view = player.m_20252_(1.0f);
            Vec3 toMob = this.mob.m_146892_().m_82546_(playerEye);
            double length = toMob.m_82553_();
            if (length < 1.0E-6) {
                return true;
            }
            Vec3 toMobNorm = toMob.m_82490_(1.0 / length);
            if (Double.isNaN(toMobNorm.f_82479_) || Double.isNaN(toMobNorm.f_82480_) || Double.isNaN(toMobNorm.f_82481_)) {
                return false;
            }
            Vec3 viewHorizontal = new Vec3(view.f_82479_, 0.0, view.f_82481_);
            Vec3 targetHorizontal = new Vec3(toMobNorm.f_82479_, 0.0, toMobNorm.f_82481_);
            if (viewHorizontal.m_82556_() < 1.0E-6 || targetHorizontal.m_82556_() < 1.0E-6) {
                return true;
            }
            double dotHorizontal = viewHorizontal.m_82541_().m_82526_(targetHorizontal.m_82541_());
            double clampedHorizontal = Math.max(-1.0, Math.min(1.0, dotHorizontal));
            double angleHorizontal = Math.toDegrees(Math.acos(clampedHorizontal));
            if (angleHorizontal > 60.0) {
                return false;
            }
            double lookPitch = Math.toDegrees(Math.asin(Math.max(-1.0, Math.min(1.0, view.f_82480_))));
            double targetPitch = Math.toDegrees(Math.asin(Math.max(-1.0, Math.min(1.0, toMobNorm.f_82480_))));
            double verticalDiff = Math.abs(targetPitch - lookPitch);
            return verticalDiff <= 60.0;
        }
        return true;
    }

    @Nullable
    private FearGroup.FearSourceDefinition getPlayerHeldFearSource(Player player) {
        FearGroup.FearSourceDefinition main = this.fearGroup.findFearedItem(player.m_21205_());
        if (main != null) {
            return main;
        }
        return this.fearGroup.findFearedItem(player.m_21206_());
    }

    private void suppressHostileTarget() {
        GoalSelector selector;
        if (this.mob.m_5448_() != null) {
            this.mob.m_6710_(null);
        }
        this.mob.m_6703_(null);
        this.mob.m_21561_(false);
        if (!this.targetingSuppressed && (selector = this.mob.f_21346_) != null) {
            selector.m_25355_(Goal.Flag.TARGET);
            this.targetingSuppressed = true;
        }
    }

    private void restoreTargetControl() {
        if (!this.targetingSuppressed) {
            return;
        }
        GoalSelector selector = this.mob.f_21346_;
        if (selector != null) {
            selector.m_25374_(Goal.Flag.TARGET);
        }
        this.targetingSuppressed = false;
    }

    private boolean canCheckBlocksNow() {
        AABB checkArea = this.mob.m_20191_().m_82400_((double)((Integer)ConfigHolder.BLOCK_CHECK_PLAYER_RADIUS.get()).intValue());
        return !this.mob.m_9236_().m_45976_(Player.class, checkArea).isEmpty();
    }

    private boolean shouldSkipBlockCheckBecauseFireTick() {
        if (!((Boolean)ConfigHolder.SKIP_BLOCK_CHECK_IF_FIRE_TICK_OFF.get()).booleanValue()) {
            return false;
        }
        return !this.mob.m_9236_().m_46469_().m_46207_(GameRules.f_46131_);
    }
}

