/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.breeding;

import com.example.firefearmod.breeding.ForcedBreedingRule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForcedBreedingManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FOLDER = "forced_breeding";
    private static final Map<ResourceLocation, List<ForcedBreedingRule>> RULES_BY_MOB = new HashMap<ResourceLocation, List<ForcedBreedingRule>>();
    private static final Map<ResourceLocation, List<ForcedBreedingRule>> RULES_BY_ITEM = new HashMap<ResourceLocation, List<ForcedBreedingRule>>();

    public ForcedBreedingManager() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        RULES_BY_MOB.clear();
        RULES_BY_ITEM.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation fileId = entry.getKey();
            try {
                JsonObject obj = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"forced_breeding_rule");
                boolean enabled = obj.has("enabled") ? GsonHelper.m_13912_((JsonObject)obj, (String)"enabled") : true;
                String mobStr = GsonHelper.m_13906_((JsonObject)obj, (String)"mob");
                String childStr = obj.has("child") ? GsonHelper.m_13906_((JsonObject)obj, (String)"child") : mobStr;
                String itemStr = obj.has("item") ? GsonHelper.m_13906_((JsonObject)obj, (String)"item") : null;
                String requiredHeldStr = obj.has("require_held_item") ? GsonHelper.m_13906_((JsonObject)obj, (String)"require_held_item") : null;
                ResourceLocation mobId = new ResourceLocation(mobStr);
                ResourceLocation childId = new ResourceLocation(childStr);
                ResourceLocation itemId = itemStr != null ? new ResourceLocation(itemStr) : null;
                ResourceLocation requiredHeldItem = requiredHeldStr != null ? new ResourceLocation(requiredHeldStr) : null;
                double partnerRadius = obj.has("partner_radius") ? GsonHelper.m_144784_((JsonObject)obj, (String)"partner_radius") : 8.0;
                int cooldownTicks = obj.has("cooldown_ticks") ? GsonHelper.m_13927_((JsonObject)obj, (String)"cooldown_ticks") : 6000;
                int maxNearbyChildren = obj.has("max_nearby_children") ? GsonHelper.m_13927_((JsonObject)obj, (String)"max_nearby_children") : 6;
                boolean consumeItem = obj.has("consume_item") && GsonHelper.m_13912_((JsonObject)obj, (String)"consume_item");
                ForcedBreedingRule rule = new ForcedBreedingRule(fileId, enabled, itemId, mobId, childId, partnerRadius, cooldownTicks, maxNearbyChildren, consumeItem, requiredHeldItem);
                RULES_BY_MOB.computeIfAbsent(mobId, k -> new ArrayList()).add(rule);
                if (itemId == null) continue;
                RULES_BY_ITEM.computeIfAbsent(itemId, k -> new ArrayList()).add(rule);
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse forced breeding rule JSON {}: {}", (Object)fileId, (Object)e.getMessage());
            }
        }
        LOGGER.info("Loaded {} forced breeding mob entries.", (Object)RULES_BY_MOB.size());
    }

    public static Collection<ForcedBreedingRule> getAllRules() {
        ArrayList<ForcedBreedingRule> all = new ArrayList<ForcedBreedingRule>();
        for (List<ForcedBreedingRule> list : RULES_BY_MOB.values()) {
            all.addAll(list);
        }
        return Collections.unmodifiableCollection(all);
    }

    public static List<ForcedBreedingRule> getRulesFor(Mob mob, ItemStack stack) {
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (mobId == null) {
            return List.of();
        }
        List<ForcedBreedingRule> byMob = RULES_BY_MOB.get(mobId);
        if (byMob == null || byMob.isEmpty()) {
            return List.of();
        }
        ArrayList<ForcedBreedingRule> result = new ArrayList<ForcedBreedingRule>();
        for (ForcedBreedingRule rule : byMob) {
            if (!rule.enabled()) continue;
            result.add(rule);
        }
        return result;
    }
}

