/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.trauma;

import com.example.firefearmod.config.ConfigHolder;
import com.example.firefearmod.manager.FearGroup;
import com.example.firefearmod.trauma.ITraumaData;
import com.example.firefearmod.trauma.TraumaCapability;
import com.example.firefearmod.trauma.TraumaGroup;
import com.example.firefearmod.trauma.TraumaGroupManager;
import com.example.firefearmod.util.VisionHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="firefearmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TraumaEvents {
    @SubscribeEvent
    public static void onMobHurt(LivingHurtEvent event) {
        Mob mob;
        block8: {
            block7: {
                if (!((Boolean)ConfigHolder.INTERGENERATIONAL_TRAUMA_ENABLED.get()).booleanValue()) {
                    return;
                }
                LivingEntity living = event.getEntity();
                if (!(living instanceof Mob)) break block7;
                mob = (Mob)living;
                if (!mob.m_9236_().f_46443_) break block8;
            }
            return;
        }
        ITraumaData data = (ITraumaData)TraumaCapability.get(mob).orElse(null);
        if (data == null) {
            return;
        }
        List<TraumaGroup> groups = TraumaGroupManager.getGroupsForMob(mob);
        if (groups.isEmpty()) {
            return;
        }
        DamageSource source = event.getSource();
        int maxStagesGlobal = (Integer)ConfigHolder.MAX_TRAUMA_STAGES_PER_GROUP.get();
        for (TraumaGroup group : groups) {
            TraumaGroup.TraumaStage nextStageDef;
            int currentStage = TraumaEvents.getActiveStageIndex(group, data);
            int nextStage = currentStage + 1;
            if (nextStage < 0 || nextStage >= group.stages().size() || !TraumaEvents.shouldAdvanceFromDirectRequirements(group, nextStageDef = group.stages().get(nextStage), mob, source)) continue;
            data.setStage(group.id(), nextStage, maxStagesGlobal);
            TraumaEvents.applyWitnessLearning(mob, group, nextStage);
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        ITraumaData dataB;
        Mob mB;
        Mob parentB;
        Mob mA;
        if (!((Boolean)ConfigHolder.INTERGENERATIONAL_TRAUMA_ENABLED.get()).booleanValue()) {
            return;
        }
        AgeableMob child = event.getChild();
        if (child.m_9236_().f_46443_) {
            return;
        }
        Mob parentAEntity = event.getParentA();
        Mob parentBEntity = event.getParentB();
        Mob parentA = parentAEntity instanceof Mob ? (mA = parentAEntity) : null;
        Mob mob = parentB = parentBEntity instanceof Mob ? (mB = parentBEntity) : null;
        if (parentA == null && parentB == null) {
            return;
        }
        ITraumaData childData = (ITraumaData)TraumaCapability.get((Mob)child).orElse(null);
        ITraumaData dataA = parentA != null ? (ITraumaData)TraumaCapability.get(parentA).orElse(null) : null;
        ITraumaData iTraumaData = dataB = parentB != null ? (ITraumaData)TraumaCapability.get(parentB).orElse(null) : null;
        if (childData == null || dataA == null && dataB == null) {
            return;
        }
        List<TraumaGroup> childGroups = TraumaGroupManager.getGroupsForMob((Mob)child);
        if (childGroups.isEmpty()) {
            return;
        }
        int maxStagesGlobal = (Integer)ConfigHolder.MAX_TRAUMA_STAGES_PER_GROUP.get();
        for (TraumaGroup group : childGroups) {
            int stageB;
            int stageA = dataA != null ? dataA.getStage(group.id()) : 0;
            int inherited = Math.max(stageA, stageB = dataB != null ? dataB.getStage(group.id()) : 0);
            if (inherited <= 0) continue;
            childData.setStage(group.id(), inherited, maxStagesGlobal);
        }
        childData.clampStages(maxStagesGlobal);
    }

    private static int getActiveStageIndex(TraumaGroup group, ITraumaData data) {
        int maxIndex;
        int stage = data.getStage(group.id());
        if (stage < 0) {
            stage = 0;
        }
        if (stage > (maxIndex = group.stages().size() - 1)) {
            stage = maxIndex;
        }
        return stage;
    }

    private static boolean shouldAdvanceFromDirectRequirements(TraumaGroup group, TraumaGroup.TraumaStage targetStage, Mob victim, DamageSource source) {
        for (TraumaGroup.TraumaRequirement req : targetStage.requirements()) {
            switch (req.type()) {
                case HURT_BY_ENTITY: {
                    if (!TraumaEvents.isHurtByEntityRequirementMet(req, source)) break;
                    return true;
                }
                case HURT_BY_SOURCE: {
                    if (!TraumaEvents.isHurtBySourceRequirementMet(req, victim, source)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHurtByEntityRequirementMet(TraumaGroup.TraumaRequirement req, DamageSource source) {
        FearGroup.FearedEntityDefinition def = req.entityDefinition();
        if (def == null) {
            return false;
        }
        Entity attacker = source.m_7639_();
        if (attacker == null) {
            return false;
        }
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)attacker.m_6095_());
        if (id == null) {
            return false;
        }
        return def.matches(id, attacker);
    }

    private static boolean isHurtBySourceRequirementMet(TraumaGroup.TraumaRequirement req, Mob victim, DamageSource source) {
        BlockPos basePos;
        LivingEntity living;
        FearGroup.FearSourceDefinition def = req.sourceDefinition();
        if (def == null) {
            return false;
        }
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity && (TraumaEvents.matchesHeldItem(def, (living = (LivingEntity)attacker).m_21205_()) || TraumaEvents.matchesHeldItem(def, living.m_21206_()))) {
            return true;
        }
        Level level = victim.m_9236_();
        return TraumaEvents.matchesBlockAt(def, level, basePos = victim.m_20183_()) || TraumaEvents.matchesBlockAt(def, level, basePos.m_7495_());
    }

    private static boolean matchesHeldItem(FearGroup.FearSourceDefinition def, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return false;
        }
        return def.matches(itemId, null, null, stack);
    }

    private static boolean matchesBlockAt(FearGroup.FearSourceDefinition def, Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        BlockEntity be = state.m_155947_() ? level.m_7702_(pos) : null;
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (blockId == null) {
            return false;
        }
        return def.matches(blockId, state, be, null);
    }

    private static void applyWitnessLearning(Mob victim, TraumaGroup group, int targetStageIndex) {
        double radius;
        List<TraumaGroup.TraumaStage> stages = group.stages();
        if (targetStageIndex < 0 || targetStageIndex >= stages.size()) {
            return;
        }
        TraumaGroup.TraumaStage stage = stages.get(targetStageIndex);
        double d = radius = stage.witnessRadius() != null ? stage.witnessRadius().doubleValue() : group.defaultWitnessRadius();
        if (radius <= 0.0) {
            return;
        }
        Level level = victim.m_9236_();
        double vertical = radius;
        AABB box = victim.m_20191_().m_82377_(radius, vertical, radius);
        int maxStagesGlobal = (Integer)ConfigHolder.MAX_TRAUMA_STAGES_PER_GROUP.get();
        List watchers = level.m_6443_(Mob.class, box, m -> m != victim);
        for (Mob watcher : watchers) {
            int currentStage;
            ITraumaData data;
            if (watcher.m_9236_().f_46443_ || !VisionHelper.canSeeEntity(watcher, (Entity)victim, true) || (data = (ITraumaData)TraumaCapability.get(watcher).orElse(null)) == null || !TraumaGroupManager.isMobInGroup(watcher, group.id()) || (currentStage = data.getStage(group.id())) != targetStageIndex - 1) continue;
            data.setStage(group.id(), targetStageIndex, maxStagesGlobal);
        }
    }
}

