/*
 * Decompiled with CFR 0.152.
 */
package com.example.firefearmod.trauma;

import com.electronwill.nightconfig.core.Config;
import com.example.firefearmod.config.ConfigHolder;
import com.example.firefearmod.manager.FearGroup;
import com.example.firefearmod.manager.IFearProfile;
import com.example.firefearmod.trauma.TraumaGroup;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraumaGroupManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FOLDER = "trauma_groups";
    private static final Map<ResourceLocation, TraumaGroup> GROUPS = new HashMap<ResourceLocation, TraumaGroup>();

    public TraumaGroupManager() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        GROUPS.clear();
        int maxStages = (Integer)ConfigHolder.MAX_TRAUMA_STAGES_PER_GROUP.get();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation fileId = entry.getKey();
            try {
                JsonObject obj = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"trauma_group");
                String groupIdStr = obj.has("group_id") ? GsonHelper.m_13906_((JsonObject)obj, (String)"group_id") : fileId.toString();
                ResourceLocation groupId = new ResourceLocation(groupIdStr);
                double defaultWitnessRadius = obj.has("default_witness_radius") ? GsonHelper.m_144784_((JsonObject)obj, (String)"default_witness_radius") : 16.0;
                List<FearGroup.MobDefinition> mobs = TraumaGroupManager.parseMobs(obj, groupId);
                List<TraumaGroup.TraumaStage> stages = TraumaGroupManager.parseStages(obj, groupId, maxStages);
                if (stages.isEmpty()) {
                    LOGGER.warn("Trauma group '{}' has no stages, skipping", (Object)groupId);
                    continue;
                }
                TraumaGroup group = new TraumaGroup(groupId, mobs, defaultWitnessRadius, stages);
                GROUPS.put(groupId, group);
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse trauma group JSON {}: {}", (Object)fileId, (Object)e.getMessage());
            }
        }
        LOGGER.info("Loaded {} trauma groups.", (Object)GROUPS.size());
    }

    private static List<FearGroup.MobDefinition> parseMobs(JsonObject root, ResourceLocation groupId) {
        ArrayList<FearGroup.MobDefinition> result = new ArrayList<FearGroup.MobDefinition>();
        if (!root.has("mobs")) {
            LOGGER.warn("Trauma group '{}' is missing 'mobs' array", (Object)groupId);
            return result;
        }
        JsonArray array = GsonHelper.m_13933_((JsonObject)root, (String)"mobs");
        for (JsonElement element : array) {
            JsonObject obj = GsonHelper.m_13918_((JsonElement)element, (String)"mob");
            String idStr = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
            ResourceLocation id = new ResourceLocation(idStr);
            String customName = obj.has("custom_name") ? GsonHelper.m_13906_((JsonObject)obj, (String)"custom_name") : null;
            CompoundTag nbt = null;
            if (obj.has("nbt")) {
                String nbtStr = GsonHelper.m_13906_((JsonObject)obj, (String)"nbt");
                try {
                    nbt = TagParser.m_129359_((String)nbtStr);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse NBT for mob definition in trauma group '{}': {}", (Object)groupId, (Object)e.getMessage());
                }
            }
            result.add(new FearGroup.MobDefinition(id, customName, nbt));
        }
        return result;
    }

    private static List<TraumaGroup.TraumaStage> parseStages(JsonObject root, ResourceLocation groupId, int maxStages) {
        ArrayList<TraumaGroup.TraumaStage> result = new ArrayList<TraumaGroup.TraumaStage>();
        if (!root.has("stages")) {
            LOGGER.warn("Trauma group '{}' is missing 'stages' array", (Object)groupId);
            return result;
        }
        JsonArray array = GsonHelper.m_13933_((JsonObject)root, (String)"stages");
        int limit = array.size();
        if (maxStages > 0 && maxStages < limit) {
            limit = maxStages;
        }
        for (int i = 0; i < limit; ++i) {
            JsonElement element = array.get(i);
            JsonObject obj = GsonHelper.m_13918_((JsonElement)element, (String)"stage");
            Double fleeSpeed = obj.has("flee_speed") ? Double.valueOf(GsonHelper.m_144784_((JsonObject)obj, (String)"flee_speed")) : null;
            Integer searchRadius = obj.has("search_radius") ? Integer.valueOf(GsonHelper.m_13927_((JsonObject)obj, (String)"search_radius")) : null;
            Double witnessRadius = obj.has("witness_radius") ? Double.valueOf(GsonHelper.m_144784_((JsonObject)obj, (String)"witness_radius")) : null;
            ArrayList<FearGroup.FearSourceDefinition> fearedBlocks = new ArrayList<FearGroup.FearSourceDefinition>();
            ArrayList<FearGroup.FearSourceDefinition> fearedItems = new ArrayList<FearGroup.FearSourceDefinition>();
            ArrayList<FearGroup.FearedEntityDefinition> fearedEntities = new ArrayList<FearGroup.FearedEntityDefinition>();
            ArrayList<TraumaGroup.TraumaRequirement> requirements = new ArrayList<TraumaGroup.TraumaRequirement>();
            TraumaGroupManager.parseFears(obj, groupId, i, fearedBlocks, fearedItems, fearedEntities);
            TraumaGroupManager.parseRequirements(obj, groupId, i, requirements);
            result.add(new TraumaGroup.TraumaStage(i, fleeSpeed, searchRadius, witnessRadius, fearedBlocks, fearedItems, fearedEntities, requirements));
        }
        if (limit < array.size()) {
            LOGGER.warn("Trauma group '{}' has {} stages but only the first {} are used due to maxTraumaStagesPerGroup", (Object)groupId, (Object)array.size(), (Object)limit);
        }
        return result;
    }

    private static void parseFears(JsonObject stageObj, ResourceLocation groupId, int stageIndex, List<FearGroup.FearSourceDefinition> fearedBlocks, List<FearGroup.FearSourceDefinition> fearedItems, List<FearGroup.FearedEntityDefinition> fearedEntities) {
        if (!stageObj.has("fears")) {
            return;
        }
        JsonArray array = GsonHelper.m_13933_((JsonObject)stageObj, (String)"fears");
        block10: for (JsonElement element : array) {
            String normalized;
            JsonObject obj = GsonHelper.m_13918_((JsonElement)element, (String)"fear");
            String type = obj.has("type") ? GsonHelper.m_13906_((JsonObject)obj, (String)"type") : "block";
            switch (normalized = type.toLowerCase(Locale.ROOT)) {
                case "block": {
                    Record def = TraumaGroupManager.parseFearSourceDefinition(obj, groupId, stageIndex, "block");
                    if (def == null) continue block10;
                    fearedBlocks.add((FearGroup.FearSourceDefinition)def);
                    break;
                }
                case "item": {
                    Record def = TraumaGroupManager.parseFearSourceDefinition(obj, groupId, stageIndex, "item");
                    if (def == null) continue block10;
                    fearedItems.add((FearGroup.FearSourceDefinition)def);
                    break;
                }
                case "entity": {
                    Record def = TraumaGroupManager.parseFearedEntityDefinition(obj, groupId, stageIndex);
                    if (def == null) continue block10;
                    fearedEntities.add((FearGroup.FearedEntityDefinition)def);
                    break;
                }
                default: {
                    LOGGER.warn("Unknown fear type '{}' in trauma group '{}' stage {}", (Object)type, (Object)groupId, (Object)stageIndex);
                }
            }
        }
    }

    @Nullable
    private static FearGroup.FearSourceDefinition parseFearSourceDefinition(JsonObject obj, ResourceLocation groupId, int stageIndex, String context) {
        ResourceLocation id;
        String rawId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
        boolean isTag = false;
        if (rawId.startsWith("#")) {
            isTag = true;
            rawId = rawId.substring(1);
        }
        try {
            id = new ResourceLocation(rawId);
        }
        catch (Exception e) {
            LOGGER.error("Invalid {} id '{}' in trauma group '{}' stage {}: {}", (Object)context, (Object)rawId, (Object)groupId, (Object)stageIndex, (Object)e.getMessage());
            return null;
        }
        String customName = obj.has("custom_name") ? GsonHelper.m_13906_((JsonObject)obj, (String)"custom_name") : null;
        boolean fearOverride = obj.has("fear_override") && GsonHelper.m_13912_((JsonObject)obj, (String)"fear_override");
        Config statesCfg = null;
        if (obj.has("states")) {
            JsonObject statesObj = GsonHelper.m_13930_((JsonObject)obj, (String)"states");
            statesCfg = Config.inMemory();
            for (Map.Entry entry : statesObj.entrySet()) {
                statesCfg.set((String)entry.getKey(), (Object)((JsonElement)entry.getValue()).getAsString());
            }
        }
        CompoundTag nbt = null;
        if (obj.has("nbt")) {
            String nbtStr = GsonHelper.m_13906_((JsonObject)obj, (String)"nbt");
            try {
                nbt = TagParser.m_129359_((String)nbtStr);
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse NBT for {} fear in trauma group '{}' stage {}: {}", (Object)context, (Object)groupId, (Object)stageIndex, (Object)e.getMessage());
            }
        }
        return new FearGroup.FearSourceDefinition(id, isTag, customName, statesCfg, nbt, fearOverride);
    }

    @Nullable
    private static FearGroup.FearedEntityDefinition parseFearedEntityDefinition(JsonObject obj, ResourceLocation groupId, int stageIndex) {
        IFearProfile.VisibilityMode mode;
        ResourceLocation id;
        String rawId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
        boolean isTag = false;
        if (rawId.startsWith("#")) {
            isTag = true;
            rawId = rawId.substring(1);
        }
        try {
            id = new ResourceLocation(rawId);
        }
        catch (Exception e) {
            LOGGER.error("Invalid entity id '{}' in trauma group '{}' stage {}: {}", (Object)rawId, (Object)groupId, (Object)stageIndex, (Object)e.getMessage());
            return null;
        }
        String customName = obj.has("custom_name") ? GsonHelper.m_13906_((JsonObject)obj, (String)"custom_name") : null;
        boolean fearOverride = obj.has("fear_override") && GsonHelper.m_13912_((JsonObject)obj, (String)"fear_override");
        CompoundTag nbt = null;
        if (obj.has("nbt")) {
            String nbtStr = GsonHelper.m_13906_((JsonObject)obj, (String)"nbt");
            try {
                nbt = TagParser.m_129359_((String)nbtStr);
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse NBT for entity fear in trauma group '{}' stage {}: {}", (Object)groupId, (Object)stageIndex, (Object)e.getMessage());
            }
        }
        String modeStr = obj.has("visibility_mode") ? GsonHelper.m_13906_((JsonObject)obj, (String)"visibility_mode") : "LOOK_BASED";
        try {
            mode = IFearProfile.VisibilityMode.valueOf(modeStr.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            mode = IFearProfile.VisibilityMode.LOOK_BASED;
        }
        FearGroup.FearSourceDefinition src = new FearGroup.FearSourceDefinition(id, isTag, customName, null, nbt, false);
        return new FearGroup.FearedEntityDefinition(src, fearOverride, mode);
    }

    private static void parseRequirements(JsonObject stageObj, ResourceLocation groupId, int stageIndex, List<TraumaGroup.TraumaRequirement> out) {
        if (!stageObj.has("requirements")) {
            return;
        }
        JsonArray array = GsonHelper.m_13933_((JsonObject)stageObj, (String)"requirements");
        block16: for (JsonElement element : array) {
            TraumaGroup.RequirementType type;
            JsonObject obj = GsonHelper.m_13918_((JsonElement)element, (String)"requirement");
            String typeStr = obj.has("type") ? GsonHelper.m_13906_((JsonObject)obj, (String)"type") : "";
            switch (typeStr.toLowerCase(Locale.ROOT)) {
                case "hurt_by_entity": {
                    type = TraumaGroup.RequirementType.HURT_BY_ENTITY;
                    break;
                }
                case "hurt_by_source": {
                    type = TraumaGroup.RequirementType.HURT_BY_SOURCE;
                    break;
                }
                case "witness_hurt_by_entity": {
                    type = TraumaGroup.RequirementType.WITNESS_HURT_BY_ENTITY;
                    break;
                }
                case "witness_hurt_by_source": {
                    type = TraumaGroup.RequirementType.WITNESS_HURT_BY_SOURCE;
                    break;
                }
                default: {
                    LOGGER.warn("Unknown requirement type '{}' in trauma group '{}' stage {}", (Object)typeStr, (Object)groupId, (Object)stageIndex);
                    continue block16;
                }
            }
            switch (type) {
                case HURT_BY_ENTITY: 
                case WITNESS_HURT_BY_ENTITY: {
                    if (!obj.has("entity")) {
                        LOGGER.warn("Requirement of type '{}' in trauma group '{}' stage {} is missing 'entity' object", (Object)typeStr, (Object)groupId, (Object)stageIndex);
                        break;
                    }
                    JsonObject entityObj = GsonHelper.m_13930_((JsonObject)obj, (String)"entity");
                    FearGroup.FearedEntityDefinition entityDef = TraumaGroupManager.parseFearedEntityDefinition(entityObj, groupId, stageIndex);
                    if (entityDef == null) break;
                    out.add(new TraumaGroup.TraumaRequirement(type, entityDef, null));
                    break;
                }
                case HURT_BY_SOURCE: 
                case WITNESS_HURT_BY_SOURCE: {
                    if (!obj.has("source")) {
                        LOGGER.warn("Requirement of type '{}' in trauma group '{}' stage {} is missing 'source' object", (Object)typeStr, (Object)groupId, (Object)stageIndex);
                        break;
                    }
                    JsonObject sourceRoot = GsonHelper.m_13930_((JsonObject)obj, (String)"source");
                    FearGroup.FearSourceDefinition sourceDef = null;
                    if (sourceRoot.has("item")) {
                        JsonObject itemObj = GsonHelper.m_13930_((JsonObject)sourceRoot, (String)"item");
                        sourceDef = TraumaGroupManager.parseFearSourceDefinition(itemObj, groupId, stageIndex, "item requirement");
                    } else if (sourceRoot.has("block")) {
                        JsonObject blockObj = GsonHelper.m_13930_((JsonObject)sourceRoot, (String)"block");
                        sourceDef = TraumaGroupManager.parseFearSourceDefinition(blockObj, groupId, stageIndex, "block requirement");
                    } else {
                        LOGGER.warn("Requirement of type '{}' in trauma group '{}' stage {} has 'source' without 'item' or 'block'", (Object)typeStr, (Object)groupId, (Object)stageIndex);
                    }
                    if (sourceDef == null) break;
                    out.add(new TraumaGroup.TraumaRequirement(type, null, sourceDef));
                }
            }
        }
    }

    public static Collection<TraumaGroup> getAllGroups() {
        return Collections.unmodifiableCollection(GROUPS.values());
    }

    public static List<TraumaGroup> getGroupsForMob(Mob mob) {
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (mobId == null) {
            return List.of();
        }
        ArrayList<TraumaGroup> result = new ArrayList<TraumaGroup>();
        for (TraumaGroup group : GROUPS.values()) {
            int bestScore = -1;
            for (FearGroup.MobDefinition def : group.mobs()) {
                int score = def.getMatchScore(mob, mobId);
                if (score <= bestScore) continue;
                bestScore = score;
            }
            if (bestScore < 0) continue;
            result.add(group);
        }
        return result;
    }

    public static boolean isMobInGroup(Mob mob, ResourceLocation groupId) {
        TraumaGroup group = GROUPS.get(groupId);
        if (group == null) {
            return false;
        }
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (mobId == null) {
            return false;
        }
        int bestScore = -1;
        for (FearGroup.MobDefinition def : group.mobs()) {
            int score = def.getMatchScore(mob, mobId);
            if (score <= bestScore) continue;
            bestScore = score;
        }
        return bestScore >= 0;
    }
}

