/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.chunkter;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.lilbrocodes.chunkter.ChunkterCommands;
import org.lilbrocodes.chunkter.ChunkterEvents;
import org.lilbrocodes.chunkter.implementation.Metrics;
import org.lilbrocodes.chunkter.util.CommandParser;
import org.lilbrocodes.chunkter.util.LoggingSender;

public final class Chunkter
extends JavaPlugin {
    public boolean defaultEnabled = false;
    public boolean enabled = false;
    public boolean running = false;
    public boolean enforceGeneration = false;
    public int maxPlayers = 1;
    private FileConfiguration config;
    private final LoggingSender commandSender = new LoggingSender((CommandSender)Bukkit.getConsoleSender());

    public void onEnable() {
        this.loadConfig();
        Metrics metrics = new Metrics((Plugin)this, 24277);
        metrics.addCustomChart(new Metrics.SimplePie("max-players", () -> String.valueOf(this.maxPlayers)));
        metrics.addCustomChart(new Metrics.SimplePie("enforce-generation", () -> this.enforceGeneration ? "True" : "False"));
        Plugin chunky = Bukkit.getPluginManager().getPlugin("Chunky");
        if (chunky == null) {
            this.getLogger().warning("Chunky not found, disabling");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        ChunkterCommands commands = new ChunkterCommands(this);
        Objects.requireNonNull(this.getCommand("chunkter")).setExecutor((CommandExecutor)commands);
        Objects.requireNonNull(this.getCommand("chunkter")).setTabCompleter((TabCompleter)commands);
        Bukkit.getPluginManager().registerEvents((Listener)new ChunkterEvents(this), (Plugin)this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            if (this.enabled) {
                if (this.running) {
                    CommandParser.resumeChunky(this.commandSender);
                } else {
                    CommandParser.pauseChunky(this.commandSender);
                }
            }
        }, 0L, 1L);
    }

    public void loadConfig() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.enforceGeneration = this.config.getBoolean("enforce-generation");
        this.maxPlayers = this.config.getInt("max-players");
        this.defaultEnabled = this.enabled = this.config.getBoolean("default-enabled");
    }

    public void reloadConfigC() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.enforceGeneration = this.config.getBoolean("enforce-generation");
        this.maxPlayers = this.config.getInt("max-players");
        this.defaultEnabled = this.config.getBoolean("default-enabled");
    }

    public void sendMessage(CommandSender sender, String message) {
        sender.sendMessage("\u00a77[\u00a76Chunkter\u00a77]\u00a7r " + message);
    }

    public void sendMessage(Player sender, String message) {
        sender.sendMessage("\u00a77[\u00a76Chunkter\u00a77]\u00a7r " + message);
    }

    public void writeConfig() throws IOException {
        this.config.save(Paths.get(this.getDataFolder().toString(), "config.yml").toString());
        this.reloadConfigC();
    }

    public void setPlayerCount(int count) throws IOException {
        this.config.set("max-players", (Object)count);
        this.writeConfig();
    }

    public void setEnforceGeneration(boolean value) throws IOException {
        this.config.set("enforce-generation", (Object)value);
        this.writeConfig();
    }

    public void setDefaultEnabled(boolean value) throws IOException {
        this.config.set("default-enabled", (Object)value);
        this.writeConfig();
    }
}

