/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.chunkter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.lilbrocodes.chunkter.Chunkter;
import org.lilbrocodes.chunkter.util.CommandParser;
import org.lilbrocodes.chunkter.util.LoggingSender;

public class ChunkterCommands
implements CommandExecutor,
TabCompleter {
    private final Chunkter plugin;

    public ChunkterCommands(Chunkter plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] args) {
        if (args.length >= 1 && args[0].equalsIgnoreCase("status")) {
            LoggingSender sender = new LoggingSender(commandSender);
            this.plugin.sendMessage(commandSender, "Misc:");
            this.plugin.sendMessage(commandSender, "    " + (Boolean.TRUE.equals(CommandParser.running(sender)) ? "Chunky is running." : "Chunky is not running."));
            this.plugin.sendMessage(commandSender, "    " + (this.plugin.running ? "Chunkter is running." : "Chunkter is not running."));
            this.plugin.sendMessage(commandSender, "    " + (this.plugin.enabled ? "Chunkter is enabled." : "Chunkter is not enabled."));
            this.plugin.sendMessage(commandSender, "Config:");
            this.plugin.sendMessage(commandSender, "    " + String.format("enforce-generation: %b", this.plugin.enforceGeneration));
            this.plugin.sendMessage(commandSender, "    " + String.format("max-players: %d", this.plugin.maxPlayers));
            this.plugin.sendMessage(commandSender, "    " + String.format("default-enabled: %b", this.plugin.defaultEnabled));
        }
        if (args.length >= 1 && CommandParser.equalsAnyLowercase(args[0], Arrays.asList("on", "off"))) {
            boolean enabled = args[0].equalsIgnoreCase("on");
            if (this.plugin.enabled != enabled) {
                this.plugin.enabled = enabled;
                this.plugin.sendMessage(commandSender, enabled ? "Enabled chunkter." : "Disabled chunkter.");
                CommandParser.tryStart(this.plugin.getServer().getOnlinePlayers().size(), this.plugin);
            } else {
                this.plugin.sendMessage(commandSender, enabled ? "Chunkter is already enabled." : "Chunkter is already disabled.");
            }
        }
        if (args.length >= 3 && args[0].equalsIgnoreCase("config")) {
            if (args[1].equalsIgnoreCase("max-players")) {
                try {
                    int playerAmount = Integer.parseInt(args[2]);
                    this.plugin.setPlayerCount(playerAmount);
                    this.plugin.sendMessage(commandSender, String.format("Set max player count to %d.", playerAmount));
                    CommandParser.tryStart(this.plugin.getServer().getOnlinePlayers().size(), this.plugin);
                }
                catch (NumberFormatException e) {
                    this.plugin.sendMessage(commandSender, "Player count not specified or not a valid integer.");
                }
                catch (IOException e) {
                    this.plugin.sendMessage(commandSender, "Failed to save config file.");
                }
            } else if (args[1].equalsIgnoreCase("enforce-generation")) {
                boolean enforceGeneration = args[2].equalsIgnoreCase("true");
                if (this.plugin.enforceGeneration == enforceGeneration) {
                    this.plugin.sendMessage(commandSender, enforceGeneration ? "Enforcing generation is already enabled." : "Enforcing generation is already disabled.");
                } else {
                    try {
                        this.plugin.setEnforceGeneration(enforceGeneration);
                        this.plugin.sendMessage(commandSender, enforceGeneration ? "Enforcing generation enabled." : "Enforcing generation disabled.");
                    }
                    catch (IOException e) {
                        this.plugin.sendMessage(commandSender, "Failed to save config file.");
                    }
                }
            } else if (args[1].equalsIgnoreCase("default-enabled")) {
                boolean defaultEnabled = args[2].equalsIgnoreCase("true");
                if (this.plugin.defaultEnabled == defaultEnabled) {
                    this.plugin.sendMessage(commandSender, defaultEnabled ? "Being enabled by default is already enabled." : "Being enabled by default is already disabled.");
                } else {
                    try {
                        this.plugin.setDefaultEnabled(defaultEnabled);
                        this.plugin.sendMessage(commandSender, defaultEnabled ? "Being enabled by default generation enabled." : "Being enabled by default generation disabled.");
                    }
                    catch (IOException e) {
                        this.plugin.sendMessage(commandSender, "Failed to save config file.");
                    }
                }
            }
        }
        if (args[0].equalsIgnoreCase("reload")) {
            this.plugin.reloadConfigC();
            this.plugin.sendMessage(commandSender, "Successfully reloaded the config.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("on", "off", "config", "status", "reload");
        }
        if (args.length == 2) {
            return Arrays.asList("max-players", "enforce-generation", "default-enabled");
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("enforce-generation")) {
            return Arrays.asList("true", "false");
        }
        return Collections.emptyList();
    }
}

