/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.chunkter;

import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.lilbrocodes.chunkter.Chunkter;
import org.lilbrocodes.chunkter.util.CommandParser;

public class ChunkterEvents
implements Listener {
    private final Chunkter plugin;

    public ChunkterEvents(Chunkter plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        List<Boolean> opCmd = CommandParser.isOpCmd(event.getMessage());
        if (opCmd.get(0).booleanValue()) {
            event.getPlayer().setOp(opCmd.get(1).booleanValue());
        }
        if (!this.plugin.enforceGeneration) {
            return;
        }
        if (CommandParser.cancelCommand(event.getMessage())) {
            event.setCancelled(true);
            this.plugin.sendMessage(event.getPlayer(), "You cannot use this command, since enforce-generation is enabled.");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.plugin.enabled) {
            return;
        }
        CommandParser.tryStart(this.plugin.getServer().getOnlinePlayers().size() + 1, this.plugin);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        if (!this.plugin.enabled) {
            return;
        }
        CommandParser.tryStart(this.plugin.getServer().getOnlinePlayers().size() - 1, this.plugin);
    }
}

