/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.block;

import com.magistuarmory.block.ModBlocks;
import com.magistuarmory.block.PaviseBlockEntity;
import com.magistuarmory.item.ModItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class PaviseBlock
extends AbstractBannerBlock {
    public static final IntegerProperty ROTATION;
    static final AABB COLLISION_AABB;
    static final Vector3d CENTER;
    static final Vector3d BOXMIN;
    static final Vector3d BOXMAX;
    public final MapCodec<PaviseBlock> codec;
    private final Supplier<BlockEntityType<PaviseBlockEntity>> entityType;
    protected String shieldId;

    public PaviseBlock(DyeColor color, BlockBehaviour.Properties prop, String shieldId, Supplier<BlockEntityType<PaviseBlockEntity>> entityType) {
        super(color, prop);
        this.shieldId = shieldId;
        this.entityType = entityType;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0)));
        this.codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(AbstractBannerBlock::getColor), (App)PaviseBlock.propertiesCodec()).apply((Applicative)instance, (arg_0, arg_1) -> PaviseBlock.lambda$new$0(shieldId, (Supplier)entityType, arg_0, arg_1)));
    }

    public BlockEntityType<PaviseBlockEntity> getEntityType() {
        return this.entityType.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION});
    }

    protected MapCodec<? extends AbstractBannerBlock> codec() {
        return this.codec;
    }

    public BlockEntity newBlockEntity(BlockPos blockpos, BlockState blockstate) {
        return new PaviseBlockEntity(this.entityType, blockpos, blockstate);
    }

    @NotNull
    public Item asItem() {
        RegistrySupplier item = ModItems.PAVISES.wood;
        return item != null ? (Item)item.get() : Items.AIR;
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)blockPlaceContext.getRotation())));
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader reader, BlockPos blockpos, BlockState blockstate) {
        BlockEntity blockEntity = reader.getBlockEntity(blockpos);
        if (blockEntity instanceof PaviseBlockEntity) {
            PaviseBlockEntity pavise = (PaviseBlockEntity)blockEntity;
            return pavise.getStack();
        }
        return ItemStack.EMPTY;
    }

    public VoxelShape getShape(BlockState blockstate, BlockGetter blockgetter, BlockPos blockpos, CollisionContext context) {
        AABB aabb = COLLISION_AABB;
        float yrot = -RotationSegment.convertToDegrees((int)((Integer)blockstate.getValue((Property)BannerBlock.ROTATION)));
        aabb = PaviseBlock.rotateAABB(aabb, Axis.YP.rotationDegrees(yrot));
        return Shapes.create((AABB)aabb);
    }

    public static AABB rotateAABB(AABB axisAlignedBB, Quaternionf quaternion) {
        Vector3d mincoords = new Vector3d(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ);
        Vector3d maxcoords = new Vector3d(axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.maxZ);
        mincoords.sub((Vector3dc)CENTER);
        maxcoords.sub((Vector3dc)CENTER);
        quaternion.transform(mincoords);
        quaternion.transform(maxcoords);
        mincoords.add((Vector3dc)CENTER).max((Vector3dc)BOXMIN);
        maxcoords.add((Vector3dc)CENTER).min((Vector3dc)BOXMAX);
        return new AABB(mincoords.x(), mincoords.y(), mincoords.z(), maxcoords.x(), maxcoords.y(), maxcoords.z());
    }

    public void playerDestroy(Level level, Player player, BlockPos blockpos, BlockState blockstate, @Nullable BlockEntity blockentity, ItemStack stack) {
        player.awardStat(Stats.BLOCK_MINED.get((Object)this));
        player.causeFoodExhaustion(0.005f);
        PaviseBlock.dropResources((BlockState)blockstate, (Level)level, (BlockPos)blockpos, (BlockEntity)blockentity, (Entity)player, (ItemStack)stack);
        if (blockentity instanceof PaviseBlockEntity) {
            PaviseBlockEntity pavise = (PaviseBlockEntity)blockentity;
            level.addFreshEntity((Entity)new ItemEntity(level, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5, pavise.getStack()));
        }
    }

    public void destroy(LevelAccessor accessor, BlockPos blockpos, BlockState blockstate) {
        if (accessor.getBlockState(blockpos.above()).getBlock() == ModBlocks.PAVISE_UPPER_COLLISION.get()) {
            accessor.destroyBlock(blockpos.above(), false);
        }
        super.destroy(accessor, blockpos, blockstate);
    }

    private static /* synthetic */ PaviseBlock lambda$new$0(String shieldId, Supplier entityType, DyeColor a, BlockBehaviour.Properties b) {
        return new PaviseBlock(a, b, shieldId, entityType);
    }

    static {
        COLLISION_AABB = new AABB(0.0, 0.0, 0.46875, 1.0, 1.0, 0.53125);
        CENTER = new Vector3d(0.5, 0.5, 0.5);
        BOXMIN = new Vector3d(0.0, 0.0, 0.0);
        BOXMAX = new Vector3d(1.0, 1.0, 1.0);
        ROTATION = BlockStateProperties.ROTATION_16;
    }
}

