/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.item.IHasModelProperty;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MedievalBowItem
extends BowItem
implements IHasModelProperty {
    private final float pullTime;
    private final float arrowSpeed;

    public MedievalBowItem(Item.Properties properties, float arrowSpeed, float pullTime) {
        super(properties.stacksTo(1));
        this.arrowSpeed = arrowSpeed;
        this.pullTime = pullTime;
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int i) {
        int j;
        float f;
        Player player;
        ItemStack itemStack2;
        if (livingEntity instanceof Player && !(itemStack2 = (player = (Player)livingEntity).getProjectile(itemStack)).isEmpty() && !((double)(f = this.getPower(j = this.getUseDuration(itemStack, livingEntity) - i)) < 0.1)) {
            List list = MedievalBowItem.draw((ItemStack)itemStack, (ItemStack)itemStack2, (LivingEntity)player);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.shoot(serverLevel, (LivingEntity)player, player.getUsedItemHand(), itemStack, list, f * this.arrowSpeed, 1.0f, f == 1.0f, null);
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    public float getPower(int p_185059_0_) {
        float f = (float)p_185059_0_ / this.pullTime;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, entity, i) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
        });
    }
}

