/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.api.item;

import com.magistuarmory.block.PaviseBlock;
import com.magistuarmory.client.render.ModRender;
import com.magistuarmory.item.ArmorDecoration;
import com.magistuarmory.item.ArmorDecorationItem;
import com.magistuarmory.item.DyeableArmorDecorationItem;
import com.magistuarmory.item.DyeableItemLike;
import com.magistuarmory.item.ItemRegistryHelper;
import com.magistuarmory.item.LanceItem;
import com.magistuarmory.item.MedievalBowItem;
import com.magistuarmory.item.MedievalCrossbowItem;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.ShieldType;
import com.magistuarmory.item.ShieldsSupply;
import com.magistuarmory.item.WeaponType;
import com.magistuarmory.item.WeaponsSupply;
import com.magistuarmory.item.armor.ArmorType;
import com.magistuarmory.item.armor.DyeableMedievalArmorItem;
import com.magistuarmory.item.armor.DyeableWearableArmorDecorationItem;
import com.magistuarmory.item.armor.KnightItem;
import com.magistuarmory.item.armor.MedievalArmorItem;
import com.magistuarmory.item.armor.WearableArmorDecorationItem;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;

public abstract class ModItemsProvider {
    public final String modId;
    public final DeferredRegister<Item> items;
    public final List<RegistrySupplier<? extends MedievalShieldItem>> shieldItems = new ArrayList<RegistrySupplier<? extends MedievalShieldItem>>();
    public final List<RegistrySupplier<? extends MedievalWeaponItem>> weaponItems = new ArrayList<RegistrySupplier<? extends MedievalWeaponItem>>();
    public final List<RegistrySupplier<? extends DyeableItemLike>> dyeableItems = new ArrayList<RegistrySupplier<? extends DyeableItemLike>>();
    public final List<RegistrySupplier<? extends MedievalArmorItem>> armorItems = new ArrayList<RegistrySupplier<? extends MedievalArmorItem>>();
    public final List<RegistrySupplier<? extends Item>> ingredientItems = new ArrayList<RegistrySupplier<? extends Item>>();
    public final List<RegistrySupplier<? extends ArmorDecoration>> armorDecorationItems = new ArrayList<RegistrySupplier<? extends ArmorDecoration>>();
    public final List<RegistrySupplier<? extends Item>> rangedWeaponItems = new ArrayList<RegistrySupplier<? extends Item>>();

    public ModItemsProvider(String modId) {
        this.modId = modId;
        this.items = DeferredRegister.create((String)modId, (ResourceKey)Registries.ITEM);
    }

    public WeaponsSupply addWeaponsSupply(BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> workshop) {
        return new WeaponsSupply(workshop);
    }

    public ShieldsSupply addShieldsSupply(BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> workshop, String shieldName) {
        return new ShieldsSupply(workshop, shieldName);
    }

    @Nullable
    public RegistrySupplier<KnightItem> addKnightItem(String id, ArmorType type, ArmorItem.Type slot, Item.Properties properties) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<KnightItem> armor = ItemRegistryHelper.registerKnightItem(this.items, id, type, slot, properties);
        this.dyeableItems.add(armor);
        this.armorItems.add(armor);
        return armor;
    }

    @Nullable
    public RegistrySupplier<MedievalArmorItem> addJoustingItem(String id, ArmorType type, ArmorItem.Type slot, Item.Properties properties) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalArmorItem> armor = ItemRegistryHelper.registerJoustingItem(this.items, id, type, slot, properties);
        this.armorItems.add(armor);
        return armor;
    }

    @Nullable
    public RegistrySupplier<MedievalArmorItem> addMedievalArmorItem(String id, ArmorType type, ArmorItem.Type slot, Item.Properties properties) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalArmorItem> armor = ItemRegistryHelper.registerMedievalArmorItem(this.items, id, type, slot, properties);
        this.armorItems.add(armor);
        return armor;
    }

    @Nullable
    public RegistrySupplier<DyeableMedievalArmorItem> addDyeableMedievalArmorItem(String id, ArmorType type, ArmorItem.Type slot, Item.Properties properties, int defaultcolor) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<DyeableMedievalArmorItem> armor = ItemRegistryHelper.registerDyeableMedievalArmorItem(this.items, id, type, slot, properties, defaultcolor);
        this.dyeableItems.add(armor);
        this.armorItems.add(armor);
        return armor;
    }

    @Nullable
    public RegistrySupplier<MedievalWeaponItem> addMedievalWeaponItem(String id, Item.Properties properties, ModItemTier material, WeaponType type) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalWeaponItem> weapon = ItemRegistryHelper.registerMedievalWeaponItem(this.items, id, properties, material, type);
        this.weaponItems.add(weapon);
        return weapon;
    }

    @Nullable
    public RegistrySupplier<MedievalWeaponItem> addLanceItem(String id, Item.Properties properties, ModItemTier material, WeaponType type) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalWeaponItem> weapon = ItemRegistryHelper.registerLanceItem(this.items, id, properties, material, type);
        this.weaponItems.add(weapon);
        return weapon;
    }

    public RegistrySupplier<Item> addIngredientItem(String id, Supplier<Item> supplier) {
        RegistrySupplier registrysupplier = this.items.register(id, supplier);
        this.ingredientItems.add((RegistrySupplier<? extends Item>)registrysupplier);
        return registrysupplier;
    }

    public RegistrySupplier<ArmorDecorationItem> addArmorDecorationItem(String id, Supplier<ArmorDecorationItem> supplier) {
        RegistrySupplier registrysupplier = this.items.register(id, supplier);
        this.armorDecorationItems.add((RegistrySupplier<? extends ArmorDecoration>)registrysupplier);
        return registrysupplier;
    }

    public RegistrySupplier<DyeableArmorDecorationItem> addDyeableArmorDecorationItem(String id, Supplier<DyeableArmorDecorationItem> supplier) {
        RegistrySupplier registrysupplier = this.items.register(id, supplier);
        this.armorDecorationItems.add((RegistrySupplier<? extends ArmorDecoration>)registrysupplier);
        this.dyeableItems.add((RegistrySupplier<? extends DyeableItemLike>)registrysupplier);
        return registrysupplier;
    }

    public RegistrySupplier<WearableArmorDecorationItem> addWearableArmorDecorationItem(String id, ArmorType material, ArmorItem.Type type, Item.Properties properties) {
        RegistrySupplier<WearableArmorDecorationItem> registrysupplier = ItemRegistryHelper.registerWearableArmorDecorationItem(this.items, id, material, type, properties);
        this.armorDecorationItems.add(registrysupplier);
        this.armorItems.add(registrysupplier);
        return registrysupplier;
    }

    public RegistrySupplier<DyeableWearableArmorDecorationItem> addDyeableWearableArmorDecorationItem(String id, ArmorType material, ArmorItem.Type type, Item.Properties properties, int defaultcolor) {
        RegistrySupplier<DyeableWearableArmorDecorationItem> registrysupplier = ItemRegistryHelper.registerDyeableWearableArmorDecorationItem(this.items, id, material, type, properties, defaultcolor);
        this.armorDecorationItems.add(registrysupplier);
        this.dyeableItems.add(registrysupplier);
        this.armorItems.add(registrysupplier);
        return registrysupplier;
    }

    @Nullable
    public RegistrySupplier<MedievalShieldItem> addMedievalShieldItem(String id, String name, Item.Properties properties, ModItemTier material, boolean paintable, boolean is3d, ShieldType type) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalShieldItem> shield = ItemRegistryHelper.registerMedievalShieldItem(this.items, id, ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), properties, material, paintable, is3d, type);
        this.shieldItems.add(shield);
        return shield;
    }

    @Nullable
    public RegistrySupplier<MedievalShieldItem> addPaviseItem(String id, String name, Item.Properties properties, ModItemTier material, boolean paintable, boolean is3d, ShieldType type, Supplier<PaviseBlock> block) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalShieldItem> shield = ItemRegistryHelper.registerPaviseItem(this.items, id, ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), properties, material, paintable, is3d, type, block);
        this.shieldItems.add(shield);
        return shield;
    }

    @Nullable
    public RegistrySupplier<Item> addMedievalBowItem(String id, int durability, float arrowSpeed, float pullTime) {
        RegistrySupplier bow = this.items.register(id, () -> new MedievalBowItem(new Item.Properties().stacksTo(1).durability(durability), arrowSpeed, pullTime));
        this.rangedWeaponItems.add((RegistrySupplier<? extends Item>)bow);
        return bow;
    }

    @Nullable
    public RegistrySupplier<Item> addMedievalCrossbowItem(String id, int durability, float arrowSpeed, int pullTime) {
        RegistrySupplier crossbow = this.items.register(id, () -> new MedievalCrossbowItem(new Item.Properties().stacksTo(1).durability(durability), arrowSpeed, pullTime));
        this.rangedWeaponItems.add((RegistrySupplier<? extends Item>)crossbow);
        return crossbow;
    }

    public static ItemStack getDecoratedStack(RegistrySupplier<? extends Item> suppler, RegistrySupplier<? extends ArmorDecorationItem> decorationsuppler) {
        if (suppler == null) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)suppler.get());
        ArmorDecorationItem decorationitem = (ArmorDecorationItem)decorationsuppler.get();
        ItemStack decorationstack = new ItemStack((ItemLike)decorationitem);
        decorationitem.decorate(stack, decorationstack);
        return stack;
    }

    public void onSetup() {
        for (RegistrySupplier<? extends MedievalWeaponItem> supplier : this.weaponItems) {
            Object object = supplier.get();
            if (!(object instanceof LanceItem)) continue;
            LanceItem lance = (LanceItem)object;
            lance.setupDropItems();
        }
    }

    public void init() {
        this.items.register();
        LifecycleEvent.SETUP.register(this::onSetup);
        if (Platform.getEnv() == Dist.CLIENT) {
            LifecycleEvent.SETUP.register(() -> ModRender.setup(this));
        }
    }
}

