/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class HitResultHelper {
    public static HitResult getMouseOver(Minecraft mc, float reach) {
        HitResult result = null;
        LocalPlayer player = mc.player;
        if (player != null) {
            result = player.pick((double)reach, 0.0f, false);
            Vec3 eyepos = player.getEyePosition();
            double d1 = result.getLocation().distanceToSqr(eyepos);
            Vec3 view = player.getViewVector(1.0f);
            Vec3 attackvec = eyepos.add(view.x * (double)reach, view.y * (double)reach, view.z * (double)reach);
            AABB expBounds = player.getBoundingBox().expandTowards(view.scale((double)reach)).inflate(1.0, 1.0, 1.0);
            EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyepos, (Vec3)attackvec, (AABB)expBounds, entity -> !entity.isSpectator() && entity.isPickable(), (double)d1);
            result = Objects.requireNonNullElseGet(entityhitresult, () -> BlockHitResult.miss((Vec3)attackvec, (Direction)Direction.getNearest((double)view.x, (double)view.y, (double)view.z), (BlockPos)new BlockPos((int)attackvec.x, (int)attackvec.y, (int)attackvec.z)));
        }
        return result;
    }
}

