/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.model.decoration;

import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.decoration.ArmorDecorationModel;
import com.magistuarmory.item.ArmorDecoration;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmorDecorationModelSet<T extends LivingEntity> {
    final Map<ModelLayerLocation, ArmorDecorationModel<T>> map = new HashMap<ModelLayerLocation, ArmorDecorationModel<T>>();

    public ArmorDecorationModelSet(List<RegistrySupplier<? extends ArmorDecoration>> decorations, EntityRendererProvider.Context context) {
        for (Supplier supplier : decorations) {
            ModelLayerLocation location = ((ArmorDecoration)supplier.get()).createModelLocation();
            this.map.putIfAbsent(location, new ArmorDecorationModel(context.bakeLayer(location)));
        }
    }

    public ArmorDecorationModel<T> get(ModelLayerLocation location) {
        return this.map.get(location);
    }

    public ArmorDecorationModel<T> get(ResourceLocation location) {
        return this.get(ModModels.createDecorationLocation(location));
    }
}

