/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.effects;

import com.magistuarmory.effects.ModEffects;
import com.magistuarmory.util.CombatHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import org.jetbrains.annotations.NotNull;

public class LacerationEffect
extends MobEffect {
    public LacerationEffect() {
        super(MobEffectCategory.HARMFUL, -10092544);
        this.addAttributeModifier(Attributes.MAX_HEALTH, ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)"laceration"), -2.0, AttributeModifier.Operation.ADD_VALUE);
    }

    @NotNull
    public String getDescriptionId() {
        return "effect.laceration";
    }

    public boolean isBeneficial() {
        return false;
    }

    public boolean applyEffectTick(LivingEntity victim, int i) {
        if (victim.getHealth() > victim.getMaxHealth()) {
            victim.setHealth(victim.getMaxHealth());
            return true;
        }
        return false;
    }

    public static void apply(DamageSource source, LivingEntity victim, float damage) {
        damage = CombatHelper.getDamageAfterAbsorb(source, victim, damage);
        if (victim instanceof Creeper) {
            return;
        }
        int amplifier = Math.min((int)damage, 2);
        int duration = (int)(damage * 50.0f);
        if (victim.hasEffect(ModEffects.LACERATION)) {
            MobEffectInstance effect = victim.getEffect(ModEffects.LACERATION);
            amplifier = Math.max(effect.getAmplifier(), amplifier);
            duration = Math.max(effect.getDuration(), duration);
            victim.removeEffect(ModEffects.LACERATION);
        }
        victim.addEffect(new MobEffectInstance(ModEffects.LACERATION, duration, amplifier, true, true, true));
    }
}

