/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.block.ModBlocks;
import com.magistuarmory.block.PaviseBlock;
import com.magistuarmory.block.PaviseBlockEntity;
import com.magistuarmory.block.PaviseUpperCollisionBlock;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.ShieldType;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaviseItem
extends MedievalShieldItem {
    private final Direction attachmentDirection = Direction.DOWN;
    private final Supplier<PaviseBlock> block;

    public PaviseItem(String id, ResourceLocation location, Item.Properties properties, ModItemTier material, boolean paintable, boolean is3d, ShieldType type, Supplier<PaviseBlock> block) {
        super(id, location, properties, material, paintable, is3d, type);
        this.block = block;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        InteractionResult interactionResult = this.place(new BlockPlaceContext(context));
        if (!interactionResult.consumesAction() && context.getItemInHand().has(DataComponents.FOOD)) {
            InteractionResult interactionResult2 = super.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
            return interactionResult2 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionResult2;
        }
        return interactionResult;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!this.getBlock().isEnabled(context.getLevel().enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext context2 = this.updatePlacementContext(context);
        if (context2 == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(context2);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(context2, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = context2.getClickedPos();
        Level level = context2.getLevel();
        Player player = context2.getPlayer();
        ItemStack stack = context2.getItemInHand();
        BlockState blockstate2 = level.getBlockState(blockpos);
        if (blockstate2.is(blockstate.getBlock())) {
            blockstate2 = this.updateBlockStateFromTag(blockpos, level, stack, blockstate2);
            BlockEntity blockentity = level.getBlockEntity(blockpos);
            if (blockentity instanceof PaviseBlockEntity) {
                PaviseBlockEntity paviseblockentity = (PaviseBlockEntity)blockentity;
                paviseblockentity.fromItem(stack);
            }
            blockstate2.getBlock().setPlacedBy(level, blockpos, blockstate2, (LivingEntity)player, stack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos, stack);
            }
        }
        SoundType sound = blockstate2.getSoundType();
        level.playSound(player, blockpos, this.getPlaceSound(blockstate2), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)blockstate2));
        if (player == null || !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected SoundEvent getPlaceSound(BlockState blockstate) {
        return blockstate.getSoundType().getPlaceSound();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    private BlockState updateBlockStateFromTag(BlockPos blockpos, Level level, ItemStack stack, BlockState blockstate) {
        BlockItemStateProperties blockItemStateProperties = (BlockItemStateProperties)stack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
        if (blockItemStateProperties.isEmpty()) {
            return blockstate;
        }
        BlockState blockstate2 = blockItemStateProperties.apply(blockstate);
        if (blockstate2 != blockstate) {
            level.setBlock(blockpos, blockstate2, 2);
        }
        return blockstate2;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState blockstate) {
        BlockPos aboveblockpos;
        Level level = context.getLevel();
        if (level.isStateAtPosition(aboveblockpos = context.getClickedPos().above(), state -> state.getBlock() != Blocks.AIR) && !level.isWaterAt(aboveblockpos)) {
            return false;
        }
        if (!context.getLevel().setBlock(context.getClickedPos(), blockstate, 11)) {
            return false;
        }
        level.setBlock(aboveblockpos, ((PaviseUpperCollisionBlock)((Object)ModBlocks.PAVISE_UPPER_COLLISION.get())).defaultBlockState(), 27);
        return true;
    }

    public String getDescriptionId() {
        return this.getBlock().getDescriptionId();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipflag) {
        super.appendHoverText(stack, tooltipContext, list, tooltipflag);
        list.add((Component)Component.translatable((String)"canbeplacedonground").withStyle(ChatFormatting.BLUE));
    }

    public PaviseBlock getBlock() {
        return this.block.get();
    }

    @NotNull
    public FeatureFlagSet requiredFeatures() {
        return this.getBlock().requiredFeatures();
    }

    protected boolean canPlace(LevelReader levelreader, BlockState blockstate, BlockPos blockpos) {
        return blockstate.canSurvive(levelreader, blockpos);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        Direction[] var6;
        BlockState blockstate2 = null;
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : var6 = context.getNearestLookingDirections()) {
            BlockState blockstate3;
            if (direction == this.attachmentDirection.getOpposite() || (blockstate3 = this.getBlock().getStateForPlacement(context)) == null || !this.canPlace((LevelReader)levelreader, blockstate3, blockpos)) continue;
            blockstate2 = blockstate3;
            break;
        }
        return blockstate2 != null && levelreader.isUnobstructed(blockstate2, blockpos, CollisionContext.empty()) ? blockstate2 : null;
    }
}

