/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.crafting;

import com.magistuarmory.component.ModDataComponents;
import com.magistuarmory.item.ArmorDecoration;
import com.magistuarmory.item.DyeableArmorDecorationItem;
import com.magistuarmory.item.MedievalBagItem;
import com.magistuarmory.item.ModItems;
import com.magistuarmory.item.crafting.neoforge.DecorationRemoveRecipeImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.NotNull;

public class DecorationRemoveRecipe
extends CustomRecipe {
    public static RecipeSerializer<DecorationRemoveRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(DecorationRemoveRecipe::new);

    public DecorationRemoveRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, Level level) {
        ItemStack stack = ItemStack.EMPTY;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack2 = container.getItem(i);
            if (stack2.isEmpty()) continue;
            if (DecorationRemoveRecipe.isDecorated(stack2)) {
                if (!stack.isEmpty()) {
                    return false;
                }
                stack = stack2;
                continue;
            }
            return false;
        }
        return !stack.isEmpty();
    }

    @NotNull
    public ItemStack assemble(CraftingInput container, @NotNull HolderLookup.Provider access) {
        ItemStack stack = ItemStack.EMPTY;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack2 = container.getItem(i);
            if (stack2.isEmpty() || !DecorationRemoveRecipe.isDecorated(stack2)) continue;
            stack = stack2;
            break;
        }
        if (!stack.isEmpty()) {
            ItemStack bagstack = new ItemStack((ItemLike)ModItems.MEDIEVAL_BAG.get());
            List<ItemStack> stacks = DecorationRemoveRecipe.takeApart(stack);
            if (stacks.isEmpty()) {
                return ItemStack.EMPTY;
            }
            MedievalBagItem.setContents(bagstack, stacks);
            return bagstack;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return DecorationRemoveRecipe.getSerializerInstance();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeSerializer<DecorationRemoveRecipe> getSerializerInstance() {
        return DecorationRemoveRecipeImpl.getSerializerInstance();
    }

    static boolean mightBeDecorated(Item item) {
        return item instanceof ArmorItem || item instanceof ShieldItem;
    }

    static boolean isDecorated(ItemStack stack) {
        CompoundTag compoundtag;
        ListTag listtag;
        if (!DecorationRemoveRecipe.mightBeDecorated(stack.getItem())) {
            return false;
        }
        CustomData decorationdata = (CustomData)stack.get((DataComponentType)ModDataComponents.ARMOR_DECORATION.get());
        if (decorationdata != null && !(listtag = (compoundtag = decorationdata.copyTag()).getList("Items", 10)).isEmpty()) {
            return true;
        }
        return stack.get(DataComponents.BANNER_PATTERNS) != null;
    }

    static List<ItemStack> takeApart(ItemStack stack) {
        CustomData decorationdata;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemStack newstack = stack.copy();
        DyeColor basecolor = (DyeColor)newstack.get(DataComponents.BASE_COLOR);
        if (basecolor != null) {
            BannerItem banner = (BannerItem)BannerBlock.byColor((DyeColor)basecolor).asItem();
            ItemStack bannerstack = new ItemStack((ItemLike)banner);
            BannerPatternLayers patterns = (BannerPatternLayers)newstack.get(DataComponents.BANNER_PATTERNS);
            if (patterns != null && !patterns.layers().isEmpty()) {
                bannerstack.set(DataComponents.BANNER_PATTERNS, (Object)patterns);
            }
            stacks.add(bannerstack);
        }
        if ((decorationdata = (CustomData)newstack.get((DataComponentType)ModDataComponents.ARMOR_DECORATION.get())) != null) {
            CompoundTag compoundtag = decorationdata.copyTag();
            ListTag listtag = compoundtag.getList("Items", 10);
            while (!listtag.isEmpty()) {
                DyeableArmorDecorationItem dyeabedecoration;
                CompoundTag tag = listtag.getCompound(listtag.size() - 1);
                String name = tag.getString("name");
                int color = tag.getInt("color");
                ArmorDecoration decoration = (ArmorDecoration)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)(name + "_decoration")));
                ItemStack decorationstack = new ItemStack((ItemLike)decoration);
                if (decoration instanceof DyeableArmorDecorationItem && (dyeabedecoration = (DyeableArmorDecorationItem)decoration).getColor(decorationstack) != color) {
                    dyeabedecoration.setColor(decorationstack, color);
                }
                listtag.remove(listtag.size() - 1);
                compoundtag.put("Items", (Tag)listtag);
                stacks.add(decorationstack);
            }
        }
        newstack.remove((DataComponentType)ModDataComponents.ARMOR_DECORATION.get());
        newstack.remove(DataComponents.BANNER_PATTERNS);
        newstack.remove(DataComponents.BASE_COLOR);
        newstack.remove(DataComponents.CUSTOM_NAME);
        stacks.add(newstack);
        return stacks;
    }
}

