/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.network;

import com.magistuarmory.item.LanceItem;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PacketLanceCollision
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketLanceCollision> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)"packet_lance_collision"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketLanceCollision> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.attackerid, (StreamCodec)ByteBufCodecs.INT, p -> p.victimid, PacketLanceCollision::new);
    public int attackerid;
    public int victimid;

    public PacketLanceCollision(Entity attacker, Entity victim) {
        this(attacker.getId(), victim.getId());
    }

    public PacketLanceCollision(int attackerid, int victimid) {
        this.attackerid = attackerid;
        this.victimid = victimid;
    }

    public static void sendToServer(Entity attacker, Entity victim) {
        NetworkManager.sendToServer((CustomPacketPayload)new PacketLanceCollision(attacker, victim));
    }

    public static void apply(PacketLanceCollision packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Entity attacker = player2.level().getEntity(packet.attackerid);
        Entity victim = player2.level().getEntity(packet.victimid);
        if (attacker == null || victim == null) {
            return;
        }
        context.queue(() -> PacketLanceCollision.execute(attacker, victim, player2));
    }

    static void execute(Entity attacker, Entity victim, ServerPlayer player) {
        Item item;
        ItemStack stack = player.getMainHandItem();
        if (attacker == player && (item = stack.getItem()) instanceof LanceItem) {
            LanceItem lance = (LanceItem)item;
            float speed = lance.getVelocityProjection((Entity)player);
            boolean dismount = victim.level().getRandom().nextDouble() > 1.0 - (double)lance.getClickedScale();
            lance.setRideSpeed(stack, speed);
            lance.setDismount(stack, dismount);
            player.attack(victim);
            player.resetAttackStrengthTicker();
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

