/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.entity.layer;

import com.magistuarmory.client.render.entity.layer.ArmorPatternLayer;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.decoration.ArmorDecorationModel;
import com.magistuarmory.client.render.model.decoration.ArmorDecorationModelSet;
import com.magistuarmory.client.render.model.decoration.SurcoatModel;
import com.magistuarmory.item.ArmorDecorationItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmorDecorationLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M>
implements ArmorPatternLayer {
    private static final String ARMOR_DIR_PREFIX = "textures/models/armor/";
    private final ArmorDecorationModel<T> coatModel;
    private final String coatDirPrefix;
    private final ResourceLocation coatTexture;
    private final ArmorDecorationModelSet<T> decorationModels;

    public ArmorDecorationLayer(ArmorDecorationModelSet<T> decorationModels, RenderLayerParent<T, M> parent, EntityRendererProvider.Context context, ResourceLocation location) {
        super(parent);
        this.decorationModels = decorationModels;
        this.coatModel = new SurcoatModel(context.m_174023_(ModModels.createDecorationLocation(location)));
        this.coatDirPrefix = this.getDirPrefix(location);
        this.coatTexture = this.getTexture(location);
    }

    public ResourceLocation getTexture(ResourceLocation location) {
        return this.getTexture(location, false);
    }

    public ResourceLocation getTexture(ResourceLocation location, boolean overlay) {
        return new ResourceLocation(location.m_135827_(), ARMOR_DIR_PREFIX + location.m_135815_() + (overlay ? "_overlay.png" : ".png"));
    }

    public String getDirPrefix(ResourceLocation location) {
        return ARMOR_DIR_PREFIX + location.m_135815_() + "/";
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int p, T entity, float f, float f2, float f3, float f4, float f5, float f6) {
        this.renderPiece(pose, buffer, entity, EquipmentSlot.CHEST, p);
        this.renderPiece(pose, buffer, entity, EquipmentSlot.LEGS, p);
        this.renderPiece(pose, buffer, entity, EquipmentSlot.FEET, p);
        this.renderPiece(pose, buffer, entity, EquipmentSlot.HEAD, p);
    }

    private void renderPiece(PoseStack pose, MultiBufferSource buffer, T entity, EquipmentSlot slot, int p) {
        ArmorItem armoritem;
        ItemStack itemstack = entity.m_6844_(slot);
        Item item = itemstack.m_41720_();
        if (item instanceof ArmorItem && (armoritem = (ArmorItem)item).m_40402_() == slot) {
            if (itemstack.m_41737_("ArmorDecoration") != null) {
                for (ArmorDecorationItem.DecorationInfo info : ArmorDecorationItem.createDecorations(ArmorDecorationItem.getDecorationTags(itemstack))) {
                    ResourceLocation location = info.location();
                    ArmorDecorationModel<T> model = this.getArmorDecorationModel(location);
                    if (model == null) continue;
                    ((HumanoidModel)this.m_117386_()).m_102872_(model);
                    if (info.dyeable()) {
                        int j = info.color();
                        float r = (float)(j >> 16 & 0xFF) / 255.0f;
                        float g = (float)(j >> 8 & 0xFF) / 255.0f;
                        float b = (float)(j & 0xFF) / 255.0f;
                        this.renderDecoration(pose, buffer, p, OverlayTexture.f_118083_, r, g, b, itemstack.m_41790_(), model.parts(), this.getTexture(location));
                        this.renderDecoration(pose, buffer, p, OverlayTexture.f_118083_, itemstack.m_41790_(), model.parts(), this.getTexture(location, true));
                        continue;
                    }
                    this.renderDecoration(pose, buffer, p, OverlayTexture.f_118083_, itemstack.m_41790_(), model.parts(), this.getTexture(location));
                }
            }
            if (armoritem.m_40402_() == EquipmentSlot.CHEST && BlockItem.m_186336_((ItemStack)itemstack) != null) {
                ((HumanoidModel)this.m_117386_()).m_102872_(this.coatModel);
                this.renderDecoration(pose, buffer, p, OverlayTexture.f_118083_, itemstack.m_41790_(), this.coatModel.parts(), this.coatTexture);
                ListTag listtag = BannerBlockEntity.m_58487_((ItemStack)itemstack);
                List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)itemstack), (ListTag)listtag);
                this.renderPatterns(pose, buffer, p, OverlayTexture.f_118083_, list, itemstack.m_41790_(), this.coatModel);
            }
        }
    }

    public ArmorDecorationModel<T> getArmorDecorationModel(ResourceLocation location) {
        return this.decorationModels.get(location);
    }

    public void renderPatterns(PoseStack pose, MultiBufferSource buffer, int p, int overlay, List<Pair<Holder<BannerPattern>, DyeColor>> list, boolean hasfoil, ArmorDecorationModel<T> model) {
        this.renderPatterns(pose, buffer, p, overlay, list, hasfoil, model.parts(), 1.0f, 1.0f, 1.0f);
    }

    public void renderDecoration(PoseStack pose, MultiBufferSource buffer, int p, int overlay, boolean hasfoil, ModelPart[] modelparts, ResourceLocation texture) {
        this.renderDecoration(pose, buffer, p, overlay, 1.0f, 1.0f, 1.0f, hasfoil, modelparts, texture);
    }

    public void renderDecoration(PoseStack pose, MultiBufferSource buffer, int p, int overlay, float r, float g, float b, boolean hasfoil, ModelPart[] modelparts, ResourceLocation texture) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110458_((ResourceLocation)texture), (boolean)false, (boolean)hasfoil);
        for (ModelPart part : modelparts) {
            part.m_104306_(pose, vertexconsumer, p, overlay, r, g, b, 1.0f);
        }
    }

    @Override
    public ResourceLocation getBaseTexture() {
        return this.coatTexture;
    }

    @Override
    public ResourceLocation getPatternTexture(ResourceLocation patternlocation) {
        return new ResourceLocation(this.coatTexture.m_135827_(), this.coatDirPrefix + patternlocation.m_135815_() + ".png");
    }
}

