/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.google.common.collect.Lists;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.item.ArmorDecoration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ArmorDecorationItem
extends Item
implements ArmorDecoration {
    ResourceLocation location;
    ArmorItem.Type armorType;

    public ArmorDecorationItem(ResourceLocation location, Item.Properties properties, ArmorItem.Type armorType) {
        super(properties);
        this.location = location;
        this.armorType = armorType;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    @Override
    public ArmorItem.Type getArmorType() {
        return this.armorType;
    }

    public static List<DecorationInfo> createDecorations(@Nullable ListTag listtag) {
        ArrayList list = Lists.newArrayList();
        if (listtag != null) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag tag = listtag.m_128728_(i);
                String name = tag.m_128461_("name");
                boolean dyeable = tag.m_128471_("dyeable");
                int j = tag.m_128451_("color");
                list.add(new DecorationInfo(name, dyeable, j));
            }
        }
        return list;
    }

    @Override
    public CompoundTag getCompoundTag(ItemStack stack) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128359_("name", this.location.toString());
        compoundnbt.m_128379_("dyeable", false);
        compoundnbt.m_128405_("color", 1);
        return compoundnbt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableForDecoration(ItemStack stack) {
        if (ArmorDecorationItem.getDecorationTags(stack).size() >= 8) return false;
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) return false;
        ArmorItem armor = (ArmorItem)item;
        if (this.getArmorType() != armor.m_266204_()) return false;
        return true;
    }

    public static ListTag getDecorationTags(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("ArmorDecoration");
        if (compoundtag == null) {
            return new ListTag();
        }
        return compoundtag.m_128437_("Items", 10);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ModelLayerLocation createModelLocation() {
        return ModModels.createDecorationLocation(this.location);
    }

    public record DecorationInfo(String name, boolean dyeable, int color) {
        public ResourceLocation location() {
            ResourceLocation loc = new ResourceLocation(this.name);
            return new ResourceLocation(!loc.m_135827_().equals("minecraft") ? loc.m_135827_() : "magistuarmory", loc.m_135815_());
        }
    }
}

