/*
 * Decompiled with CFR 0.152.
 */
package dev.nitron.wayfinder.content.cca;

import dev.nitron.wayfinder.init.ModComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class SignalPlacementsComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1937 world;
    private final List<SignalData> signalPositions = new ArrayList<SignalData>();

    public SignalPlacementsComponent(class_1937 world) {
        this.world = world;
    }

    public void sync() {
        ModComponents.SIGNAL_PLACEMENTS.sync((Object)this.world);
    }

    public static SignalPlacementsComponent get(class_1937 world) {
        return (SignalPlacementsComponent)ModComponents.SIGNAL_PLACEMENTS.get((Object)world);
    }

    public void tick() {
    }

    public void readData(class_11368 readView) {
        this.signalPositions.clear();
        class_11368.class_11370 list = readView.method_71438("Signals");
        for (class_11368 element : list) {
            class_2338 pos = new class_2338(element.method_71424("x", 0), element.method_71424("y", 0), element.method_71424("z", 0));
            String name = element.method_71428("name", "");
            class_2382 color = new class_2382(element.method_71424("red", 0), element.method_71424("green", 0), element.method_71424("blue", 0));
            int type = element.method_71424("type", 0);
            int freq = element.method_71424("freq", 3);
            UUID ownerUUID = UUID.fromString(element.method_71428("ownerUUID", ""));
            boolean powered = element.method_71433("powered", false);
            this.signalPositions.add(new SignalData(pos, name, color, freq, ownerUUID, powered, type));
        }
    }

    public void writeData(class_11372 writeView) {
        class_11372.class_11374 list = writeView.method_71476("Signals");
        for (SignalData data : this.signalPositions) {
            class_11372 element = list.method_71480();
            element.method_71465("x", data.pos.method_10263());
            element.method_71465("y", data.pos.method_10264());
            element.method_71465("z", data.pos.method_10260());
            element.method_71469("name", data.name);
            element.method_71465("red", data.color.method_10263());
            element.method_71465("green", data.color.method_10264());
            element.method_71465("blue", data.color.method_10260());
            element.method_71465("type", data.type);
            element.method_71465("freq", data.frequency);
            element.method_71469("ownerUUID", data.owner.toString());
            element.method_71472("powered", data.isPowered);
        }
    }

    public void updateSignal(class_2338 pos, String name, class_2382 color, int type, UUID ownerUuid, boolean powered, int freq) {
        for (SignalData s : this.signalPositions) {
            if (!s.pos.equals((Object)pos)) continue;
            s.name = name;
            s.color = color;
            s.type = type;
            s.owner = ownerUuid;
            s.isPowered = powered;
            s.frequency = freq;
            this.sync();
            return;
        }
        this.signalPositions.add(new SignalData(pos, name, color, freq, ownerUuid, powered, type));
        this.sync();
    }

    public void addSignal(SignalData data) {
        this.signalPositions.add(data);
        this.sync();
    }

    public void removeSignal(class_2338 pos) {
        this.signalPositions.removeIf(signalData -> signalData.pos.equals((Object)pos));
        this.sync();
    }

    public void clear() {
        this.signalPositions.clear();
        this.sync();
    }

    public List<SignalData> getSignalPositions() {
        return this.signalPositions;
    }

    public static class SignalData {
        public class_2338 pos;
        public String name;
        public class_2382 color;
        public int frequency;
        public UUID owner;
        public boolean isPowered;
        public int type;

        public SignalData(class_2338 pos, String name, class_2382 color, int frequency, UUID ownerUUID, boolean isPowered, int type) {
            this.pos = pos;
            this.name = name;
            this.color = color;
            this.type = type;
            this.owner = ownerUUID;
            this.isPowered = isPowered;
            this.frequency = frequency;
        }
    }
}

