/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.authlibproxyforserver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;

public class ProxyConfig {
    public boolean enabled = false;
    public ProxyType type = ProxyType.HTTP;
    public String host = "127.0.0.1";
    public short port = (short)7897;

    public ProxyConfig validate() throws InvalidProxyConfigException {
        if (!this.enabled) {
            return this;
        }
        try {
            InetAddress.getAllByName(this.host);
        }
        catch (UnknownHostException e) {
            throw new InvalidProxyConfigException(InvalidReason.HOST, this.host, e);
        }
        if (this.port < 0) {
            throw new InvalidProxyConfigException(InvalidReason.PORT, this.port);
        }
        return this;
    }

    public Proxy createProxy() throws InvalidProxyConfigException {
        this.validate();
        if (this.enabled) {
            return new DynamicProxy(this);
        }
        return Proxy.NO_PROXY;
    }

    public static enum ProxyType {
        HTTP(Proxy.Type.HTTP),
        SOCKS(Proxy.Type.SOCKS);

        public final Proxy.Type real;

        private ProxyType(Proxy.Type real) {
            this.real = real;
        }
    }

    public static class InvalidProxyConfigException
    extends Exception {
        public final InvalidReason reason;
        public final Object value;

        public InvalidProxyConfigException(InvalidReason reason, Object value) {
            this.reason = reason;
            this.value = value;
        }

        public InvalidProxyConfigException(InvalidReason reason, Object value, Throwable cause) {
            super(cause);
            this.reason = reason;
            this.value = value;
        }

        @Override
        public String getMessage() {
            return this.reason.message + ": " + String.valueOf(this.value);
        }
    }

    public static enum InvalidReason {
        TYPE("Invalid proxy type"),
        HOST("Unknown proxy host"),
        PORT("Invalid proxy port");

        public final String message;

        private InvalidReason(String message) {
            this.message = message;
        }
    }

    private static class DynamicProxy
    extends Proxy {
        private final ProxyConfig config;

        public DynamicProxy(ProxyConfig config) {
            super(config.type.real, new InetSocketAddress(config.host, (int)config.port));
            this.config = config;
        }

        @Override
        public Proxy.Type type() {
            return this.config.type.real;
        }

        @Override
        public InetSocketAddress address() {
            return new InetSocketAddress(this.config.host, (int)this.config.port);
        }
    }
}

