/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.authlibproxyforserver;

import com.ayakacraft.authlibproxyforserver.ProxyConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AuthlibProxyForServer {
    private static final Path configPath = Paths.get("./config/authlib.proxy.json", new String[0]).toAbsolutePath();
    public static final Logger LOGGER = LogManager.getLogger((String)"AuthlibProxyForServer");
    public static final ProxyConfig config;
    public static Proxy proxy;
    public static Gson GSON;

    public static void saveConfig(ProxyConfig config) throws IOException {
        AuthlibProxyForServer.writeString(configPath, GSON.toJson((Object)config));
    }

    public static String readString(Path path) throws IOException {
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(Files.readAllBytes(path))).toString();
    }

    public static void writeString(Path path, String str) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            path.getParent().toFile().mkdirs();
            Files.createFile(path, new FileAttribute[0]);
        }
        Files.write(path, str.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        ProxyConfig c = new ProxyConfig();
        if (Files.isRegularFile(configPath, new LinkOption[0])) {
            try {
                String str = AuthlibProxyForServer.readString(configPath);
                c = (ProxyConfig)GSON.fromJson(str, ProxyConfig.class);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to read config file for authproxy", e);
            }
        }
        try {
            AuthlibProxyForServer.saveConfig(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        config = c;
    }
}

