/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.authlibproxyforserver.commands;

import com.ayakacraft.authlibproxyforserver.AuthlibProxyForServer;
import com.ayakacraft.authlibproxyforserver.ProxyConfig;
import com.ayakacraft.authlibproxyforserver.mixin.YggdrasilAuthenticationServiceAccessor;
import com.ayakacraft.authlibproxyforserver.utils.NetworkUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.Environment;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public final class AuthProxyCommand {
    private static final int TCPING_TIMES = 5;

    private static int display(CommandContext<class_2168> context) {
        AuthProxyCommand.sendFeedback((class_2168)context.getSource(), AuthProxyCommand.proxyText(), false);
        return 1;
    }

    private static int enable(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (AuthlibProxyForServer.config.enabled) {
            AuthProxyCommand.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Proxy already enabled"), false);
            return 1;
        }
        AuthlibProxyForServer.config.enabled = true;
        if (AuthProxyCommand.saveConfig(source)) {
            return 0;
        }
        AuthProxyCommand.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Proxy enabled, restart the server to apply"), true);
        return 1;
    }

    private static int disable(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!AuthlibProxyForServer.config.enabled) {
            AuthProxyCommand.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Proxy already disabled"), false);
            return 1;
        }
        AuthlibProxyForServer.config.enabled = false;
        if (AuthProxyCommand.saveConfig(source)) {
            return 0;
        }
        AuthProxyCommand.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Proxy disabled, restart the server to apply"), true);
        return 1;
    }

    private static int port(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        int port = IntegerArgumentType.getInteger(context, (String)"port");
        AuthlibProxyForServer.config.port = (short)port;
        if (AuthProxyCommand.saveConfig(source)) {
            return 0;
        }
        AuthProxyCommand.sendFeedback(source, (class_2561)class_2561.method_43470((String)("Proxy port set to " + port)), true);
        AuthProxyCommand.sendFeedback(source, AuthProxyCommand.proxyText(), true);
        return 1;
    }

    private static int host(CommandContext<class_2168> context) {
        String host;
        class_2168 source = (class_2168)context.getSource();
        AuthlibProxyForServer.config.host = host = StringArgumentType.getString(context, (String)"host");
        if (AuthProxyCommand.saveConfig(source)) {
            return 0;
        }
        AuthProxyCommand.sendFeedback(source, (class_2561)class_2561.method_43470((String)("Proxy host set to " + host)), true);
        AuthProxyCommand.sendFeedback(source, AuthProxyCommand.proxyText(), true);
        return 1;
    }

    private static int type(CommandContext<class_2168> context, String type) {
        class_2168 source = (class_2168)context.getSource();
        AuthlibProxyForServer.config.type = ProxyConfig.ProxyType.valueOf(type);
        if (AuthProxyCommand.saveConfig(source)) {
            return 0;
        }
        AuthProxyCommand.sendFeedback(source, (class_2561)class_2561.method_43470((String)("Proxy type set to " + type)), true);
        AuthProxyCommand.sendFeedback(source, AuthProxyCommand.proxyText(), true);
        return 1;
    }

    private static int ping(CommandContext<class_2168> context) {
        HashSet hosts = Sets.newHashSet();
        Environment env = YggdrasilAuthenticationServiceAccessor.determineEnvironment();
        hosts.add(env.sessionHost());
        hosts.add(env.servicesHost());
        new TcpingThread(hosts, (class_2168)context.getSource()).start();
        return 1;
    }

    private static boolean saveConfig(class_2168 source) {
        try {
            AuthlibProxyForServer.saveConfig(AuthlibProxyForServer.config.validate());
        }
        catch (IOException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Error saving config"));
            AuthlibProxyForServer.LOGGER.error("Error saving config", (Throwable)e);
            return true;
        }
        catch (ProxyConfig.InvalidProxyConfigException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            AuthlibProxyForServer.LOGGER.error((Object)e);
            return true;
        }
        return false;
    }

    private static class_2561 li(String str) {
        return class_2561.method_43470((String)str);
    }

    private static class_2561 proxyText() {
        return class_2561.method_43470((String)("Proxy for authlib: " + AuthlibProxyForServer.proxy.toString()));
    }

    private static void sendFeedback(class_2168 source, class_2561 txt, boolean broadcastToOps) {
        source.method_9226(() -> txt, broadcastToOps);
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"authproxy").requires(source -> source.method_9259(source.method_9211().method_3798()))).executes(AuthProxyCommand::display)).then(class_2170.method_9247((String)"enable").executes(AuthProxyCommand::enable))).then(class_2170.method_9247((String)"disable").executes(AuthProxyCommand::disable))).then(class_2170.method_9247((String)"port").then(class_2170.method_9244((String)"port", (ArgumentType)IntegerArgumentType.integer((int)0, (int)65535)).executes(AuthProxyCommand::port)))).then(class_2170.method_9247((String)"host").then(class_2170.method_9244((String)"host", (ArgumentType)StringArgumentType.greedyString()).executes(AuthProxyCommand::host)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"type").then(class_2170.method_9247((String)"http").executes(it -> AuthProxyCommand.type((CommandContext<class_2168>)it, "HTTP")))).then(class_2170.method_9247((String)"socks").executes(it -> AuthProxyCommand.type((CommandContext<class_2168>)it, "SOCKS"))))).then(class_2170.method_9247((String)"ping").executes(AuthProxyCommand::ping)));
    }

    private static class TcpingThread
    extends Thread {
        private final Set<String> hosts;
        private final class_2168 source;
        private final Map<String, Pair<Long, Integer>> results;
        private long startTimeMillis;

        private static class_2561 packetLossStatusText(int packetsReceived) {
            double packetLoss = 1.0 - (double)packetsReceived / 5.0;
            class_124 colour = packetLoss > 0.8 ? class_124.field_1061 : (packetLoss > 0.2 ? class_124.field_1054 : class_124.field_1060);
            return class_2561.method_43470((String)String.format("%d packets transmitted, %d packets received, ", 5, packetsReceived)).method_10852((class_2561)class_2561.method_43470((String)String.format("%.1f%%", packetLoss * 100.0)).method_27692(colour)).method_10852((class_2561)class_2561.method_43470((String)" packet loss"));
        }

        private static class_2561 averagePingText(long ping) {
            class_124 colour = ping > 1000L ? class_124.field_1076 : (ping >= 800L ? class_124.field_1061 : (ping >= 300L ? class_124.field_1054 : class_124.field_1060));
            return class_2561.method_43470((String)"Average ping: ").method_10852((class_2561)class_2561.method_43470((String)(ping + "ms")).method_27692(colour));
        }

        public TcpingThread(Set<String> hosts, class_2168 source) {
            super("TCPing Thread");
            this.hosts = hosts;
            this.source = source;
            this.results = Maps.newHashMap();
        }

        private synchronized void saveResult(String host, Pair<Long, Integer> res) {
            this.results.put(host, res);
            if (this.results.size() >= this.hosts.size()) {
                this.results.forEach(this::sendResult);
                AuthProxyCommand.sendFeedback(this.source, (class_2561)class_2561.method_43470((String)("Ping finished after " + (System.currentTimeMillis() - this.startTimeMillis) + "ms")), false);
            }
        }

        private void sendResult(String h, Pair<Long, Integer> r) {
            AuthProxyCommand.sendFeedback(this.source, (class_2561)class_2561.method_43470((String)String.format("Ping for '%s':", h)), false);
            AuthProxyCommand.sendFeedback(this.source, TcpingThread.packetLossStatusText((Integer)r.getSecond()), false);
            if ((Integer)r.getSecond() > 0) {
                AuthProxyCommand.sendFeedback(this.source, TcpingThread.averagePingText((Long)r.getFirst() / (long)((Integer)r.getSecond()).intValue()), false);
            }
        }

        @Override
        public void run() {
            AuthProxyCommand.sendFeedback(this.source, (class_2561)class_2561.method_43470((String)"Ping started"), false);
            this.startTimeMillis = System.currentTimeMillis();
            this.hosts.forEach(host -> new Thread(() -> this.saveResult((String)host, NetworkUtils.tcpingMultiple(URI.create(host), AuthlibProxyForServer.proxy, 5))).start());
        }
    }
}

