/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.createsa_tank_fix.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;

public class CSACapacityConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static int SMALL_CAP = 800;
    public static int MEDIUM_CAP = 1600;
    public static int LARGE_CAP = 3200;

    public static void init() {
        Path path = Path.of("config/create-stuff-additions.toml", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.warn("[CreateSATankFix] Could not find 'config/create-stuff-additions.toml'. Using default tank capacities (800, 1600, 3200).");
            return;
        }
        try (FileConfig config = FileConfig.of((Path)path);){
            config.load();
            SMALL_CAP = config.getOptional("Fuel/Water Capacity.smallTankCapacity").orElse(Double.valueOf(SMALL_CAP)).intValue();
            MEDIUM_CAP = config.getOptional("Fuel/Water Capacity.mediumTankCapacity").orElse(Double.valueOf(MEDIUM_CAP)).intValue();
            LARGE_CAP = config.getOptional("Fuel/Water Capacity.largeTankCapacity").orElse(Double.valueOf(LARGE_CAP)).intValue();
            LOGGER.info("[CreateSATankFix] Loaded Create SA tank capacities from config: S={}, M={}, L={}", new Object[]{SMALL_CAP, MEDIUM_CAP, LARGE_CAP});
        }
        catch (Exception e) {
            LOGGER.error("[CreateSATankFix] Failed to read 'config/create-stuff-additions.toml'. Using default capacities.", (Throwable)e);
        }
    }
}

