/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.createsa_tank_fix.capability;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.swzo.createsa_tank_fix.CreateSATankFix;
import net.swzo.createsa_tank_fix.capability.TankCapability;
import net.swzo.createsa_tank_fix.config.CSACapacityConfig;

public class ModCapabilities {
    private static void registerTank(RegisterCapabilitiesEvent event, String id, int capacity, Fluid validFluid) {
        ResourceLocation itemRL = ResourceLocation.parse((String)("create_sa:" + id));
        if (BuiltInRegistries.ITEM.containsKey(itemRL)) {
            Item tankItem = (Item)BuiltInRegistries.ITEM.get(itemRL);
            event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new TankCapability((ItemStack)stack, (Void)context, capacity, validFluid), new ItemLike[]{tankItem});
            CreateSATankFix.LOGGER.info("[CreateSATankFix] Successfully registered hacked tank capability for: " + String.valueOf(itemRL));
        } else {
            CreateSATankFix.LOGGER.warn("[CreateSATankFix] Could not find item '" + String.valueOf(itemRL) + "'! Capability will not be registered.");
        }
    }

    public static void register(RegisterCapabilitiesEvent event) {
        ModCapabilities.registerTank(event, "small_filling_tank", CSACapacityConfig.SMALL_CAP, (Fluid)Fluids.WATER);
        ModCapabilities.registerTank(event, "medium_filling_tank", CSACapacityConfig.MEDIUM_CAP, (Fluid)Fluids.WATER);
        ModCapabilities.registerTank(event, "large_filling_tank", CSACapacityConfig.LARGE_CAP, (Fluid)Fluids.WATER);
        ModCapabilities.registerTank(event, "small_fueling_tank", CSACapacityConfig.SMALL_CAP, (Fluid)Fluids.LAVA);
        ModCapabilities.registerTank(event, "medium_fueling_tank", CSACapacityConfig.MEDIUM_CAP, (Fluid)Fluids.LAVA);
        ModCapabilities.registerTank(event, "large_fueling_tank", CSACapacityConfig.LARGE_CAP, (Fluid)Fluids.LAVA);
    }
}

