/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.createsa_tank_fix.capability;

import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class TankCapability
implements IFluidHandlerItem {
    public static final String TAG_STOCK = "tagStock";
    public static final int FLUID_TO_POINTS_RATIO = 10;
    public static final int MAX_POINTS_PER_OPERATION = 100;
    protected final ItemStack container;
    private final int capacity;
    private final Fluid validFluid;

    public TankCapability(@NotNull ItemStack container, Void context, int capacity, Fluid validFluid) {
        this.container = container;
        this.capacity = Math.max(1, capacity);
        this.validFluid = validFluid;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    private double getStock() {
        return ((CustomData)this.container.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble(TAG_STOCK);
    }

    private void setStock(double stock) {
        this.container.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, cd -> {
            CompoundTag newTag = cd.copyTag();
            newTag.putDouble(TAG_STOCK, stock);
            return CustomData.of((CompoundTag)newTag);
        });
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return stack.getFluid() == this.validFluid;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return 0;
        }
        double currentStock = this.getStock();
        int pointsSpaceLeft = this.capacity - (int)currentStock;
        if (pointsSpaceLeft <= 0) {
            return 0;
        }
        int pointsFromOfferedFluid = resource.getAmount() / 10;
        int pointsToAdd = Math.min(pointsSpaceLeft, pointsFromOfferedFluid);
        if ((pointsToAdd = Math.min(pointsToAdd, 100)) <= 0) {
            return 0;
        }
        int fluidActuallyConsumed = pointsToAdd * 10;
        if (action.execute()) {
            this.setStock(currentStock + (double)pointsToAdd);
        }
        return fluidActuallyConsumed;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

