/*
 * Decompiled with CFR 0.152.
 */
package com.thanatoros.customizedtridents.mixin;

import com.thanatoros.customizedtridents.config.ModConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={TridentItem.class})
public abstract class CustomizedTridentsMixin
extends Item {
    public CustomizedTridentsMixin(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Overwrite
    public boolean releaseUsing(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
        if (p_43396_ instanceof Player) {
            int Riptide_durability_damage;
            Player player = (Player)p_43396_;
            int i = this.getUseDuration(p_43394_, p_43396_) - p_43397_;
            int use_duration = ModConfigs.USE_DURATION;
            if (use_duration > 30) {
                use_duration = 30;
            }
            if (use_duration < 0) {
                use_duration = 0;
            }
            if ((Riptide_durability_damage = ModConfigs.RIPTIDE_DURABILITY_DAMAGE) > 300) {
                Riptide_durability_damage = 300;
            }
            if (Riptide_durability_damage < 0) {
                Riptide_durability_damage = 0;
            }
            if (i < use_duration) {
                return false;
            }
            float f = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)p_43394_, (LivingEntity)player);
            boolean condition = false;
            switch (ModConfigs.RIPTIDE_MODE) {
                case 0: {
                    condition = player.isInWaterOrRain();
                    break;
                }
                case 1: {
                    condition = player.isInWaterOrRain() || player.isInLava();
                    break;
                }
                case 2: {
                    condition = true;
                    break;
                }
                case 3: {
                    condition = player.isInWater();
                    break;
                }
                case 4: {
                    condition = this.isBeingRainedOn(player);
                    break;
                }
                case 5: {
                    condition = player.isInLava();
                    break;
                }
                case 6: {
                    condition = player.isInWater() || player.isInLava();
                    break;
                }
                case 7: {
                    condition = this.isBeingRainedOn(player) || player.isInLava();
                    break;
                }
            }
            if (f > 0.0f && !condition) {
                return false;
            }
            if (p_43394_.nextDamageWillBreak()) {
                return false;
            }
            Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)p_43394_, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (p_43395_ instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)p_43395_;
                p_43394_.hurtWithoutBreaking(Riptide_durability_damage, player);
                if (f == 0.0f) {
                    ThrownTrident throwntrident = (ThrownTrident)Projectile.spawnProjectileFromRotation(ThrownTrident::new, (ServerLevel)serverlevel, (ItemStack)p_43394_, (LivingEntity)player, (float)0.0f, (float)2.5f, (float)1.0f);
                    if (player.hasInfiniteMaterials()) {
                        throwntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else {
                        player.getInventory().removeItem(p_43394_);
                    }
                    p_43395_.playSound(null, (Entity)throwntrident, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    return true;
                }
            }
            if (f > 0.0f) {
                float power;
                float f7 = player.getYRot();
                float f1 = player.getXRot();
                float f2 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f1 * ((float)Math.PI / 180)));
                float f3 = -Mth.sin((float)(f1 * ((float)Math.PI / 180)));
                float f4 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f1 * ((float)Math.PI / 180)));
                float f5 = Mth.sqrt((float)(f2 * f2 + f3 * f3 + f4 * f4));
                int power_int = ModConfigs.RIPTIDE_POWER;
                if (power_int < 0) {
                    power_int = 0;
                }
                if (power_int > 100) {
                    power_int = 100;
                }
                f = power = (float)power_int;
                player.push((double)(f2 *= f / f5), (double)(f3 *= f / f5), (double)(f4 *= f / f5));
                player.startAutoSpinAttack(20, 8.0f, p_43394_);
                if (player.onGround()) {
                    float f6 = 1.1999999f;
                    player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                }
                p_43395_.playSound(null, (Entity)player, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        return false;
    }

    @Overwrite
    public InteractionResult use(Level p_43405_, Player p_43406_, InteractionHand p_43407_) {
        ItemStack itemstack = p_43406_.getItemInHand(p_43407_);
        boolean condition = false;
        switch (ModConfigs.RIPTIDE_MODE) {
            case 0: {
                condition = !p_43406_.isInWaterOrRain();
                break;
            }
            case 1: {
                condition = !p_43406_.isInWaterOrRain() && !p_43406_.isInLava();
                break;
            }
            case 2: {
                condition = false;
                break;
            }
            case 3: {
                condition = !p_43406_.isInWater();
                break;
            }
            case 4: {
                condition = !this.isBeingRainedOn(p_43406_);
                break;
            }
            case 5: {
                condition = !p_43406_.isInLava();
                break;
            }
            case 6: {
                condition = !p_43406_.isInWater() && !p_43406_.isInLava();
                break;
            }
            case 7: {
                condition = !this.isBeingRainedOn(p_43406_) && !p_43406_.isInLava();
                break;
            }
        }
        if (itemstack.nextDamageWillBreak()) {
            return InteractionResult.FAIL;
        }
        if (EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)itemstack, (LivingEntity)p_43406_) > 0.0f && condition) {
            return InteractionResult.FAIL;
        }
        p_43406_.startUsingItem(p_43407_);
        return InteractionResult.CONSUME;
    }

    private boolean isBeingRainedOn(Player player) {
        BlockPos blockpos = player.blockPosition();
        return player.level().isRainingAt(blockpos) || player.level().isRainingAt(BlockPos.containing((double)blockpos.getX(), (double)player.getBoundingBox().maxY, (double)blockpos.getZ()));
    }

    private static boolean isTooDamagedToUse(ItemStack p_344861_) {
        return p_344861_.getDamageValue() >= p_344861_.getMaxDamage() - 1;
    }
}

