/*
 * Decompiled with CFR 0.152.
 */
package mix.cinematiczoom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class ZoomConfig {
    public static final ZoomConfig INSTANCE = new ZoomConfig();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("cinematiczoom.json");
    public float barsPercent = 15.0f;
    public int smoothMs = 240;
    public boolean mouseWheelEnabled = true;
    public boolean hideHudDuringZoom = true;
    public boolean enableCinematicCamera = true;
    public float baseZoomMultiplier = 0.33f;
    public float minZoomMultiplier = 0.1f;
    public float maxZoomMultiplier = 1.0f;
    public float wheelStep = 0.05f;

    public void load() {
        if (Files.exists(PATH, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(PATH);){
                ZoomConfig loaded = (ZoomConfig)GSON.fromJson((Reader)r, ZoomConfig.class);
                if (loaded != null) {
                    this.copyFrom(loaded);
                }
            }
            catch (Exception exception) {}
        } else {
            this.save();
        }
        this.clamp();
    }

    public void save() {
        try {
            Files.createDirectories(PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(PATH, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)w);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void copyFrom(ZoomConfig o) {
        this.barsPercent = o.barsPercent;
        this.smoothMs = o.smoothMs;
        this.mouseWheelEnabled = o.mouseWheelEnabled;
        this.baseZoomMultiplier = o.baseZoomMultiplier;
        this.minZoomMultiplier = o.minZoomMultiplier;
        this.maxZoomMultiplier = o.maxZoomMultiplier;
        this.wheelStep = o.wheelStep;
        this.hideHudDuringZoom = o.hideHudDuringZoom;
        this.enableCinematicCamera = o.enableCinematicCamera;
    }

    public void clamp() {
        if (this.barsPercent < 0.0f) {
            this.barsPercent = 0.0f;
        }
        if (this.barsPercent > 50.0f) {
            this.barsPercent = 50.0f;
        }
        if (this.smoothMs < 0) {
            this.smoothMs = 0;
        }
        if (this.minZoomMultiplier < 0.05f) {
            this.minZoomMultiplier = 0.05f;
        }
        if (this.maxZoomMultiplier > 1.0f) {
            this.maxZoomMultiplier = 1.0f;
        }
        if (this.minZoomMultiplier > this.maxZoomMultiplier) {
            this.minZoomMultiplier = this.maxZoomMultiplier;
        }
        if (this.baseZoomMultiplier < this.minZoomMultiplier) {
            this.baseZoomMultiplier = this.minZoomMultiplier;
        }
        if (this.baseZoomMultiplier > this.maxZoomMultiplier) {
            this.baseZoomMultiplier = this.maxZoomMultiplier;
        }
        if (this.wheelStep <= 0.0f) {
            this.wheelStep = 0.01f;
        }
        if (this.wheelStep > 0.25f) {
            this.wheelStep = 0.25f;
        }
    }
}

