/*
 * Decompiled with CFR 0.152.
 */
package mix.cinematiczoom;

import mix.cinematiczoom.ZoomConfig;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ZoomManager {
    private static boolean zoomHeld = false;
    private static float currentZoomMul = 1.0f;
    private static float targetZoomMul = 1.0f;
    private static float holdZoomMul = ZoomConfig.INSTANCE.baseZoomMultiplier;
    private static float currentBarsPct = 0.0f;
    private static float targetBarsPct = 0.0f;
    private static long lastNs = 0L;
    private static Boolean prevHudHidden = null;
    private static Boolean prevSmoothCamera = null;

    public static void tick(class_310 client, class_304 key) {
        boolean ending;
        boolean inScreen = client.field_1755 != null;
        boolean wantZoom = key.method_1434() && !inScreen;
        boolean starting = wantZoom && !zoomHeld;
        boolean bl = ending = !wantZoom && zoomHeld;
        if (starting) {
            holdZoomMul = ZoomManager.clamp(ZoomConfig.INSTANCE.baseZoomMultiplier, ZoomConfig.INSTANCE.minZoomMultiplier, ZoomConfig.INSTANCE.maxZoomMultiplier);
            if (ZoomConfig.INSTANCE.hideHudDuringZoom) {
                prevHudHidden = client.field_1690.field_1842;
                client.field_1690.field_1842 = true;
            }
            if (ZoomConfig.INSTANCE.enableCinematicCamera) {
                prevSmoothCamera = client.field_1690.field_1914;
                client.field_1690.field_1914 = true;
            }
        }
        if (ending) {
            if (prevHudHidden != null) {
                client.field_1690.field_1842 = prevHudHidden;
                prevHudHidden = null;
            }
            if (prevSmoothCamera != null) {
                client.field_1690.field_1914 = prevSmoothCamera;
                prevSmoothCamera = null;
            }
        }
        targetZoomMul = (zoomHeld = wantZoom) ? holdZoomMul : 1.0f;
        targetBarsPct = zoomHeld ? ZoomConfig.INSTANCE.barsPercent : 0.0f;
    }

    public static void frameUpdate() {
        int smooth = ZoomConfig.INSTANCE.smoothMs;
        long now = System.nanoTime();
        if (lastNs == 0L) {
            lastNs = now;
            return;
        }
        double dtMs = (double)(now - lastNs) / 1000000.0;
        lastNs = now;
        if (dtMs > 50.0) {
            dtMs = 50.0;
        }
        if (smooth <= 0) {
            currentZoomMul = targetZoomMul;
            currentBarsPct = targetBarsPct;
            return;
        }
        double tau = (double)smooth / 2.302585092994046;
        double alpha = 1.0 - Math.exp(-dtMs / tau);
        currentZoomMul = (float)ZoomManager.lerp(currentZoomMul, targetZoomMul, alpha);
        currentBarsPct = (float)ZoomManager.lerp(currentBarsPct, targetBarsPct, alpha);
        if (Math.abs(currentZoomMul - targetZoomMul) < 1.0E-4f) {
            currentZoomMul = targetZoomMul;
        }
        if (Math.abs(currentBarsPct - targetBarsPct) < 0.001f) {
            currentBarsPct = targetBarsPct;
        }
    }

    public static boolean isZoomHeld() {
        return zoomHeld;
    }

    public static double getCurrentFovMul() {
        return currentZoomMul;
    }

    public static boolean onWheel(double vertical) {
        if (!zoomHeld || !ZoomConfig.INSTANCE.mouseWheelEnabled) {
            return false;
        }
        if (vertical == 0.0) {
            return false;
        }
        float step = ZoomConfig.INSTANCE.wheelStep;
        holdZoomMul = vertical > 0.0 ? (holdZoomMul -= step) : (holdZoomMul += step);
        holdZoomMul = ZoomManager.clamp(holdZoomMul, ZoomConfig.INSTANCE.minZoomMultiplier, ZoomConfig.INSTANCE.maxZoomMultiplier);
        return true;
    }

    public static void renderBars(class_332 ctx) {
        if (currentBarsPct <= 1.0E-4f) {
            return;
        }
        int sw = ctx.method_51421();
        int sh = ctx.method_51443();
        int h = Math.round((float)sh * (currentBarsPct / 100.0f));
        if (h <= 0) {
            return;
        }
        int color = -16777216;
        ctx.method_25294(0, 0, sw, h, color);
        ctx.method_25294(0, sh - h, sw, sh, color);
    }

    private static double lerp(double a, double b, double t) {
        if (t <= 0.0) {
            return a;
        }
        if (t >= 1.0) {
            return b;
        }
        return a + (b - a) * t;
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(max, v));
    }
}

