/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.api;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AIClient {
    private static final String OLLAMA_BASE_URL = "http://localhost:11434";
    private final HttpClient httpClient = HttpClient.newHttpClient();

    public CompletableFuture<String> sendChatRequest(String model, String message) {
        String requestBody = String.format("{\"model\": \"%s\", \"messages\": [{\"role\": \"user\", \"content\": \"%s\"}], \"stream\": false}", model, this.escapeJson(message));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://localhost:11434/api/chat")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        return this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() == 200) {
                return this.extractContentFromResponse((String)response.body());
            }
            throw new RuntimeException("API request failed: " + response.statusCode() + " - " + (String)response.body());
        });
    }

    private String extractContentFromResponse(String jsonResponse) {
        try {
            int contentIndex = jsonResponse.indexOf("\"content\":\"");
            if (contentIndex == -1) {
                return "Unable to parse AI response";
            }
            int endIndex = jsonResponse.indexOf("\"", contentIndex += 11);
            return jsonResponse.substring(contentIndex, endIndex).replace("\\n", "\n");
        }
        catch (Exception e) {
            return "Error parsing response";
        }
    }

    private String escapeJson(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public CompletableFuture<Boolean> checkServerStatus() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://localhost:11434/api/tags")).GET().build();
        return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> response.statusCode() == 200)).exceptionally(ex -> false);
    }
}

