/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery;

import com.mojang.brigadier.CommandDispatcher;
import dev.sterner.witchery.content.block.altar.AltarBlockEntity;
import dev.sterner.witchery.content.block.brazier.BrazierBlockEntity;
import dev.sterner.witchery.content.block.coffin.CoffinBlock;
import dev.sterner.witchery.content.block.mushroom_log.MushroomLogBlock;
import dev.sterner.witchery.content.block.phylactery.PhylacteryBlockEntity;
import dev.sterner.witchery.content.block.ritual.RitualChalkBlock;
import dev.sterner.witchery.content.block.sacrificial_circle.SacrificialBlockEntity;
import dev.sterner.witchery.content.block.soul_cage.SoulCageBlockEntity;
import dev.sterner.witchery.content.entity.CovenWitchEntity;
import dev.sterner.witchery.content.item.CaneSwordItem;
import dev.sterner.witchery.content.item.TarotDeckItem;
import dev.sterner.witchery.content.item.WineGlassItem;
import dev.sterner.witchery.content.item.brew.BrewOfSleepingItem;
import dev.sterner.witchery.content.item.curios.BitingBeltItem;
import dev.sterner.witchery.content.worldgen.WitcheryWorldgenKeys;
import dev.sterner.witchery.core.api.event.ChainEvent;
import dev.sterner.witchery.core.api.event.SleepingEvent;
import dev.sterner.witchery.core.api.schedule.TickTaskScheduler;
import dev.sterner.witchery.core.data.AltarAugmentReloadListener;
import dev.sterner.witchery.core.data.BloodPoolReloadListener;
import dev.sterner.witchery.core.data.ErosionReloadListener;
import dev.sterner.witchery.core.data.FetishEffectReloadListener;
import dev.sterner.witchery.core.data.InfiniteCenserReloadListener;
import dev.sterner.witchery.core.data.NaturePowerReloadListener;
import dev.sterner.witchery.core.data.PotionDataReloadListener;
import dev.sterner.witchery.core.registry.WitcheryCommands;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryLootInjects;
import dev.sterner.witchery.core.registry.WitcherySpecialPotionEffects;
import dev.sterner.witchery.core.registry.WitcheryStructureInjects;
import dev.sterner.witchery.core.registry.WitcheryTarotEffects;
import dev.sterner.witchery.core.registry.WitcheryVillagers;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.TransformationPlayerAttachment;
import dev.sterner.witchery.features.affliction.event.AfflictionEventHandler;
import dev.sterner.witchery.features.affliction.event.AfflictionHandler;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.affliction.lich.LichdomSpecificEventHandler;
import dev.sterner.witchery.features.affliction.vampire.VampireChildrenHuntHandler;
import dev.sterner.witchery.features.affliction.vampire.VampireSpecificEventHandler;
import dev.sterner.witchery.features.affliction.werewolf.WerewolfSpecificEventHandler;
import dev.sterner.witchery.features.bark_belt.BarkBeltHandler;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.features.coven.CovenDialogue;
import dev.sterner.witchery.features.coven.CovenPlayerAttachment;
import dev.sterner.witchery.features.curse.CurseHandler;
import dev.sterner.witchery.features.curse.CurseOfFragility;
import dev.sterner.witchery.features.curse.CursePlayerAttachment;
import dev.sterner.witchery.features.death.DeathEquipmentEventHandler;
import dev.sterner.witchery.features.death.DeathPlayerAttachment;
import dev.sterner.witchery.features.ent.EntSpawningHandler;
import dev.sterner.witchery.features.familiar.FamiliarHandler;
import dev.sterner.witchery.features.hags_ring.VeinMiningTracker;
import dev.sterner.witchery.features.hunter.HunterArmorDefenseHandler;
import dev.sterner.witchery.features.infusion.InfernalInfusionHandler;
import dev.sterner.witchery.features.infusion.InfusionHandler;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.LightInfusionHandler;
import dev.sterner.witchery.features.infusion.OtherwhereInfusionHandler;
import dev.sterner.witchery.features.lifeblood.LifebloodHandler;
import dev.sterner.witchery.features.lifeblood.LifebloodPlayerAttachment;
import dev.sterner.witchery.features.misc.BindingRitualAttachment;
import dev.sterner.witchery.features.misc.DeathQueueLevelAttachment;
import dev.sterner.witchery.features.misc.DreamWeaverHandler;
import dev.sterner.witchery.features.misc.EquipmentHandler;
import dev.sterner.witchery.features.misc.HudPlayerAttachment;
import dev.sterner.witchery.features.misc.InventoryLockPlayerAttachment;
import dev.sterner.witchery.features.misc.LecternHandler;
import dev.sterner.witchery.features.misc.PotionHandler;
import dev.sterner.witchery.features.misc.TeleportQueueHandler;
import dev.sterner.witchery.features.misc.UnderWaterBreathPlayerAttachment;
import dev.sterner.witchery.features.mutandis.MutandisHandler;
import dev.sterner.witchery.features.necromancy.NecroHandler;
import dev.sterner.witchery.features.nightmare.NightmareHandler;
import dev.sterner.witchery.features.petrification.PetrifiedEntityAttachment;
import dev.sterner.witchery.features.poppet.PoppetHandler;
import dev.sterner.witchery.features.poppet.VoodooPoppetLivingEntityAttachment;
import dev.sterner.witchery.features.possession.PossessedDataAttachment;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import dev.sterner.witchery.features.ritual.BindSpectralCreaturesRitual;
import dev.sterner.witchery.features.spirit_world.ManifestationHandler;
import dev.sterner.witchery.features.spirit_world.ManifestationPlayerAttachment;
import dev.sterner.witchery.features.tarot.TarotEffect;
import dev.sterner.witchery.features.tarot.TarotPlayerAttachment;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0018H\u0007J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020'H\u0007J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002J \u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00103\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u000204H\u0003J\u0010\u00105\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u000206H\u0003J\u0010\u00107\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u000208H\u0007J\u0010\u00109\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020:H\u0007J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020<H\u0007J\u0010\u0010=\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020>H\u0007J\u0010\u0010?\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020@H\u0007J\u0010\u0010A\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020BH\u0007J\u0010\u0010C\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020!H\u0007J\u0010\u0010D\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020EH\u0007J\u0010\u0010F\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020GH\u0007J\u0010\u0010H\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020IH\u0007J\u0010\u0010J\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020KH\u0007J\u0010\u0010L\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020MH\u0007J\u0010\u0010N\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020OH\u0007J\u0010\u0010P\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020'H\u0007J\u0010\u0010Q\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020RH\u0007J\u0010\u0010S\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020TH\u0007J\u0010\u0010U\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020VH\u0007J\u0010\u0010W\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020XH\u0007J\u0010\u0010Y\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020ZH\u0007J\u0010\u0010[\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\\H\u0007J\u0010\u0010]\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020^H\u0007J\u0010\u0010_\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020`H\u0007J\u0018\u0010a\u001a\u00020\u00052\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u000201H\u0002\u00a8\u0006e"}, d2={"Ldev/sterner/witchery/WitcheryNeoForgeEvents;", "", "<init>", "()V", "onPotionEffectApplied", "", "event", "Lnet/neoforged/neoforge/event/entity/living/MobEffectEvent$Added;", "addFortuneTellerTrades", "Lnet/neoforged/neoforge/event/village/VillagerTradesEvent;", "onServerStarting", "Lnet/neoforged/neoforge/event/server/ServerStartingEvent;", "onServerTick", "Lnet/neoforged/neoforge/event/tick/ServerTickEvent$Pre;", "onLivingDeath", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "onLivingBreathe", "Lnet/neoforged/neoforge/event/entity/living/LivingBreatheEvent;", "onLivingTick", "Lnet/neoforged/neoforge/event/tick/EntityTickEvent$Post;", "onLivingTick2", "onItemUsedFinish", "Lnet/neoforged/neoforge/event/entity/living/LivingEntityUseItemEvent$Finish;", "onLivingHurt", "Lnet/neoforged/neoforge/event/entity/living/LivingIncomingDamageEvent;", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Post;", "onAddReloadListener", "Lnet/neoforged/neoforge/event/AddReloadListenerEvent;", "onPlayerTick", "Lnet/neoforged/neoforge/event/tick/PlayerTickEvent$Post;", "onEquipmentChange", "Lnet/neoforged/neoforge/event/entity/living/LivingEquipmentChangeEvent;", "onPlayerTeleportDim", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerChangedDimensionEvent;", "onPlayerRespawn", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerRespawnEvent;", "onPlayerClone", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$Clone;", "onPlayerLoggedIn", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "syncAfflictionData", "player", "Lnet/minecraft/server/level/ServerPlayer;", "syncVampireBloodData", "clonePlayerData", "original", "Lnet/minecraft/world/entity/player/Player;", "clone", "wasDeath", "", "syncAllPlayerData", "finalizeMobSpawn", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "onLivingConversion", "Lnet/neoforged/neoforge/event/entity/living/LivingConversionEvent$Post;", "onInteractEntity", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$EntityInteract;", "onRightClickItem", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickItem;", "onRightClickBlock", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickBlock;", "onLeftClickBlock", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$LeftClickBlock;", "onBlockBreak", "Lnet/neoforged/neoforge/event/level/BlockEvent$BreakEvent;", "onPlayerLogout", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerLoggedOutEvent;", "onPlayerChangedDimension", "onBlockPlace", "Lnet/neoforged/neoforge/event/level/BlockEvent$EntityPlaceEvent;", "onServerStarted", "Lnet/neoforged/neoforge/event/server/ServerStartedEvent;", "onLootTableLoad", "Lnet/neoforged/neoforge/event/LootTableLoadEvent;", "registerEvents", "Lnet/neoforged/neoforge/event/RegisterCommandsEvent;", "onAttack", "Lnet/neoforged/neoforge/event/entity/player/AttackEntityEvent;", "onJoin", "Lnet/neoforged/neoforge/event/entity/EntityJoinLevelEvent;", "onEntityJoinLevel", "onSleep", "Ldev/sterner/witchery/core/api/event/SleepingEvent$Stop;", "onLevelTick", "Lnet/neoforged/neoforge/event/tick/LevelTickEvent$Pre;", "onServerStop", "Lnet/neoforged/neoforge/event/server/ServerStoppingEvent;", "onLightningStruck", "Lnet/neoforged/neoforge/event/entity/EntityStruckByLightningEvent;", "onChain", "Ldev/sterner/witchery/core/api/event/ChainEvent$Discard;", "canPlayerSleepEvent", "Lnet/neoforged/neoforge/event/entity/player/CanPlayerSleepEvent;", "canContinueSleepingEvent", "Lnet/neoforged/neoforge/event/entity/player/CanContinueSleepingEvent;", "sleepFinishedTimeEvent", "Lnet/neoforged/neoforge/event/level/SleepFinishedTimeEvent;", "triggerTarotEffectsForAllPlayers", "level", "Lnet/minecraft/server/level/ServerLevel;", "isNightfall", "witchery"})
@SourceDebugExtension(value={"SMAP\nWitcheryNeoForgeEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitcheryNeoForgeEvents.kt\ndev/sterner/witchery/WitcheryNeoForgeEvents\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,725:1\n69#2,15:726\n1761#3,3:741\n*S KotlinDebug\n*F\n+ 1 WitcheryNeoForgeEvents.kt\ndev/sterner/witchery/WitcheryNeoForgeEvents\n*L\n430#1:726,15\n687#1:741,3\n*E\n"})
public final class WitcheryNeoForgeEvents {
    @NotNull
    public static final WitcheryNeoForgeEvents INSTANCE = new WitcheryNeoForgeEvents();

    private WitcheryNeoForgeEvents() {
    }

    @SubscribeEvent
    public final void onPotionEffectApplied(@NotNull MobEffectEvent.Added event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        HunterArmorDefenseHandler.INSTANCE.onPotionEffectApplied(event);
    }

    @SubscribeEvent
    public final void addFortuneTellerTrades(@NotNull VillagerTradesEvent event) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!Intrinsics.areEqual((Object)event.getType(), (Object)WitcheryVillagers.INSTANCE.getFORTUNE_TELLER_PROFESSION().get())) break block12;
            Int2ObjectMap villagerTraders = event.getTrades();
            List list = (List)villagerTraders.get(1);
            if (list != null) {
                list.add(new VillagerTrades.ItemsForEmeralds((Item)WitcheryItems.INSTANCE.getGYPSUM().get(), 2, 8, 16, 2));
            }
            List list2 = (List)villagerTraders.get(1);
            if (list2 != null) {
                list2.add(new VillagerTrades.EmeraldForItems((ItemLike)WitcheryItems.INSTANCE.getQUARTZ_SPHERE().get(), 1, 16, 2));
            }
            List list3 = (List)villagerTraders.get(1);
            if (list3 != null) {
                list3.add(new VillagerTrades.ItemsForEmeralds(Items.CANDLE, 1, 4, 16, 1));
            }
            List list4 = (List)villagerTraders.get(2);
            if (list4 != null) {
                list4.add(new VillagerTrades.ItemsForEmeralds((Item)WitcheryItems.INSTANCE.getBONE_NEEDLE().get(), 4, 1, 10, 5));
            }
            List list5 = (List)villagerTraders.get(2);
            if (list5 != null) {
                list5.add(new VillagerTrades.EmeraldForItems((ItemLike)Items.AMETHYST_SHARD, 4, 12, 10));
            }
            List list6 = (List)villagerTraders.get(3);
            if (list6 != null) {
                list6.add(new VillagerTrades.ItemsForEmeralds((Item)WitcheryItems.INSTANCE.getDREAM_WEAVER().get(), 8, 1, 8, 10));
            }
            List list7 = (List)villagerTraders.get(3);
            if (list7 != null) {
                list7.add(new VillagerTrades.ItemsForEmeralds((Item)WitcheryItems.INSTANCE.getGOLDEN_THREAD().get(), 6, 2, 8, 10));
            }
            List list8 = (List)villagerTraders.get(3);
            if (list8 != null) {
                list8.add(new VillagerTrades.EmeraldForItems((ItemLike)Items.LAPIS_LAZULI, 8, 12, 20));
            }
            List list9 = (List)villagerTraders.get(4);
            if (list9 != null) {
                list9.add(new VillagerTrades.ItemsForEmeralds((Item)WitcheryItems.INSTANCE.getHAPPENSTANCE_OIL().get(), 10, 1, 5, 15));
            }
            List list10 = (List)villagerTraders.get(4);
            if (list10 != null) {
                list10.add(new VillagerTrades.ItemsForEmeralds((Item)WitcheryItems.INSTANCE.getATTUNED_STONE().get(), 12, 1, 5, 15));
            }
            List list11 = (List)villagerTraders.get(4);
            if (list11 != null) {
                list11.add(new VillagerTrades.ItemsForEmeralds(Items.ECHO_SHARD, 16, 1, 3, 20));
            }
            List list12 = (List)villagerTraders.get(5);
            if (list12 != null) {
                list12.add(WitcheryNeoForgeEvents::addFortuneTellerTrades$lambda$0);
            }
        }
    }

    @SubscribeEvent
    public final void onServerStarting(@NotNull ServerStartingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NaturePowerReloadListener.INSTANCE.addPending();
    }

    @SubscribeEvent
    public final void onServerTick(@NotNull ServerTickEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        TickTaskScheduler.INSTANCE.tick(minecraftServer);
        MinecraftServer minecraftServer2 = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer2, (String)"getServer(...)");
        EntSpawningHandler.INSTANCE.serverTick(minecraftServer2);
        MinecraftServer minecraftServer3 = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer3, (String)"getServer(...)");
        ManifestationHandler.INSTANCE.tick(minecraftServer3);
        MinecraftServer minecraftServer4 = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer4, (String)"getServer(...)");
        TeleportQueueHandler.INSTANCE.processQueue(minecraftServer4);
        VampireChildrenHuntHandler.INSTANCE.tickHuntAllLevels(event.getServer());
        MinecraftServer minecraftServer5 = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer5, (String)"getServer(...)");
        WitcherySpecialPotionEffects.INSTANCE.serverTick(minecraftServer5);
    }

    @SubscribeEvent
    public final void onLivingDeath(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        VampireSpecificEventHandler.resetNightCount(livingEntity);
        LivingEntity livingEntity2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity2, (String)"getEntity(...)");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        VampireSpecificEventHandler.onKillEntity(livingEntity2, damageSource);
        PoppetHandler.INSTANCE.onLivingDeath(event, event.getEntity(), event.getSource());
        NecroHandler.INSTANCE.onDeath(event.getEntity(), event.getSource());
        FamiliarHandler.INSTANCE.familiarDeath(event.getEntity(), event.getSource());
        WerewolfSpecificEventHandler.INSTANCE.killEntity(event.getEntity(), event.getSource());
        LivingEntity livingEntity3 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity3, (String)"getEntity(...)");
        DamageSource damageSource2 = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource2, (String)"getSource(...)");
        LichdomSpecificEventHandler.onDeath(event, livingEntity3, damageSource2);
        LivingEntity livingEntity4 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity4, (String)"getEntity(...)");
        DamageSource damageSource3 = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource3, (String)"getSource(...)");
        LichdomSpecificEventHandler.onKillEntity(livingEntity4, damageSource3);
        CaneSwordItem.Companion.harvestBlood(event.getEntity(), event.getSource());
        if (event.getEntity() instanceof ServerPlayer) {
            LivingEntity livingEntity5 = event.getEntity();
            Intrinsics.checkNotNull((Object)livingEntity5, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            AfflictionPlayerAttachment.Data afflictionData = AfflictionPlayerAttachment.getData((Player)livingEntity5);
            if (afflictionData.isVagrant()) {
                LivingEntity livingEntity6 = event.getEntity();
                Intrinsics.checkNotNull((Object)livingEntity6, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                ServerPlayer player = (ServerPlayer)livingEntity6;
                player.setHealth(player.getMaxHealth());
                LichdomSpecificEventHandler.INSTANCE.justSoulForm(player);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public final void onLivingBreathe(@NotNull LivingBreatheEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        VoodooPoppetLivingEntityAttachment.Data data2 = VoodooPoppetLivingEntityAttachment.getPoppetData(entity);
        if (data2.isUnderWater()) {
            event.setCanBreathe(false);
        }
    }

    @SubscribeEvent
    public final void onLivingTick(@NotNull EntityTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        VoodooPoppetLivingEntityAttachment.Data prevData = VoodooPoppetLivingEntityAttachment.getPoppetData((LivingEntity)entity);
        if (prevData.getUnderWaterTicks() > 0) {
            int newTicks = prevData.getUnderWaterTicks() - 1;
            VoodooPoppetLivingEntityAttachment.setPoppetData((LivingEntity)entity, new VoodooPoppetLivingEntityAttachment.Data(true, newTicks));
        } else if (prevData.isUnderWater()) {
            VoodooPoppetLivingEntityAttachment.setPoppetData((LivingEntity)entity, new VoodooPoppetLivingEntityAttachment.Data(false, 0));
        }
        BloodPoolHandler.INSTANCE.tickBloodRegen((LivingEntity)entity);
        NecroHandler.INSTANCE.tickLiving((LivingEntity)entity);
        if (entity instanceof Player) {
            TarotPlayerAttachment.INSTANCE.serverTick((Player)entity);
        }
        BindingRitualAttachment.INSTANCE.tick((LivingEntity)entity);
    }

    @SubscribeEvent
    public final void onLivingTick2(@NotNull EntityTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (entity instanceof Player) {
            PossessionComponentAttachment.INSTANCE.get((Player)entity).serverTick();
        }
    }

    @SubscribeEvent
    public final void onItemUsedFinish(@NotNull LivingEntityUseItemEvent.Finish event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PossessionComponentAttachment.PossessionComponent.Companion.cure(event);
    }

    @SubscribeEvent
    public final void onLivingHurt(@NotNull LivingIncomingDamageEvent event) {
        boolean isWere;
        PetrifiedEntityAttachment.Data data2;
        float damage;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getSource();
        float originalDamage = damage = event.getAmount();
        Entity attacker = damageSource.getEntity();
        if (entity.isDeadOrDying() || entity instanceof Player && (((Player)entity).isSpectator() || ((Player)entity).getAbilities().invulnerable)) {
            return;
        }
        if (!(Math.abs(event.getAmount()) <= Float.MAX_VALUE)) {
            return;
        }
        if (event.getAmount() >= 1.7014117E38f) {
            return;
        }
        EquipmentHandler.INSTANCE.babaYagaHit(event, entity, damageSource, damage);
        if (entity != null && (data2 = PetrifiedEntityAttachment.INSTANCE.getData(entity)).isPetrified()) {
            if (attacker instanceof LivingEntity) {
                ItemStack weapon = ((LivingEntity)attacker).getMainHandItem();
                if (!weapon.is(ItemTags.PICKAXES)) {
                    event.setAmount(0.0f);
                    return;
                }
                event.setAmount(damage /= (float)2);
                return;
            }
            event.setAmount(0.0f);
            return;
        }
        if (entity instanceof Player && ManifestationPlayerAttachment.getData((Player)entity).getManifestationTimer() > 0) {
            event.setAmount(0.0f);
            return;
        }
        if (damageSource.getEntity() instanceof Player) {
            Entity entity2 = damageSource.getEntity();
            Intrinsics.checkNotNull((Object)entity2, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player attacker2 = (Player)entity2;
            AfflictionPlayerAttachment.Data wereData = AfflictionPlayerAttachment.getData(attacker2);
            if (wereData.getWerewolfLevel() > 0 && (TransformationHandler.isWolf(attacker2) || TransformationHandler.isWerewolf(attacker2))) {
                Intrinsics.checkNotNull((Object)entity);
                damage = WerewolfSpecificEventHandler.INSTANCE.modifyWerewolfDamage(attacker2, entity, damage);
            }
        }
        if (damage > 0.0f && entity instanceof Player) {
            damage = CurseOfFragility.Companion.modifyDamage((Player)entity, damage);
        }
        boolean isVamp = entity instanceof Player && AfflictionPlayerAttachment.getData((Player)entity).getVampireLevel() > 0;
        boolean isWereMan = entity instanceof Player && AfflictionPlayerAttachment.getData((Player)entity).isWolfManForm();
        boolean bl = isWere = entity instanceof Player && AfflictionPlayerAttachment.getData((Player)entity).isWolfForm();
        if (!(isVamp || isWere || isWereMan)) {
            Intrinsics.checkNotNull((Object)damageSource);
            float barkMitigated = BarkBeltHandler.INSTANCE.hurt(entity, damageSource, damage);
            damage = RangesKt.coerceAtMost((float)barkMitigated, (float)damage);
            if (damage > 0.0f && entity instanceof Player) {
                damage = PoppetHandler.INSTANCE.onLivingHurt(entity, damageSource, damage);
            }
        } else if (isVamp) {
            if (damage > 0.0f) {
                Intrinsics.checkNotNull((Object)damageSource);
                damage = AfflictionHandler.INSTANCE.handleHurt(entity, damageSource, damage);
            }
        } else if (isWereMan) {
            if (damage > 0.0f) {
                Intrinsics.checkNotNull((Object)damageSource);
                damage = WerewolfSpecificEventHandler.INSTANCE.handleHurtWolfman(damageSource, damage);
            }
        } else if (isWere && damage > 0.0f) {
            Intrinsics.checkNotNull((Object)damageSource);
            damage = WerewolfSpecificEventHandler.INSTANCE.handleHurtWolf(damageSource, damage);
        }
        if (damage > 0.0f) {
            Intrinsics.checkNotNull((Object)entity);
            Intrinsics.checkNotNull((Object)damageSource);
            damage = PotionHandler.INSTANCE.handleHurt(entity, damageSource, damage);
        }
        if (damage > 0.0f && entity instanceof Player && damageSource.is(DamageTypes.MAGIC)) {
            damage *= 1.0f - HunterArmorDefenseHandler.INSTANCE.getProtectionMultiplier((Player)entity) * 0.25f;
        }
        if (damage > 0.0f && entity instanceof Player) {
            Player player = (Player)entity;
            Intrinsics.checkNotNull((Object)damageSource);
            damage = LifebloodHandler.INSTANCE.handleDamage(player, damageSource, damage);
        }
        if (Float.isInfinite(damage)) {
            event.setAmount(originalDamage);
        } else {
            event.setAmount(damage);
        }
    }

    @SubscribeEvent
    public final void onLivingHurt(@NotNull LivingDamageEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CurseHandler.INSTANCE.onHurt(event.getEntity(), event.getSource(), event.getOriginalDamage());
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        PotionHandler.INSTANCE.poisonWeaponAttack(livingEntity, event.getSource(), event.getOriginalDamage());
        BitingBeltItem.Companion.usePotion(event.getEntity(), event.getSource(), event.getOriginalDamage());
    }

    @SubscribeEvent
    public final void onAddReloadListener(@NotNull AddReloadListenerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.addListener((PreparableReloadListener)BloodPoolReloadListener.INSTANCE.getLOADER());
        event.addListener((PreparableReloadListener)ErosionReloadListener.INSTANCE.getLOADER());
        event.addListener((PreparableReloadListener)FetishEffectReloadListener.INSTANCE.getLOADER());
        event.addListener((PreparableReloadListener)InfiniteCenserReloadListener.INSTANCE.getLOADER());
        event.addListener((PreparableReloadListener)NaturePowerReloadListener.INSTANCE.getLOADER());
        event.addListener((PreparableReloadListener)PotionDataReloadListener.INSTANCE.getLOADER());
        event.addListener((PreparableReloadListener)AltarAugmentReloadListener.INSTANCE.getLOADER());
    }

    @SubscribeEvent
    public final void onPlayerTick(@NotNull PlayerTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VampireSpecificEventHandler.tick(event.getEntity());
        AfflictionEventHandler.tick(event.getEntity());
        CurseHandler.INSTANCE.tickCurse(event.getEntity());
        BarkBeltHandler.INSTANCE.tick(event.getEntity());
        BloodPoolHandler.INSTANCE.tick(event.getEntity());
        NightmareHandler.INSTANCE.tick(event.getEntity());
        InfernalInfusionHandler.INSTANCE.tick(event.getEntity());
        LightInfusionHandler.INSTANCE.tick(event.getEntity());
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        WerewolfSpecificEventHandler.tick(player);
        OtherwhereInfusionHandler.INSTANCE.tick(event.getEntity());
        Player player2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getEntity(...)");
        TransformationHandler.INSTANCE.tickBat(player2);
        Player player3 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getEntity(...)");
        TransformationHandler.INSTANCE.tickWolf(player3);
        LichdomSpecificEventHandler.tick(event.getEntity());
        Player player4 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player4, (String)"getEntity(...)");
        UnderWaterBreathPlayerAttachment.INSTANCE.tick(player4);
        Player player5 = event.getEntity();
        if (!player5.level().isClientSide) {
            Intrinsics.checkNotNull((Object)player5);
            LifebloodHandler.INSTANCE.tick(player5);
        }
        if (player5 instanceof ServerPlayer) {
            VeinMiningTracker.INSTANCE.tick((ServerPlayer)player5);
        }
        DeathEquipmentEventHandler.INSTANCE.onPlayerTick(event);
    }

    @SubscribeEvent
    public final void onEquipmentChange(@NotNull LivingEquipmentChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DeathEquipmentEventHandler.INSTANCE.onEquipmentChange(event);
    }

    @SubscribeEvent
    public final void onPlayerTeleportDim(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player2 = serverPlayer;
        player2.server.execute(() -> WitcheryNeoForgeEvents.onPlayerTeleportDim$lambda$0(player2));
    }

    @SubscribeEvent
    public final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player2 = serverPlayer;
        LichdomSpecificEventHandler.INSTANCE.resetDeathTeleport(player2);
        InventoryLockPlayerAttachment.INSTANCE.sync(player2);
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player2;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$onPlayerRespawn_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$onPlayerRespawn_u24lambda_u240.withVagrant(false);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
    }

    @SubscribeEvent
    public final void onPlayerClone(@NotNull PlayerEvent.Clone event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Player player = event.getOriginal();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getOriginal(...)");
            Player player2 = event.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getEntity(...)");
            this.clonePlayerData(player, player2, event.isWasDeath());
            if (!(event.getEntity() instanceof ServerPlayer)) break block1;
            MinecraftServer minecraftServer = event.getEntity().getServer();
            if (minecraftServer != null) {
                minecraftServer.execute(() -> WitcheryNeoForgeEvents.onPlayerClone$lambda$0(event));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void onPlayerLoggedIn(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player2 = serverPlayer;
        this.syncAllPlayerData(player2);
    }

    private final void syncAfflictionData(ServerPlayer player) {
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        AfflictionPlayerAttachment.syncFull((Player)player, data2);
    }

    private final void syncVampireBloodData(ServerPlayer player) {
        AfflictionPlayerAttachment.Data afflictionData = AfflictionPlayerAttachment.getData((Player)player);
        if (afflictionData.getVampireLevel() > 0) {
            BloodPoolLivingEntityAttachment.Data bloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
            BloodPoolLivingEntityAttachment.setData((LivingEntity)player, bloodData);
        }
    }

    private final void clonePlayerData(Player original, Player clone, boolean wasDeath) {
        AfflictionPlayerAttachment.Data oldAfflictionData = AfflictionPlayerAttachment.getData(original);
        AfflictionPlayerAttachment.setData(clone, oldAfflictionData.withAbilityIndex(-1), false);
        VampireSpecificEventHandler.respawn(original, clone, wasDeath);
        LichdomSpecificEventHandler.respawn(clone, original, wasDeath);
        InfusionPlayerAttachment.setData(clone, InfusionPlayerAttachment.getData(original));
        DeathPlayerAttachment.setData(clone, DeathPlayerAttachment.getData(original));
        CovenPlayerAttachment.setData$default(clone, CovenPlayerAttachment.getData(original), false, 4, null);
        LifebloodPlayerAttachment.setData(clone, LifebloodPlayerAttachment.getData(original));
        InventoryLockPlayerAttachment.setData(clone, InventoryLockPlayerAttachment.getData(original));
        Intrinsics.checkNotNull((Object)clone, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        LichdomSpecificEventHandler.INSTANCE.resetDeathTeleport((ServerPlayer)clone);
        CursePlayerAttachment.setData(clone, CursePlayerAttachment.getData(original));
        PhylacteryBlockEntity.Companion.onPlayerLoad(clone);
        BrewOfSleepingItem.Companion.respawnPlayer(clone);
    }

    private final void syncAllPlayerData(ServerPlayer player) {
        AfflictionPlayerAttachment.Data afflictionData = AfflictionPlayerAttachment.getData((Player)player);
        AfflictionPlayerAttachment.setData((Player)player, afflictionData, true);
        if (afflictionData.getVampireLevel() > 0) {
            BloodPoolLivingEntityAttachment.Data bloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
            BloodPoolLivingEntityAttachment.setData((LivingEntity)player, bloodData);
        }
        HudPlayerAttachment.INSTANCE.sync(player, HudPlayerAttachment.getData((Player)player));
        DeathPlayerAttachment.setData((Player)player, DeathPlayerAttachment.getData((Player)player));
        InventoryLockPlayerAttachment.setData((Player)player, InventoryLockPlayerAttachment.getData((Player)player));
        LifebloodPlayerAttachment.setData((Player)player, LifebloodPlayerAttachment.getData((Player)player));
        TarotPlayerAttachment.INSTANCE.sync((Player)player, TarotPlayerAttachment.getData((Player)player));
    }

    @SubscribeEvent
    private final void finalizeMobSpawn(FinalizeSpawnEvent event) {
        Mob entity = event.getEntity();
        if (entity instanceof CovenWitchEntity && ((CovenWitchEntity)entity).getCustomName() == null) {
            CovenWitchEntity covenWitchEntity = (CovenWitchEntity)entity;
            RandomSource randomSource = event.getLevel().getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
            covenWitchEntity.setCustomName((Component)CovenDialogue.INSTANCE.generateName(randomSource));
        }
        if (entity instanceof EnderMan && event.getLevel() instanceof ServerLevel) {
            ServerLevelAccessor serverLevelAccessor = event.getLevel();
            Intrinsics.checkNotNull((Object)serverLevelAccessor, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
            if (Intrinsics.areEqual((Object)serverLevel.dimension(), WitcheryWorldgenKeys.INSTANCE.getDREAM()) || Intrinsics.areEqual((Object)serverLevel.dimension(), WitcheryWorldgenKeys.INSTANCE.getNIGHTMARE())) {
                event.setSpawnCancelled(true);
            }
        }
    }

    @SubscribeEvent
    private final void onLivingConversion(LivingConversionEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        LivingEntity livingEntity2 = event.getOutcome();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity2, (String)"getOutcome(...)");
        PossessedDataAttachment.INSTANCE.onMobConverted(livingEntity, livingEntity2);
    }

    @SubscribeEvent
    public final void onInteractEntity(@NotNull PlayerInteractEvent.EntityInteract event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AfflictionEventHandler.interactEntityWithAbility(event, event.getEntity(), event.getTarget());
        WineGlassItem.Companion.applyWineOnVillager(event, event.getEntity(), event.getTarget());
    }

    @SubscribeEvent
    public final void onRightClickItem(@NotNull PlayerInteractEvent.RightClickItem event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        InteractionHand interactionHand = event.getHand();
        Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
        AfflictionEventHandler.rightClickItem(event, player, interactionHand);
    }

    @SubscribeEvent
    public final void onRightClickBlock(@NotNull PlayerInteractEvent.RightClickBlock event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        InteractionHand interactionHand = event.getHand();
        Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
        AfflictionEventHandler.rightClickBlockAbility(event, player, interactionHand);
        Player player2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getEntity(...)");
        InteractionHand interactionHand2 = event.getHand();
        Intrinsics.checkNotNullExpressionValue((Object)interactionHand2, (String)"getHand(...)");
        BlockPos blockPos = event.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        LecternHandler.INSTANCE.tryAccessGuidebook(event, player2, interactionHand2, blockPos);
        Player player3 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getEntity(...)");
        InteractionHand interactionHand3 = event.getHand();
        Intrinsics.checkNotNullExpressionValue((Object)interactionHand3, (String)"getHand(...)");
        BlockPos blockPos2 = event.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getPos(...)");
        LichdomSpecificEventHandler.onBlockInteract(event, player3, interactionHand3, blockPos2);
        Player player4 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player4, (String)"getEntity(...)");
        BlockPos blockPos3 = event.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"getPos(...)");
        BrazierBlockEntity.Companion.makeSoulCage(event, player4, blockPos3);
        Player player5 = event.getEntity();
        BlockPos blockPos4 = event.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"getPos(...)");
        SacrificialBlockEntity.Companion.rightClick(event, player5, blockPos4);
        Player player6 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player6, (String)"getEntity(...)");
        BlockPos blockPos5 = event.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"getPos(...)");
        MushroomLogBlock.Companion.makeMushroomLog(event, player6, blockPos5);
    }

    @SubscribeEvent
    public final void onLeftClickBlock(@NotNull PlayerInteractEvent.LeftClickBlock event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        InfusionHandler.INSTANCE.leftClickBlock(player, event.getHand(), event.getPos());
        Player player2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getEntity(...)");
        AfflictionEventHandler.leftClickBlock(event, player2);
    }

    @SubscribeEvent
    public final void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Level level = event.getPlayer().level();
        BlockState blockState = event.getState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
        CurseHandler.INSTANCE.breakBlock(level, blockState, event.getPlayer());
        Level level2 = event.getPlayer().level();
        BlockPos blockPos = event.getPos();
        BlockState blockState2 = event.getState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getState(...)");
        EntSpawningHandler.INSTANCE.breakBlock(level2, blockPos, blockState2, event.getPlayer());
        AltarBlockEntity.Companion.onBlockBreak(event);
        InventoryLockPlayerAttachment.INSTANCE.blockBreakEvent(event);
    }

    @SubscribeEvent
    public final void onPlayerLogout(@NotNull PlayerEvent.PlayerLoggedOutEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            VeinMiningTracker.INSTANCE.cancelVeinMining((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public final void onPlayerChangedDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            VeinMiningTracker.INSTANCE.cancelVeinMining((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public final void onBlockPlace(@NotNull BlockEvent.EntityPlaceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        CurseHandler.INSTANCE.placeBlock(entity.level(), event.getState(), event.getEntity());
        AltarBlockEntity.Companion.onBlockPlace(event);
        Entity entity2 = event.getEntity();
        Intrinsics.checkNotNull((Object)entity2);
        Level level = entity2.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        BlockPos blockPos = event.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        BlockState blockState = event.getState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
        RitualChalkBlock.Companion.placeInfernal(event, level, blockPos, blockState, event.getEntity());
        InventoryLockPlayerAttachment.INSTANCE.blockPlaceEvent(event);
    }

    @SubscribeEvent
    public final void onServerStarted(@NotNull ServerStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        WitcheryStructureInjects.INSTANCE.addStructure(minecraftServer);
    }

    @SubscribeEvent
    public final void onLootTableLoad(@NotNull LootTableLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        WitcheryLootInjects.INSTANCE.onLootTableLoad(event);
    }

    @SubscribeEvent
    public final void registerEvents(@NotNull RegisterCommandsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        CommandBuildContext commandBuildContext = event.getBuildContext();
        Intrinsics.checkNotNullExpressionValue((Object)commandBuildContext, (String)"getBuildContext(...)");
        Commands.CommandSelection commandSelection = event.getCommandSelection();
        Intrinsics.checkNotNullExpressionValue((Object)commandSelection, (String)"getCommandSelection(...)");
        WitcheryCommands.INSTANCE.register((CommandDispatcher<CommandSourceStack>)commandDispatcher, commandBuildContext, commandSelection);
    }

    @SubscribeEvent
    public final void onAttack(@NotNull AttackEntityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CurseHandler.INSTANCE.attackEntity(event.getEntity(), event.getEntity().level(), event.getTarget());
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        InfusionHandler.INSTANCE.leftClickEntity(player, event.getTarget());
    }

    @SubscribeEvent
    public final void onJoin(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BloodPoolHandler.INSTANCE.setBloodOnAdded(event.getEntity(), event.getEntity().level());
    }

    @SubscribeEvent
    public final void onEntityJoinLevel(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof ServerPlayer) {
            Player player = event.getEntity();
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel serverLevel = serverPlayer.serverLevel();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
            DeathQueueLevelAttachment.Data data2 = DeathQueueLevelAttachment.getData(serverLevel);
            if (data2.getKillerQueue().contains(serverPlayer.getUUID())) {
                serverPlayer.kill();
                ServerLevel serverLevel2 = serverPlayer.serverLevel();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel2, (String)"serverLevel(...)");
                UUID uUID = serverPlayer.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                DeathQueueLevelAttachment.INSTANCE.removeFromDeathQueue(serverLevel2, uUID);
            }
            AfflictionPlayerAttachment.syncFull((Player)serverPlayer, AfflictionPlayerAttachment.getData((Player)serverPlayer));
            BloodPoolLivingEntityAttachment.INSTANCE.sync((LivingEntity)serverPlayer, BloodPoolLivingEntityAttachment.getData((LivingEntity)serverPlayer));
            TransformationPlayerAttachment.INSTANCE.sync((Player)serverPlayer, TransformationPlayerAttachment.getData((Player)serverPlayer));
            InfusionPlayerAttachment.INSTANCE.sync((Player)serverPlayer, InfusionPlayerAttachment.getData((Player)serverPlayer));
            LifebloodPlayerAttachment.INSTANCE.sync((Player)serverPlayer, LifebloodPlayerAttachment.getData((Player)serverPlayer));
            PhylacteryBlockEntity.Companion.onPlayerLoad((Player)serverPlayer);
        }
    }

    @SubscribeEvent
    public final void onSleep(@NotNull SleepingEvent.Stop event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        DreamWeaverHandler.INSTANCE.onWake(event.getPlayer(), event.getSleepCounter(), event.getWakeImmediately());
    }

    @SubscribeEvent
    public final void onLevelTick(@NotNull LevelTickEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Level level = event.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        MutandisHandler.INSTANCE.tick(level);
        Level level2 = event.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"getLevel(...)");
        NecroHandler.INSTANCE.processListExhaustion(level2);
        Level level3 = event.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"getLevel(...)");
        NecroHandler.INSTANCE.tick(level3);
    }

    @SubscribeEvent
    public final void onServerStop(@NotNull ServerStoppingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        TeleportQueueHandler.INSTANCE.clearQueue(minecraftServer);
    }

    @SubscribeEvent
    public final void onLightningStruck(@NotNull EntityStruckByLightningEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InfernalInfusionHandler.INSTANCE.strikeLightning(event.getEntity());
    }

    @SubscribeEvent
    public final void onChain(@NotNull ChainEvent.Discard event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        BindSpectralCreaturesRitual.Companion.handleChainDiscard(event.getEntity());
        SoulCageBlockEntity.Companion.handleChainDiscard(event.getEntity());
    }

    @SubscribeEvent
    public final void canPlayerSleepEvent(@NotNull CanPlayerSleepEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getState().getBlock() instanceof CoffinBlock) {
            if (event.getLevel().isDay()) {
                event.getEntity().setRespawnPosition(event.getLevel().dimension(), event.getPos(), event.getEntity().getYRot(), false, true);
                event.setProblem(null);
            } else {
                event.setProblem(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            }
        }
    }

    @SubscribeEvent
    public final void canContinueSleepingEvent(@NotNull CanContinueSleepingEvent event) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BlockState blockState2 = blockState = (BlockState)event.getEntity().getSleepingPos().map(arg_0 -> WitcheryNeoForgeEvents.canContinueSleepingEvent$lambda$1(arg_0 -> WitcheryNeoForgeEvents.canContinueSleepingEvent$lambda$0(event, arg_0), arg_0)).orElse(null);
        if ((blockState2 != null ? blockState2.getBlock() : null) instanceof CoffinBlock) {
            if (event.getEntity().level().isDay()) {
                event.setContinueSleeping(true);
            } else {
                event.setContinueSleeping(false);
            }
        }
    }

    @SubscribeEvent
    public final void sleepFinishedTimeEvent(@NotNull SleepFinishedTimeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor level = event.getLevel();
        if (level instanceof ServerLevel) {
            boolean sleepingInCoffin;
            block6: {
                List list = ((ServerLevel)level).players();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ServerPlayer player = (ServerPlayer)element$iv;
                        boolean bl = false;
                        Boolean bl2 = player.getSleepingPos().map(arg_0 -> WitcheryNeoForgeEvents.sleepFinishedTimeEvent$lambda$0$1(arg_0 -> WitcheryNeoForgeEvents.sleepFinishedTimeEvent$lambda$0$0(level, arg_0), arg_0)).orElse(false);
                        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"orElse(...)");
                        if (!bl2.booleanValue()) continue;
                        v1 = true;
                        break block6;
                    }
                    v1 = sleepingInCoffin = false;
                }
            }
            if (sleepingInCoffin && ((ServerLevel)level).isDay()) {
                long fullDays = ((ServerLevel)level).getDayTime() / 24000L;
                long newTime = fullDays * 24000L + 13000L;
                event.setTimeAddition(newTime);
                this.triggerTarotEffectsForAllPlayers((ServerLevel)level, true);
            } else {
                this.triggerTarotEffectsForAllPlayers((ServerLevel)level, false);
            }
        }
    }

    private final void triggerTarotEffectsForAllPlayers(ServerLevel level, boolean isNightfall) {
        for (ServerPlayer player : level.players()) {
            TarotPlayerAttachment.Data data2;
            if (player == null || (data2 = TarotPlayerAttachment.getData((Player)player)).getDrawnCards().isEmpty()) continue;
            int n = ((Collection)data2.getDrawnCards()).size();
            for (int i = 0; i < n; ++i) {
                int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
                Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
                boolean isReversed = bl != null ? bl : false;
                TarotEffect effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
                if (isNightfall) {
                    TarotEffect tarotEffect = effect;
                    if (tarotEffect != null) {
                        tarotEffect.onNightfall((Player)player, isReversed);
                    }
                    continue;
                }
                TarotEffect tarotEffect = effect;
                if (tarotEffect == null) continue;
                tarotEffect.onMorning((Player)player, isReversed);
            }
        }
    }

    private static final MerchantOffer addFortuneTellerTrades$lambda$0(Entity entity, RandomSource random) {
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 24), ((TarotDeckItem)((Object)WitcheryItems.INSTANCE.getTAROT_DECK().get())).getDefaultInstance(), 1, 3, 0.2f);
    }

    private static final void onPlayerTeleportDim$lambda$0(ServerPlayer $player) {
        INSTANCE.syncAfflictionData($player);
        INSTANCE.syncVampireBloodData($player);
        PossessionComponentAttachment.INSTANCE.syncToClient((Player)$player);
        PossessedDataAttachment.INSTANCE.syncToClient((Entity)$player);
    }

    private static final void onPlayerClone$lambda$0(PlayerEvent.Clone $event) {
        Player player = $event.getEntity();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        INSTANCE.syncAfflictionData((ServerPlayer)player);
        Player player2 = $event.getEntity();
        Intrinsics.checkNotNull((Object)player2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        INSTANCE.syncVampireBloodData((ServerPlayer)player2);
    }

    private static final BlockState canContinueSleepingEvent$lambda$0(CanContinueSleepingEvent $event, BlockPos it) {
        return $event.getEntity().level().getBlockState(it);
    }

    private static final BlockState canContinueSleepingEvent$lambda$1(Function1 $tmp0, Object p0) {
        return (BlockState)$tmp0.invoke(p0);
    }

    private static final Boolean sleepFinishedTimeEvent$lambda$0$0(LevelAccessor $level, BlockPos it) {
        return ((ServerLevel)$level).getBlockState(it).getBlock() instanceof CoffinBlock;
    }

    private static final Boolean sleepFinishedTimeEvent$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

