/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.client.hud.HudPositionData;
import dev.sterner.witchery.core.registry.WitcheryKeyMappings;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.lich.LichdomLeveling;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import dev.sterner.witchery.features.affliction.werewolf.WerewolfLeveling;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.features.misc.HudPlayerAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000256B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJH\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0012H\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0015H\u0002J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020\u0015H\u0002J&\u00100\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020\u0015H\u0002J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020\u0015H\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u00101\u001a\u000202H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ldev/sterner/witchery/client/hud/QuestHudRenderer;", "", "<init>", "()V", "isVisible", "", "()Z", "setVisible", "(Z)V", "expandAnimation", "", "questCompletionAnimations", "", "", "Ldev/sterner/witchery/client/hud/QuestHudRenderer$QuestAnimation;", "lastCompletedQuests", "", "questStates", "Ldev/sterner/witchery/client/hud/QuestHudRenderer$QuestState;", "ANIMATION_SPEED", "TITLE_COLOR", "", "QUEST_COLOR", "COMPLETE_COLOR", "toggle", "", "tick", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderAfflictionQuests", "font", "Lnet/minecraft/client/gui/Font;", "x", "startY", "title", "type", "Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "level", "alpha", "buildQuestText", "Lnet/minecraft/network/chat/Component;", "quest", "getQuestsForAffliction", "", "getWerewolfQuests", "data", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "getVampireQuests", "player", "Lnet/minecraft/world/entity/player/Player;", "getLichQuests", "getCurrentQuestIds", "QuestAnimation", "QuestState", "witchery"})
@SourceDebugExtension(value={"SMAP\nQuestHudRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestHudRenderer.kt\ndev/sterner/witchery/client/hud/QuestHudRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,559:1\n774#2:560\n865#2,2:561\n1869#2,2:563\n774#2:565\n865#2,2:566\n1563#2:568\n1634#2,3:569\n1869#2,2:572\n1869#2,2:574\n*S KotlinDebug\n*F\n+ 1 QuestHudRenderer.kt\ndev/sterner/witchery/client/hud/QuestHudRenderer\n*L\n76#1:560\n76#1:561,2\n78#1:563,2\n82#1:565\n82#1:566,2\n82#1:568\n82#1:569,3\n92#1:572,2\n193#1:574,2\n*E\n"})
public final class QuestHudRenderer {
    @NotNull
    public static final QuestHudRenderer INSTANCE = new QuestHudRenderer();
    private static boolean isVisible;
    private static float expandAnimation;
    @NotNull
    private static final Map<String, QuestAnimation> questCompletionAnimations;
    @NotNull
    private static Set<String> lastCompletedQuests;
    @NotNull
    private static final Map<String, QuestState> questStates;
    private static final float ANIMATION_SPEED = 0.15f;
    private static final int TITLE_COLOR = 16766720;
    private static final int QUEST_COLOR = 0xE0E0E0;
    private static final int COMPLETE_COLOR = 0x40FF40;

    private QuestHudRenderer() {
    }

    public final boolean isVisible() {
        return isVisible;
    }

    public final void setVisible(boolean bl) {
        isVisible = bl;
    }

    public final void toggle() {
        boolean bl = isVisible = !isVisible;
        if (isVisible) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.2f));
        } else {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)0.8f));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void tick() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        QuestState it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        if (data2.getWerewolfLevel() == 0 && data2.getVampireLevel() == 0 && data2.getLichLevel() == 0 && !isVisible) {
            isVisible = false;
        }
        float targetExpand = isVisible ? 1.0f : 0.0f;
        expandAnimation = Mth.lerp((float)0.15f, (float)expandAnimation, (float)targetExpand);
        List<QuestState> currentQuests = this.getCurrentQuestIds((Player)player);
        Iterable $this$filter$iv = currentQuests;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (QuestState)element$iv$iv;
            boolean bl = false;
            if (!(it.isComplete() && !lastCompletedQuests.contains(it.getId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newlyCompleted = (List)destination$iv$iv;
        Iterable $this$forEach$iv = newlyCompleted;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QuestState quest = (QuestState)element$iv;
            boolean bl = false;
            questCompletionAnimations.put(quest.getId(), new QuestAnimation(0.0f, 0.0f, 0.0f, 7, null));
        }
        $this$filter$iv = currentQuests;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (QuestState)element$iv$iv;
            boolean bl2 = false;
            if (!it.isComplete()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (QuestState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getId());
        }
        lastCompletedQuests = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        questCompletionAnimations.entrySet().removeIf(arg_0 -> QuestHudRenderer.tick$lambda$5(QuestHudRenderer::tick$lambda$4, arg_0));
        questStates.clear();
        $this$forEach$iv = currentQuests;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QuestState it2 = (QuestState)element$iv;
            boolean bl4 = false;
            questStates.put(it2.getId(), it2);
        }
    }

    public final void render(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        if (expandAnimation <= 0.01f) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        Font font = minecraft.font;
        HudPositionData positions = HudPlayerAttachment.getData((Player)player).getHudPositions();
        HudPositionData.Coord coord = positions.getQuestHudPos(guiGraphics.guiWidth(), guiGraphics.guiHeight());
        int baseX = coord.component1();
        int baseY = coord.component2();
        int alpha = RangesKt.coerceIn((int)((int)(expandAnimation * (float)255)), (int)0, (int)255);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float scale = 0.25f + expandAnimation * 0.5f;
        poseStack.translate((float)baseX, (float)baseY, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        poseStack.translate(-((float)baseX), -((float)baseY), 0.0f);
        int yOffset = baseY;
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        if (data2.getWerewolfLevel() > 0) {
            Intrinsics.checkNotNull((Object)font);
            yOffset = this.renderAfflictionQuests(guiGraphics, font, baseX, yOffset, "Lycanthropy", AfflictionTypes.LYCANTHROPY, data2.getWerewolfLevel(), alpha);
            yOffset += 10;
        }
        if (data2.getVampireLevel() > 0) {
            Intrinsics.checkNotNull((Object)font);
            yOffset = this.renderAfflictionQuests(guiGraphics, font, baseX, yOffset, "Vampirism", AfflictionTypes.VAMPIRISM, data2.getVampireLevel(), alpha);
            yOffset += 10;
        }
        if (data2.getLichLevel() > 0) {
            Intrinsics.checkNotNull((Object)font);
            yOffset = this.renderAfflictionQuests(guiGraphics, font, baseX, yOffset, "Lichdom", AfflictionTypes.LICHDOM, data2.getLichLevel(), alpha);
        }
        if (expandAnimation > 0.9f) {
            String hintText = "Press " + WitcheryKeyMappings.INSTANCE.getTOGGLE_QUEST_HUD().getKey().getDisplayName().getString() + " to hide";
            int hintWidth = font.width(hintText) / 2;
            guiGraphics.drawString(font, hintText, baseX - hintWidth, yOffset, 0xE0E0E0 | alpha / 2 << 24, false);
        }
        poseStack.popPose();
    }

    private final int renderAfflictionQuests(GuiGraphics guiGraphics, Font font, int x, int startY, String title, AfflictionTypes type, int level, int alpha) {
        int y = 0;
        y = startY;
        MutableComponent titleComponent = Component.literal((String)title);
        int titleWidth = font.width((FormattedText)titleComponent) / 2;
        guiGraphics.drawString(font, (Component)titleComponent, x - titleWidth, y, 0xFFD700 | alpha << 24, false);
        int separatorWidth = 100;
        RenderSystem.enableBlend();
        guiGraphics.fill(x - separatorWidth / 4, y += 12, x + separatorWidth / 4, y + 1, 0xFFD700 | alpha << 24);
        y += 8;
        List<QuestState> quests = this.getQuestsForAffliction(type, level);
        Iterable $this$forEach$iv = quests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QuestAnimation animation;
            QuestState quest = (QuestState)element$iv;
            boolean bl = false;
            QuestAnimation questAnimation = animation = questCompletionAnimations.get(quest.getId());
            int questY = y + (questAnimation != null ? (int)questAnimation.getBounceOffset() : 0);
            QuestAnimation questAnimation2 = animation;
            int questAlpha = RangesKt.coerceIn((int)((int)((questAnimation2 != null ? questAnimation2.getAlpha() : 1.0f) * (float)alpha)), (int)0, (int)255);
            int bulletColor = quest.isComplete() ? 0x40FF40 : 0xE0E0E0;
            guiGraphics.drawString(font, "\u2022", x - 50, questY, bulletColor & 0xFFFFFF | questAlpha << 24, false);
            Component questText = INSTANCE.buildQuestText(quest);
            int textColor = quest.isComplete() ? 0x40FF40 : 0xE0E0E0;
            guiGraphics.drawString(font, questText, x - 45, questY, textColor & 0xFFFFFF | questAlpha << 24, false);
            if (quest.isComplete()) {
                QuestAnimation questAnimation3 = animation;
                float strikeProgress = questAnimation3 != null ? questAnimation3.getProgress() : 1.0f;
                int textWidth = font.width((FormattedText)questText);
                int strikeWidth = (int)((float)textWidth * strikeProgress);
                guiGraphics.fill(x - 45, questY + 4, x - 45 + strikeWidth, questY + 5, 0x40FF40 | questAlpha << 24);
            }
            y += 10;
        }
        return y;
    }

    private final Component buildQuestText(QuestState quest) {
        Component component;
        if (quest.getMax() > 0) {
            MutableComponent mutableComponent = Component.literal((String)(quest.getDescription() + " (" + quest.getCurrent() + "/" + quest.getMax() + ")"));
            Intrinsics.checkNotNull((Object)mutableComponent);
            component = (Component)mutableComponent;
        } else {
            MutableComponent mutableComponent = Component.literal((String)quest.getDescription());
            Intrinsics.checkNotNull((Object)mutableComponent);
            component = (Component)mutableComponent;
        }
        return component;
    }

    private final List<QuestState> getQuestsForAffliction(AfflictionTypes type, int level) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return CollectionsKt.emptyList();
        }
        LocalPlayer player = localPlayer;
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.getWerewolfQuests(data2, level);
            case 2 -> this.getVampireQuests((Player)player, data2, level);
            case 3 -> this.getLichQuests(data2, level);
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<QuestState> getWerewolfQuests(AfflictionPlayerAttachment.Data data2, int level) {
        List quests;
        block12: {
            int max;
            boolean it;
            int level2 = data2.getWerewolfLevel();
            int nextLevel = level2 + 1;
            if (nextLevel > 10) {
                return CollectionsKt.emptyList();
            }
            WerewolfLeveling.Requirement requirement = WerewolfLeveling.INSTANCE.getLEVEL_REQUIREMENTS().get(nextLevel);
            if (requirement == null) {
                return CollectionsKt.emptyList();
            }
            WerewolfLeveling.Requirement requirement2 = requirement;
            quests = new ArrayList();
            Boolean bl = requirement2.getThreeGold();
            if (bl != null) {
                it = bl;
                boolean bl2 = false;
                quests.add(new QuestState("gold_" + nextLevel, "Give 3 gold ingots to altar", data2.hasGivenGold() ? 1 : 0, 1, data2.hasGivenGold()));
            }
            Integer n = requirement2.getKilledSheep();
            if (n != null) {
                max = ((Number)n).intValue();
                boolean bl3 = false;
                quests.add(new QuestState("sheep_" + nextLevel, "Kill sheep", data2.getKilledSheep(), max, data2.getKilledSheep() >= max));
            }
            Boolean bl4 = requirement2.getOfferedMutton();
            if (bl4 != null) {
                it = bl4;
                boolean bl5 = false;
                quests.add(new QuestState("mutton_" + nextLevel, "Offer 30 mutton to altar", data2.hasOfferedMutton() ? 1 : 0, 1, data2.hasOfferedMutton()));
            }
            Integer n2 = requirement2.getKilledWolves();
            if (n2 != null) {
                max = ((Number)n2).intValue();
                boolean bl6 = false;
                quests.add(new QuestState("wolves_" + nextLevel, "Kill wolves", data2.getKilledWolves(), max, data2.getKilledWolves() >= max));
            }
            Boolean bl7 = requirement2.getOfferedTongues();
            if (bl7 != null) {
                it = bl7;
                boolean bl8 = false;
                quests.add(new QuestState("tongues_" + nextLevel, "Offer 10 tongues to altar", data2.hasOfferedTongue() ? 1 : 0, 1, data2.hasOfferedTongue()));
            }
            Boolean bl9 = requirement2.getKillHornedOne();
            if (bl9 != null) {
                it = bl9;
                boolean bl10 = false;
                quests.add(new QuestState("horned_" + nextLevel, "Kill Horned Huntsman", data2.hasKilledHornedOne() ? 1 : 0, 1, data2.hasKilledHornedOne()));
            }
            Integer n3 = requirement2.getAirSlayMonster();
            if (n3 != null) {
                max = ((Number)n3).intValue();
                boolean bl11 = false;
                quests.add(new QuestState("air_slay_" + nextLevel, "Kill monsters in air", data2.getAirSlayMonster(), max, data2.getAirSlayMonster() >= max));
            }
            Integer n4 = requirement2.getNightHowl();
            if (n4 != null) {
                max = ((Number)n4).intValue();
                boolean bl12 = false;
                quests.add(new QuestState("howl_" + nextLevel, "Howl at night", data2.getNightHowl(), max, data2.getNightHowl() >= max));
            }
            Integer n5 = requirement2.getWolfPack();
            if (n5 != null) {
                max = ((Number)n5).intValue();
                boolean bl13 = false;
                quests.add(new QuestState("pack_" + nextLevel, "Form wolf pack", data2.getWolfPack(), max, data2.getWolfPack() >= max));
            }
            Integer n6 = requirement2.getPigmenKilled();
            if (n6 != null) {
                max = ((Number)n6).intValue();
                boolean bl14 = false;
                quests.add(new QuestState("pigmen_" + nextLevel, "Kill piglins", data2.getPigmenKilled(), max, data2.getPigmenKilled() >= max));
            }
            Boolean bl15 = requirement2.getSpreadLycanthropy();
            if (bl15 == null) break block12;
            it = bl15;
            boolean bl16 = false;
            quests.add(new QuestState("spread_" + nextLevel, "Spread lycanthropy", data2.hasSpreadLycanthropy() ? 1 : 0, 1, data2.hasSpreadLycanthropy()));
        }
        return quests;
    }

    private final List<QuestState> getVampireQuests(Player player, AfflictionPlayerAttachment.Data data2, int level) {
        List quests;
        block8: {
            int max;
            int nextLevel = level + 1;
            if (nextLevel > 10) {
                return CollectionsKt.emptyList();
            }
            quests = new ArrayList();
            if (nextLevel == 2) {
                BloodPoolLivingEntityAttachment.Data bloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
                quests.add(new QuestState("fill_up_" + nextLevel, "Fill your blood pool", bloodData.getBloodPool(), 900, bloodData.getBloodPool() >= 900));
                return quests;
            }
            VampireLeveling.Requirement requirement = VampireLeveling.INSTANCE.getLEVEL_REQUIREMENTS().get(nextLevel);
            if (requirement == null) {
                return CollectionsKt.emptyList();
            }
            VampireLeveling.Requirement requirement2 = requirement;
            Integer n = requirement2.getHalfVillagers();
            if (n != null) {
                max = ((Number)n).intValue();
                boolean bl = false;
                quests.add(new QuestState("half_blood_" + nextLevel, "Suck half-blood of villagers", data2.getVillagersHalfBlood().size(), max, data2.getVillagersHalfBlood().size() >= max));
            }
            Integer n2 = requirement2.getNightCounter();
            if (n2 != null) {
                max = ((Number)n2).intValue();
                boolean bl = false;
                quests.add(new QuestState("night_" + nextLevel, "Survive nights", data2.getNightTicker(), max, data2.getNightTicker() >= max));
            }
            Integer n3 = requirement2.getSunGrenades();
            if (n3 != null) {
                max = ((Number)n3).intValue();
                boolean bl = false;
                quests.add(new QuestState("grenades_" + nextLevel, "Use sun grenades", data2.getUsedSunGrenades(), max, data2.getUsedSunGrenades() >= max));
            }
            Integer n4 = requirement2.getBlazesKilled();
            if (n4 != null) {
                max = ((Number)n4).intValue();
                boolean bl = false;
                quests.add(new QuestState("blazes_" + nextLevel, "Kill blazes", data2.getKilledBlazes(), max, data2.getKilledBlazes() >= max));
            }
            Integer n5 = requirement2.getVillagesVisited();
            if (n5 != null) {
                max = ((Number)n5).intValue();
                boolean bl = false;
                quests.add(new QuestState("villages_" + nextLevel, "Visit villages as bat", data2.getVisitedVillages().size(), max, data2.getVisitedVillages().size() >= max));
            }
            Integer n6 = requirement2.getTrappedVillagers();
            if (n6 == null) break block8;
            max = ((Number)n6).intValue();
            boolean bl = false;
            quests.add(new QuestState("trapped_" + nextLevel, "Trap villagers", data2.getTrappedVillagers().size(), max, data2.getTrappedVillagers().size() >= max));
        }
        return quests;
    }

    private final List<QuestState> getLichQuests(AfflictionPlayerAttachment.Data data2, int level) {
        List quests;
        block8: {
            boolean it;
            int max;
            int nextLevel = level + 1;
            if (nextLevel > 10) {
                return CollectionsKt.emptyList();
            }
            LichdomLeveling.Requirement requirement = LichdomLeveling.INSTANCE.getLEVEL_REQUIREMENTS().get(nextLevel);
            if (requirement == null) {
                return CollectionsKt.emptyList();
            }
            LichdomLeveling.Requirement requirement2 = requirement;
            quests = new ArrayList();
            Integer n = requirement2.getBoundSouls();
            if (n != null) {
                max = ((Number)n).intValue();
                boolean bl = false;
                quests.add(new QuestState("souls_" + nextLevel, "Bind souls", data2.getBoundSouls(), max, data2.getBoundSouls() >= max));
            }
            Boolean bl = requirement2.getZombieKilledMob();
            if (bl != null) {
                it = bl;
                boolean bl2 = false;
                quests.add(new QuestState("zombie_kill_" + nextLevel, "Zombie slave kills mob", data2.hasZombieKilledMob() ? 1 : 0, 1, data2.hasZombieKilledMob()));
            }
            Integer n2 = requirement2.getKilledGolems();
            if (n2 != null) {
                max = ((Number)n2).intValue();
                boolean bl3 = false;
                quests.add(new QuestState("golems_" + nextLevel, "Kill golems", data2.getKilledGolems(), max, data2.getKilledGolems() >= max));
            }
            Integer n3 = requirement2.getDrainedAnimals();
            if (n3 != null) {
                max = ((Number)n3).intValue();
                boolean bl4 = false;
                quests.add(new QuestState("drained_" + nextLevel, "Drain animals", data2.getDrainedAnimals(), max, data2.getDrainedAnimals() >= max));
            }
            Boolean bl5 = requirement2.getPossessedKillVillager();
            if (bl5 != null) {
                it = bl5;
                boolean bl6 = false;
                quests.add(new QuestState("possess_" + nextLevel, "Possess and kill villager", data2.hasPossessedKillVillager() ? 1 : 0, 1, data2.hasPossessedKillVillager()));
            }
            Boolean bl7 = requirement2.getKilledWither();
            if (bl7 != null) {
                it = bl7;
                boolean bl8 = false;
                quests.add(new QuestState("wither_" + nextLevel, "Kill wither", data2.hasKilledWither() ? 1 : 0, 1, data2.hasKilledWither()));
            }
            Integer n4 = requirement2.getPhylacteryDeaths();
            if (n4 == null) break block8;
            max = ((Number)n4).intValue();
            boolean bl9 = false;
            quests.add(new QuestState("phylactery_" + nextLevel, "Die with phylactery", data2.getPhylacteryDeaths(), max, data2.getPhylacteryDeaths() >= max));
        }
        return quests;
    }

    private final List<QuestState> getCurrentQuestIds(Player player) {
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData(player);
        List allQuests = new ArrayList();
        if (data2.getWerewolfLevel() > 0) {
            allQuests.addAll((Collection)this.getWerewolfQuests(data2, data2.getWerewolfLevel()));
        }
        if (data2.getVampireLevel() > 0) {
            allQuests.addAll((Collection)this.getVampireQuests(player, data2, data2.getVampireLevel()));
        }
        if (data2.getLichLevel() > 0) {
            allQuests.addAll((Collection)this.getLichQuests(data2, data2.getLichLevel()));
        }
        return allQuests;
    }

    private static final boolean tick$lambda$4(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        QuestAnimation anim = (QuestAnimation)entry.getValue();
        anim.setProgress(anim.getProgress() + 0.05f);
        anim.setBounceOffset((float)Math.sin((double)anim.getProgress() * Math.PI * (double)2) * 3.0f * (1.0f - anim.getProgress()));
        anim.setAlpha(1.0f - anim.getProgress() * 0.3f);
        return anim.getProgress() >= 1.0f;
    }

    private static final boolean tick$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        questCompletionAnimations = new LinkedHashMap();
        lastCompletedQuests = SetsKt.emptySet();
        questStates = new LinkedHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ldev/sterner/witchery/client/hud/QuestHudRenderer$QuestAnimation;", "", "progress", "", "bounceOffset", "alpha", "<init>", "(FFF)V", "getProgress", "()F", "setProgress", "(F)V", "getBounceOffset", "setBounceOffset", "getAlpha", "setAlpha", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "witchery"})
    public static final class QuestAnimation {
        private float progress;
        private float bounceOffset;
        private float alpha;

        public QuestAnimation(float progress, float bounceOffset, float alpha) {
            this.progress = progress;
            this.bounceOffset = bounceOffset;
            this.alpha = alpha;
        }

        public /* synthetic */ QuestAnimation(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 0.0f;
            }
            if ((n & 2) != 0) {
                f2 = 0.0f;
            }
            if ((n & 4) != 0) {
                f3 = 1.0f;
            }
            this(f, f2, f3);
        }

        public final float getProgress() {
            return this.progress;
        }

        public final void setProgress(float f) {
            this.progress = f;
        }

        public final float getBounceOffset() {
            return this.bounceOffset;
        }

        public final void setBounceOffset(float f) {
            this.bounceOffset = f;
        }

        public final float getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(float f) {
            this.alpha = f;
        }

        public final float component1() {
            return this.progress;
        }

        public final float component2() {
            return this.bounceOffset;
        }

        public final float component3() {
            return this.alpha;
        }

        @NotNull
        public final QuestAnimation copy(float progress, float bounceOffset, float alpha) {
            return new QuestAnimation(progress, bounceOffset, alpha);
        }

        public static /* synthetic */ QuestAnimation copy$default(QuestAnimation questAnimation, float f, float f2, float f3, int n, Object object) {
            if ((n & 1) != 0) {
                f = questAnimation.progress;
            }
            if ((n & 2) != 0) {
                f2 = questAnimation.bounceOffset;
            }
            if ((n & 4) != 0) {
                f3 = questAnimation.alpha;
            }
            return questAnimation.copy(f, f2, f3);
        }

        @NotNull
        public String toString() {
            return "QuestAnimation(progress=" + this.progress + ", bounceOffset=" + this.bounceOffset + ", alpha=" + this.alpha + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.progress);
            result = result * 31 + Float.hashCode(this.bounceOffset);
            result = result * 31 + Float.hashCode(this.alpha);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuestAnimation)) {
                return false;
            }
            QuestAnimation questAnimation = (QuestAnimation)other;
            if (Float.compare(this.progress, questAnimation.progress) != 0) {
                return false;
            }
            if (Float.compare(this.bounceOffset, questAnimation.bounceOffset) != 0) {
                return false;
            }
            return Float.compare(this.alpha, questAnimation.alpha) == 0;
        }

        public QuestAnimation() {
            this(0.0f, 0.0f, 0.0f, 7, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/client/hud/QuestHudRenderer$QuestState;", "", "id", "", "description", "current", "", "max", "isComplete", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIZ)V", "getId", "()Ljava/lang/String;", "getDescription", "getCurrent", "()I", "getMax", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "witchery"})
    public static final class QuestState {
        @NotNull
        private final String id;
        @NotNull
        private final String description;
        private final int current;
        private final int max;
        private final boolean isComplete;

        public QuestState(@NotNull String id, @NotNull String description, int current, int max, boolean isComplete) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.id = id;
            this.description = description;
            this.current = current;
            this.max = max;
            this.isComplete = isComplete;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final int getCurrent() {
            return this.current;
        }

        public final int getMax() {
            return this.max;
        }

        public final boolean isComplete() {
            return this.isComplete;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.description;
        }

        public final int component3() {
            return this.current;
        }

        public final int component4() {
            return this.max;
        }

        public final boolean component5() {
            return this.isComplete;
        }

        @NotNull
        public final QuestState copy(@NotNull String id, @NotNull String description, int current, int max, boolean isComplete) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new QuestState(id, description, current, max, isComplete);
        }

        public static /* synthetic */ QuestState copy$default(QuestState questState, String string, String string2, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = questState.id;
            }
            if ((n3 & 2) != 0) {
                string2 = questState.description;
            }
            if ((n3 & 4) != 0) {
                n = questState.current;
            }
            if ((n3 & 8) != 0) {
                n2 = questState.max;
            }
            if ((n3 & 0x10) != 0) {
                bl = questState.isComplete;
            }
            return questState.copy(string, string2, n, n2, bl);
        }

        @NotNull
        public String toString() {
            return "QuestState(id=" + this.id + ", description=" + this.description + ", current=" + this.current + ", max=" + this.max + ", isComplete=" + this.isComplete + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.description.hashCode();
            result = result * 31 + Integer.hashCode(this.current);
            result = result * 31 + Integer.hashCode(this.max);
            result = result * 31 + Boolean.hashCode(this.isComplete);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuestState)) {
                return false;
            }
            QuestState questState = (QuestState)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)questState.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)questState.description)) {
                return false;
            }
            if (this.current != questState.current) {
                return false;
            }
            if (this.max != questState.max) {
                return false;
            }
            return this.isComplete == questState.isComplete;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AfflictionTypes.values().length];
            try {
                nArray[AfflictionTypes.LYCANTHROPY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AfflictionTypes.VAMPIRISM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AfflictionTypes.LICHDOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

