/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.DemonEntityModel;
import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B)\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJX\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Ldev/sterner/witchery/client/layer/DemonHeadFeatureRenderer;", "Lnet/minecraft/client/renderer/entity/layers/RenderLayer;", "Lnet/minecraft/client/player/AbstractClientPlayer;", "Lnet/minecraft/client/model/PlayerModel;", "renderer", "Lnet/minecraft/client/renderer/entity/RenderLayerParent;", "ctx", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/RenderLayerParent;Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "getCtx", "()Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "setCtx", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "demonModel", "Ldev/sterner/witchery/client/model/DemonEntityModel;", "getDemonModel", "()Ldev/sterner/witchery/client/model/DemonEntityModel;", "render", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "livingEntity", "limbSwing", "", "limbSwingAmount", "partialTick", "ageInTicks", "netHeadYaw", "headPitch", "witchery"})
public final class DemonHeadFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @NotNull
    private EntityRendererProvider.Context ctx;
    @NotNull
    private final DemonEntityModel demonModel;

    public DemonHeadFeatureRenderer(@NotNull RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer, @NotNull EntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(renderer);
        this.ctx = ctx;
        ModelPart modelPart = this.ctx.bakeLayer(DemonEntityModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.demonModel = new DemonEntityModel(modelPart);
    }

    @NotNull
    public final EntityRendererProvider.Context getCtx() {
        return this.ctx;
    }

    public final void setCtx(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.ctx = context;
    }

    @NotNull
    public final DemonEntityModel getDemonModel() {
        return this.demonModel;
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, @NotNull AbstractClientPlayer livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity.hasEffect((Holder)WitcheryMobEffects.INSTANCE.getGROTESQUE())) {
            poseStack.pushPose();
            this.demonModel.getLeftArm().visible = false;
            this.demonModel.getRightArm().visible = false;
            this.demonModel.getRightLeg().visible = false;
            this.demonModel.getLeftLeg().visible = false;
            this.demonModel.getBody().visible = false;
            this.demonModel.getCoreBody().visible = false;
            this.demonModel.getUpperBody().visible = false;
            this.demonModel.getRWing().visible = false;
            this.demonModel.getLWing().visible = false;
            this.demonModel.getHead().visible = true;
            PlayerModel playerModel = (PlayerModel)this.getParentModel();
            this.demonModel.getHead().copyFrom(playerModel.head);
            poseStack.translate(0.0, 0.25, -0.5);
            poseStack.scale(0.9f, 0.9f, 0.9f);
            this.demonModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)Witchery.Companion.id("textures/entity/demon.png"))), packedLight, OverlayTexture.NO_OVERLAY, -1);
            poseStack.popPose();
        }
    }
}

