/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.EntEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001&B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J(\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J0\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/sterner/witchery/client/model/EntEntityModel;", "Lnet/minecraft/client/model/HierarchicalModel;", "Ldev/sterner/witchery/content/entity/EntEntity;", "Lnet/minecraft/client/model/ArmedModel;", "root", "Lnet/minecraft/client/model/geom/ModelPart;", "<init>", "(Lnet/minecraft/client/model/geom/ModelPart;)V", "getRoot", "()Lnet/minecraft/client/model/geom/ModelPart;", "rightLeg", "leftArm", "rightArm", "body", "leftLeg", "setupAnim", "", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "prepareMobModel", "partialTick", "renderToBuffer", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "vertexConsumer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "packedLight", "", "packedOverlay", "color", "translateToHand", "side", "Lnet/minecraft/world/entity/HumanoidArm;", "Companion", "witchery"})
public final class EntEntityModel
extends HierarchicalModel<EntEntity>
implements ArmedModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelPart root;
    @NotNull
    private final ModelPart rightLeg;
    @NotNull
    private final ModelPart leftArm;
    @NotNull
    private final ModelPart rightArm;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart leftLeg;
    @NotNull
    private static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Witchery.Companion.id("ent"), "main");

    public EntEntityModel(@NotNull ModelPart root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(EntEntityModel::_init_$lambda$0);
        this.root = root;
        ModelPart modelPart = this.root.getChild("rightLeg");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"getChild(...)");
        this.rightLeg = modelPart;
        ModelPart modelPart2 = this.root.getChild("leftArm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"getChild(...)");
        this.leftArm = modelPart2;
        ModelPart modelPart3 = this.root.getChild("rightArm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"getChild(...)");
        this.rightArm = modelPart3;
        ModelPart modelPart4 = this.root.getChild("body");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"getChild(...)");
        this.body = modelPart4;
        ModelPart modelPart5 = this.root.getChild("leftLeg");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart5, (String)"getChild(...)");
        this.leftLeg = modelPart5;
    }

    @NotNull
    public final ModelPart getRoot() {
        return this.root;
    }

    public void setupAnim(@NotNull EntEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        this.rightLeg.xRot = -1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftLeg.xRot = 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
    }

    public void prepareMobModel(@NotNull EntEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        int i = entity.getAttackAnimationTick();
        if (i > 0) {
            this.rightArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - partialTick), (float)10.0f);
            this.leftArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - partialTick), (float)10.0f);
        } else {
            this.rightArm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftArm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void translateToHand(@NotNull HumanoidArm side, @NotNull PoseStack poseStack) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
    }

    private static final RenderType _init_$lambda$0(ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return RenderType.entityTranslucent((ResourceLocation)location);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/client/model/EntEntityModel$Companion;", "", "<init>", "()V", "LAYER_LOCATION", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getLAYER_LOCATION", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBodyLayer", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelLayerLocation getLAYER_LOCATION() {
            return LAYER_LOCATION;
        }

        @NotNull
        public final LayerDefinition createBodyLayer() {
            MeshDefinition meshDefinition = new MeshDefinition();
            PartDefinition partDefinition = meshDefinition.getRoot();
            partDefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(32, 64).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)8.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(64, 40).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)8.0f, (float)0.0f));
            PartDefinition leftArm = partDefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(64, 0).addBox(0.0f, -3.0f, -4.0f, 8.0f, 32.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(120, 122).addBox(8.0f, 3.0f, 0.0f, 4.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(64, 125).addBox(0.0f, -5.0f, -4.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)-9.0f, (float)0.0f));
            leftArm.addOrReplaceChild("Crown_r1", CubeListBuilder.create().texOffs(64, 125).addBox(-7.0f, -2.0f, -1.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
            leftArm.addOrReplaceChild("Crown_r2", CubeListBuilder.create().texOffs(64, 125).addBox(-7.0f, -2.0f, -1.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)3.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
            leftArm.addOrReplaceChild("Crown_r3", CubeListBuilder.create().texOffs(64, 125).addBox(-7.0f, -2.0f, -1.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-3.0f, (float)3.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
            PartDefinition rightArm = partDefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(112, 121).addBox(-12.0f, 2.0f, -1.0f, 4.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(64, 125).addBox(-8.0f, -5.0f, -4.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 64).addBox(-8.0f, -3.0f, -4.0f, 8.0f, 32.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-9.0f, (float)0.0f));
            rightArm.addOrReplaceChild("Crown_r4", CubeListBuilder.create().texOffs(64, 125).addBox(-7.0f, -2.0f, -1.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-3.0f, (float)3.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
            rightArm.addOrReplaceChild("Crown_r5", CubeListBuilder.create().texOffs(64, 125).addBox(-7.0f, -2.0f, -1.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
            rightArm.addOrReplaceChild("Crown_r6", CubeListBuilder.create().texOffs(64, 125).addBox(-7.0f, -2.0f, -1.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-3.0f, (float)3.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
            PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -7.5f, -7.7143f, 16.0f, 48.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(88, 119).addBox(-14.0f, 1.5f, -0.7143f, 6.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(100, 118).addBox(8.0f, 8.5f, -0.7143f, 6.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(56, 125).addBox(-8.0f, -10.5f, -7.7143f, 16.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-32.5f, (float)-0.2857f));
            body.addOrReplaceChild("Crown_r7", CubeListBuilder.create().texOffs(56, 125).addBox(-15.0f, -3.0f, -1.0f, 16.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-7.5f, (float)-6.7143f, (float)0.0f, (float)1.5708f, (float)0.0f));
            body.addOrReplaceChild("Crown_r8", CubeListBuilder.create().texOffs(56, 125).addBox(-15.0f, -3.0f, -1.0f, 16.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-7.5f, (float)7.2857f, (float)0.0f, (float)3.1416f, (float)0.0f));
            body.addOrReplaceChild("Crown_r9", CubeListBuilder.create().texOffs(56, 125).addBox(-15.0f, -3.0f, -1.0f, 16.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-7.5f, (float)7.2857f, (float)0.0f, (float)-1.5708f, (float)0.0f));
            LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
            Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"create(...)");
            return layerDefinition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

